/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.credentials;

import org.eclipse.egit.core.credentials.CredentialsUI;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.LoginService;
import org.eclipse.egit.ui.internal.dialogs.CustomPromptDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;

@Component(immediate=false)
public class EGitCredentialsUI
implements CredentialsUI {
    public boolean fillCredentials(URIish uri, CredentialItem ... items) {
        if (items.length == 0) {
            return true;
        }
        boolean[] result = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
            blArray[0] = items.length == 1 ? this.getSingleSpecial(shell, uri, items[0]) : this.getMultiSpecial(shell, uri, items);
        });
        return result[0];
    }

    private boolean getSingleSpecial(Shell shell, URIish uri, CredentialItem item) {
        if (item instanceof CredentialItem.InformationalMessage) {
            MessageDialog.openInformation((Shell)shell, (String)UIText.EGitCredentialsProvider_information, (String)item.getPromptText());
            return true;
        }
        if (item instanceof CredentialItem.YesNoType) {
            CredentialItem.YesNoType v = (CredentialItem.YesNoType)item;
            String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            int[] resultIDs = new int[]{2, 3, 1};
            MessageDialog dialog = new MessageDialog(shell, UIText.EGitCredentialsProvider_question, null, item.getPromptText(), 6, labels, 0);
            int r = dialog.open();
            if (r < 0) {
                return false;
            }
            switch (resultIDs[r]) {
                case 2: {
                    v.setValue(true);
                    return true;
                }
                case 3: {
                    v.setValue(false);
                    return true;
                }
            }
            return false;
        }
        return this.getMultiSpecial(shell, uri, item);
    }

    private boolean getMultiSpecial(Shell shell, URIish uri, CredentialItem ... items) {
        CustomPromptDialog dialog = new CustomPromptDialog(shell, uri, UIText.EGitCredentialsProvider_information, items);
        return dialog.open() == 0;
    }

    public UserPasswordCredentials getCredentials(URIish uri) {
        UserPasswordCredentials[] credentials = new UserPasswordCredentials[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
            userPasswordCredentialsArray[0] = LoginService.login(shell, uri);
        });
        return credentials[0];
    }
}

