/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.CompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSource;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;

public final class BeginEndRule
extends Rule {
    private final RegExpSource begin;
    public final List<@Nullable CaptureRule> beginCaptures;
    private final RegExpSource end;
    public final List<@Nullable CaptureRule> endCaptures;
    public final boolean endHasBackReferences;
    private final boolean applyEndPatternLast;
    final boolean hasMissingPatterns;
    final int[] patterns;
    private @Nullable RegExpSourceList cachedCompiledPatterns;

    BeginEndRule(int id, @Nullable String name, @Nullable String contentName, String begin, List<@Nullable CaptureRule> beginCaptures, @Nullable String end, List<@Nullable CaptureRule> endCaptures, boolean applyEndPatternLast, CompilePatternsResult patterns) {
        super(id, name, contentName);
        this.begin = new RegExpSource(begin, this.id);
        this.beginCaptures = beginCaptures;
        this.end = new RegExpSource(end == null ? "\uffff" : end, -1);
        this.endHasBackReferences = this.end.hasBackReferences;
        this.endCaptures = endCaptures;
        this.applyEndPatternLast = applyEndPatternLast;
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
    }

    public String getEndWithResolvedBackReferences(String lineText, OnigCaptureIndex[] captureIndices) {
        return this.end.resolveBackReferences(lineText, captureIndices);
    }

    @Override
    public void collectPatternsRecursive(IRuleRegistry grammar, RegExpSourceList out, boolean isFirst) {
        if (isFirst) {
            int[] nArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                int pattern = nArray[n2];
                Rule rule = grammar.getRule(pattern);
                rule.collectPatternsRecursive(grammar, out, false);
                ++n2;
            }
        } else {
            out.add(this.begin);
        }
    }

    @Override
    public CompiledRule compile(IRuleRegistry grammar, @Nullable String endRegexSource) {
        return this.getCachedCompiledPatterns(grammar, endRegexSource).compile();
    }

    @Override
    public CompiledRule compileAG(IRuleRegistry grammar, @Nullable String endRegexSource, boolean allowA, boolean allowG) {
        return this.getCachedCompiledPatterns(grammar, endRegexSource).compileAG(allowA, allowG);
    }

    private RegExpSourceList getCachedCompiledPatterns(IRuleRegistry grammar, @Nullable String endRegexSource) {
        RegExpSourceList cachedCompiledPatterns = this.cachedCompiledPatterns;
        if (cachedCompiledPatterns == null) {
            cachedCompiledPatterns = new RegExpSourceList();
            this.collectPatternsRecursive(grammar, cachedCompiledPatterns, true);
            if (this.applyEndPatternLast) {
                cachedCompiledPatterns.add(this.endHasBackReferences ? this.end.clone() : this.end);
            } else {
                cachedCompiledPatterns.remove(this.endHasBackReferences ? this.end.clone() : this.end);
            }
            this.cachedCompiledPatterns = cachedCompiledPatterns;
        }
        if (this.endHasBackReferences && endRegexSource != null) {
            if (this.applyEndPatternLast) {
                cachedCompiledPatterns.setSource(cachedCompiledPatterns.length() - 1, endRegexSource);
            } else {
                cachedCompiledPatterns.setSource(0, endRegexSource);
            }
        }
        return cachedCompiledPatterns;
    }
}

