/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Type;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;
import org.eclipse.wtp.releng.tools.component.ui.internal.editor.APIDialog;
import org.eclipse.wtp.releng.tools.component.ui.internal.editor.ComponentXMLEditor;
import org.eclipse.wtp.releng.tools.component.ui.internal.editor.ComponentXMLProvider;

public class APIPage
extends FormPage {
    public static final String ID = "org.eclipse.wtp.releng.tools.component.ui.internal.editor.APIPage";
    private final char KEY_DEL = (char)127;
    private Button isAPI;
    private Button isExclusive;
    private Button reference;
    private Button subclass;
    private Button implement;
    private Button instantiate;
    private Tree apis;
    private TreeViewer apisViewer;

    public APIPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public APIPage(String id, String title) {
        super(id, title);
    }

    private void init() {
        ComponentXML compXML = ((ComponentXMLEditor)this.getEditor()).getComponentXML();
        this.apisViewer = new TreeViewer(this.apis);
        ComponentXMLProvider apisProvider = new ComponentXMLProvider(2);
        this.apisViewer.setContentProvider((IContentProvider)apisProvider);
        this.apisViewer.setLabelProvider((IBaseLabelProvider)apisProvider);
        this.apisViewer.setInput((Object)compXML);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ComponentManager manager = ComponentManager.getManager();
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(manager.getMessage("PAGE_API"));
        Composite body = form.getBody();
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        gl.marginWidth = 10;
        gl.verticalSpacing = 20;
        gl.horizontalSpacing = 20;
        body.setLayout((Layout)gl);
        FormToolkit toolkit = managedForm.getToolkit();
        this.createLeftColumn(managedForm, toolkit.createComposite(body));
        this.createRightColumn(managedForm, toolkit.createComposite(body));
        toolkit.paintBordersFor(body);
        this.init();
    }

    private void createLeftColumn(IManagedForm managedForm, Composite parent) {
        this.createAPIs(managedForm, parent);
    }

    private void createRightColumn(IManagedForm managedForm, Composite parent) {
        this.createAPIUsages(managedForm, parent);
    }

    private void createAPIs(IManagedForm managedForm, Composite parent) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginWidth = 1;
        gl.marginHeight = 5;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        ComponentManager manager = ComponentManager.getManager();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.createLabel(parent, manager.getMessage("SECTION_DESC_APIS"));
        toolkit.createLabel(parent, manager.getMessage("LABEL_APIS"));
        Composite apiComposite = toolkit.createComposite(parent);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 2;
        gl2.marginWidth = 1;
        gl2.marginHeight = 1;
        apiComposite.setLayout((Layout)gl2);
        apiComposite.setLayoutData((Object)gd);
        this.apis = toolkit.createTree(apiComposite, 2);
        this.apis.setLayout((Layout)gl);
        this.apis.setLayoutData((Object)gd);
        this.apis.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                APIPage.this.selectAPIEvent(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                APIPage.this.selectAPIEvent(event);
            }
        });
        this.apis.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                APIPage.this.apiKeyEvent(event);
            }
        });
        Menu menu = new Menu((Control)this.apis);
        MenuItem addPackage = new MenuItem(menu, 64);
        addPackage.setText(manager.getMessage("LABEL_ADD_PACKAGE"));
        addPackage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                APIPage.this.addPackageEvent(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                APIPage.this.addPackageEvent(event);
            }
        });
        MenuItem addType = new MenuItem(menu, 64);
        addType.setText(manager.getMessage("LABEL_ADD_TYPE"));
        addType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                APIPage.this.addTypeEvent(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                APIPage.this.addTypeEvent(event);
            }
        });
        this.apis.setMenu(menu);
        toolkit.paintBordersFor(apiComposite);
        toolkit.paintBordersFor(parent);
    }

    private void createAPIUsages(IManagedForm managedForm, Composite parent) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginWidth = 1;
        gl.marginHeight = 5;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        ComponentManager manager = ComponentManager.getManager();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.createLabel(parent, manager.getMessage("SECTION_DESC_API_USAGES"));
        Composite usageComposite = toolkit.createComposite(parent);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 1;
        gl2.marginWidth = 10;
        gl2.marginHeight = 1;
        usageComposite.setLayout((Layout)gl2);
        usageComposite.setLayoutData((Object)gd);
        toolkit.createLabel(usageComposite, manager.getMessage("LABEL_PACKAGE_USAGE"));
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                APIPage.this.selectAPIUsageEvent(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                APIPage.this.selectAPIUsageEvent(event);
            }
        };
        this.isAPI = toolkit.createButton(usageComposite, manager.getMessage("LABEL_PACKAGE_API"), 32);
        this.isAPI.setEnabled(false);
        this.isAPI.addSelectionListener(listener);
        this.isExclusive = toolkit.createButton(usageComposite, manager.getMessage("LABEL_PACKAGE_EXCLUSIVE"), 32);
        this.isExclusive.setEnabled(false);
        this.isExclusive.addSelectionListener(listener);
        toolkit.createLabel(usageComposite, manager.getMessage("LABEL_TYPE_USAGE"));
        this.reference = toolkit.createButton(usageComposite, manager.getMessage("LABEL_REFERENCE"), 32);
        this.reference.setEnabled(false);
        this.reference.addSelectionListener(listener);
        this.subclass = toolkit.createButton(usageComposite, manager.getMessage("LABEL_SUBCLASS"), 32);
        this.subclass.setEnabled(false);
        this.subclass.addSelectionListener(listener);
        this.implement = toolkit.createButton(usageComposite, manager.getMessage("LABEL_IMPLEMENT"), 32);
        this.implement.setEnabled(false);
        this.implement.addSelectionListener(listener);
        this.instantiate = toolkit.createButton(usageComposite, manager.getMessage("LABEL_INSTANTIATE"), 32);
        this.instantiate.setEnabled(false);
        this.instantiate.addSelectionListener(listener);
        toolkit.paintBordersFor(parent);
    }

    private void addPackageEvent(SelectionEvent event) {
        TreeItem[] items = this.apis.getItems();
        ArrayList<String> ignoreNames = new ArrayList<String>(items.length);
        int i = 0;
        while (i < items.length) {
            ignoreNames.add(items[i].getText());
            ++i;
        }
        ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
        ComponentXML compXML = editor.getComponentXML();
        APIDialog dialog = new APIDialog(editor.getSite().getShell(), 0, compXML, null, ignoreNames);
        if (dialog.open() == 0) {
            editor.setDirty(true);
            this.apisViewer.refresh();
        }
    }

    private void addTypeEvent(SelectionEvent event) {
        Package pkg = null;
        TreeItem[] items = this.apis.getSelection();
        if (items.length > 0) {
            Object firstItem = items[0].getData();
            if (firstItem instanceof Package) {
                pkg = (Package)firstItem;
            } else if (firstItem instanceof Type) {
                pkg = (Package)items[0].getParentItem().getData();
            }
        }
        if (pkg != null) {
            Collection types = pkg.getTypes();
            ArrayList<String> ignoreNames = new ArrayList<String>(types.size());
            Iterator it = types.iterator();
            while (it.hasNext()) {
                ignoreNames.add(((Type)it.next()).getName());
            }
            ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
            ComponentXML compXML = editor.getComponentXML();
            APIDialog dialog = new APIDialog(editor.getSite().getShell(), 1, compXML, pkg, ignoreNames);
            if (dialog.open() == 0) {
                editor.setDirty(true);
                this.apisViewer.refresh();
            }
        }
    }

    private void selectAPIEvent(SelectionEvent event) {
        Object firstItem = this.getFirstSelection();
        if (firstItem instanceof Package) {
            Package pkg = (Package)firstItem;
            this.isAPI.setEnabled(true);
            this.isAPI.setSelection(pkg.isApi());
            this.isExclusive.setEnabled(true);
            this.isExclusive.setSelection(pkg.isExclusive());
            this.reference.setEnabled(false);
            this.reference.setSelection(false);
            this.subclass.setEnabled(false);
            this.subclass.setSelection(false);
            this.implement.setEnabled(false);
            this.implement.setSelection(false);
            this.instantiate.setEnabled(false);
            this.instantiate.setSelection(false);
        } else if (firstItem instanceof Type) {
            Type type = (Type)firstItem;
            this.isAPI.setEnabled(false);
            this.isAPI.setSelection(false);
            this.isExclusive.setEnabled(false);
            this.isExclusive.setSelection(false);
            this.reference.setEnabled(true);
            this.reference.setSelection(type.isReference());
            this.subclass.setEnabled(true);
            this.subclass.setSelection(type.isSubclass());
            this.implement.setEnabled(true);
            this.implement.setSelection(type.isImplement());
            this.instantiate.setEnabled(true);
            this.instantiate.setSelection(type.isInstantiate());
        } else {
            this.isAPI.setEnabled(false);
            this.isAPI.setSelection(false);
            this.isExclusive.setEnabled(false);
            this.isExclusive.setSelection(false);
            this.reference.setEnabled(false);
            this.reference.setSelection(false);
            this.subclass.setEnabled(false);
            this.subclass.setSelection(false);
            this.implement.setEnabled(false);
            this.implement.setSelection(false);
            this.instantiate.setEnabled(false);
            this.instantiate.setSelection(false);
        }
    }

    private void selectAPIUsageEvent(SelectionEvent event) {
        if (event.widget == this.isAPI) {
            ((Package)this.getFirstSelection()).setApi(this.isAPI.getSelection() ? null : Boolean.FALSE);
        } else if (event.widget == this.isExclusive) {
            ((Package)this.getFirstSelection()).setExclusive(this.isExclusive.getSelection() ? null : Boolean.FALSE);
        } else if (event.widget == this.reference) {
            ((Type)this.getFirstSelection()).setReference(this.reference.getSelection() ? null : Boolean.FALSE);
        } else if (event.widget == this.subclass) {
            ((Type)this.getFirstSelection()).setSubclass(this.subclass.getSelection() ? null : Boolean.FALSE);
        } else if (event.widget == this.implement) {
            ((Type)this.getFirstSelection()).setImplement(this.implement.getSelection() ? null : Boolean.FALSE);
        } else if (event.widget == this.instantiate) {
            ((Type)this.getFirstSelection()).setInstantiate(this.instantiate.getSelection() ? null : Boolean.FALSE);
        }
        ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
        editor.setDirty(true);
    }

    private Object getFirstSelection() {
        TreeItem[] items = this.apis.getSelection();
        if (items.length > 0) {
            return items[0].getData();
        }
        return null;
    }

    private void apiKeyEvent(KeyEvent event) {
        ComponentXML compXML = ((ComponentXMLEditor)this.getEditor()).getComponentXML();
        if (event.character == '\u007f') {
            TreeItem[] items = this.apis.getSelection();
            int i = 0;
            while (i < items.length) {
                Object item = items[i].getData();
                if (item instanceof Package) {
                    compXML.getPackages().remove(item);
                } else if (item instanceof Type) {
                    Iterator it = compXML.getPackages().iterator();
                    while (it.hasNext()) {
                        if (((Package)it.next()).getTypes().remove(item)) break;
                    }
                }
                ++i;
            }
            this.isAPI.setEnabled(false);
            this.isAPI.setSelection(false);
            this.isExclusive.setEnabled(false);
            this.isExclusive.setSelection(false);
            this.reference.setEnabled(false);
            this.reference.setSelection(false);
            this.subclass.setEnabled(false);
            this.subclass.setSelection(false);
            this.implement.setEnabled(false);
            this.implement.setSelection(false);
            this.instantiate.setEnabled(false);
            this.instantiate.setSelection(false);
            this.apisViewer.refresh();
            ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
            editor.setDirty(true);
        }
    }
}

