/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wtp.releng.tools.component.adopters.References;
import org.xml.sax.SAXException;

public class BreakageReport {
    List refs;

    public void addRefs(References ref) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        this.refs.add(ref);
    }

    public List getRefs() {
        if (this.refs == null) {
            return new ArrayList(0);
        }
        return new ArrayList(this.refs);
    }

    public void load(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        byte[] b = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int read = is.read(b);
        while (read != -1) {
            baos.write(b, 0, read);
            read = is.read(b);
        }
        is.close();
        String content = baos.toString();
        int start = content.indexOf("<references");
        int end = content.indexOf("</references>");
        int offset = "</references>".length();
        while (start != -1 && end != -1) {
            String s = content.substring(start, end + offset);
            References ref = new References();
            ref.load(new ByteArrayInputStream(s.getBytes()));
            this.addRefs(ref);
            content = content.substring(end + offset);
            start = content.indexOf("<references");
            end = content.indexOf("</references>");
        }
    }

    public void save(OutputStream os) throws IOException {
        byte[] content = this.toString().getBytes();
        os.write(content);
        os.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<breakageReport>");
        Iterator it = this.getRefs().iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        sb.append("</breakageReport>");
        return sb.toString();
    }
}

