/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;

public class ComponentRefDialog
extends Dialog
implements ITreeContentProvider {
    private List ignoreNames;
    private Tree compRefs;
    private String[] compNames;

    public ComponentRefDialog(Shell shell, List ignoreNames) {
        super(shell);
        this.ignoreNames = ignoreNames != null ? ignoreNames : new ArrayList(0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComponentManager.getManager().getMessage("DIALOG_TITLE_ADD_COMPONENT_REFS"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 250;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)gd);
        this.compRefs = new Tree(composite, 2818);
        this.compRefs.setLayout((Layout)gl);
        this.compRefs.setLayoutData((Object)new GridData(1808));
        TreeViewer compRefsViewer = new TreeViewer(this.compRefs);
        compRefsViewer.setContentProvider((IContentProvider)this);
        compRefsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        compRefsViewer.setInput((Object)new byte[0]);
        return composite;
    }

    protected void okPressed() {
        TreeItem[] items = this.compRefs.getSelection();
        this.compNames = new String[items.length];
        int i = 0;
        while (i < this.compNames.length) {
            this.compNames[i] = items[i].getText();
            ++i;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.compNames = new String[0];
        super.cancelPressed();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ComponentManager manager = ComponentManager.getManager();
        List compXMLs = manager.getComponentXMLs();
        ArrayList<String> compNames = new ArrayList<String>(compXMLs.size());
        Iterator it = compXMLs.iterator();
        while (it.hasNext()) {
            String compName = ((ComponentXML)it.next()).getName();
            if (this.ignoreNames.contains(compName)) continue;
            compNames.add(compName);
        }
        return compNames.toArray(new String[0]);
    }

    public String[] getCompNames() {
        return this.compNames;
    }
}

