/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.adopters.BreakageReport;
import org.eclipse.wtp.releng.tools.component.adopters.ClassRef;
import org.eclipse.wtp.releng.tools.component.adopters.FieldRef;
import org.eclipse.wtp.releng.tools.component.adopters.MethodRef;
import org.eclipse.wtp.releng.tools.component.adopters.Plugin2API;
import org.eclipse.wtp.releng.tools.component.adopters.PluginRef;
import org.eclipse.wtp.releng.tools.component.adopters.References;
import org.eclipse.wtp.releng.tools.component.api.API2ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;
import org.xml.sax.SAXException;

public class APIRefCompatibilityScanner
implements IPlatformRunnable {
    private String use;
    private String outputDir;
    private Map pluginId2APIInfo = new HashMap();
    private Map pkg2APIInfo = new HashMap();
    private BreakageReport breakageReport = new BreakageReport();
    private int cacheSize = 20;
    private List cachedIds = new ArrayList(this.cacheSize);
    private List cachedCompAPIs = new ArrayList(this.cacheSize);

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = APIRefCompatibilityScanner.addTrailingSeperator(outputDir);
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public void execute() {
        ILocation apiInfoLoc = Location.createLocation(new File(String.valueOf(this.outputDir) + "_tmp_componentapiref"));
        apiInfoLoc.accept(new ILocationVisitor(){

            public boolean accept(ILocation location) {
                if (location.getName().endsWith("api-info.xml")) {
                    ComponentAPI compAPI = new ComponentAPI();
                    compAPI.setLocation(location);
                    try {
                        compAPI.load();
                        APIRefCompatibilityScanner.this.pluginId2APIInfo.put(compAPI.getName(), location);
                        Iterator it = compAPI.getPackageAPIs().iterator();
                        while (it.hasNext()) {
                            String pkgName = ((PackageAPI)it.next()).getName();
                            ArrayList<ILocation> locations = (ArrayList<ILocation>)APIRefCompatibilityScanner.this.pkg2APIInfo.get(pkgName);
                            if (locations == null) {
                                locations = new ArrayList<ILocation>();
                                APIRefCompatibilityScanner.this.pkg2APIInfo.put(pkgName, locations);
                            }
                            locations.add(location);
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return true;
            }
        });
        ILocation useLoc = Location.createLocation(new File(this.use));
        useLoc.accept(new ILocationVisitor(){

            public boolean accept(ILocation location) {
                if (location.getName().endsWith(".xml")) {
                    try {
                        References refs = new References();
                        refs.load(location.getInputStream());
                        Iterator it = refs.getPluginRefs().iterator();
                        while (it.hasNext()) {
                            PluginRef pluginRef = (PluginRef)it.next();
                            String pluginId = pluginRef.getId();
                            ILocation loc = (ILocation)APIRefCompatibilityScanner.this.pluginId2APIInfo.get(pluginId);
                            if (loc == null) continue;
                            ComponentAPI compAPI = new ComponentAPI();
                            compAPI.setLocation(loc);
                            compAPI.load();
                            Iterator it2 = pluginRef.getClassRefs().iterator();
                            while (it2.hasNext()) {
                                String desc;
                                String name;
                                ClassAPI classAPI;
                                int i;
                                ClassRef classRef = (ClassRef)it2.next();
                                String className = classRef.getName();
                                if (className.endsWith("[]")) {
                                    className = className.substring(0, className.length() - 2);
                                }
                                String pkgName = (i = className.lastIndexOf(46)) != -1 ? className.substring(0, i) : "";
                                String localName = i != -1 ? className.substring(i + 1) : className;
                                PackageAPI pkgAPI = compAPI.getPackageAPI(pkgName);
                                if (pkgAPI == null || (classAPI = pkgAPI.getClassAPI(localName)) == null) continue;
                                Iterator it3 = classRef.getMethodRefs().iterator();
                                while (it3.hasNext()) {
                                    MethodRef methodRef = (MethodRef)it3.next();
                                    name = methodRef.getName();
                                    if (!APIRefCompatibilityScanner.this.hasMethod(classAPI, name, desc = methodRef.getDescriptor())) continue;
                                    classRef.removeMethodRef(name, desc);
                                }
                                it3 = classRef.getFieldRefs().iterator();
                                while (it3.hasNext()) {
                                    FieldRef fieldRef = (FieldRef)it3.next();
                                    name = fieldRef.getName();
                                    desc = fieldRef.getDescriptor();
                                    if (!APIRefCompatibilityScanner.this.hasField(classAPI, name)) continue;
                                    classRef.removeFieldRef(name, desc);
                                }
                                if (!classRef.getMethodRefs().isEmpty() || !classRef.getFieldRefs().isEmpty()) continue;
                                pluginRef.removeClassRef(classRef.getName());
                            }
                            if (!pluginRef.getClassRefs().isEmpty()) continue;
                            refs.removePluginRef(pluginId);
                        }
                        if (!refs.getPluginRefs().isEmpty()) {
                            APIRefCompatibilityScanner.this.breakageReport.addRefs(refs);
                        }
                    }
                    catch (ParserConfigurationException pce) {
                        throw new RuntimeException(pce);
                    }
                    catch (SAXException saxe) {
                        throw new RuntimeException(saxe);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return true;
            }
        });
        try {
            this.save();
            this.genHTML();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private boolean hasMethod(ClassAPI classAPI, String name, String desc) {
        if (classAPI != null && name != null && desc != null) {
            if (classAPI.getMethodAPI(name, desc) != null) {
                return true;
            }
            String superClassName = classAPI.getSuperClass();
            if (this.hasMethod(superClassName, name, desc)) {
                return true;
            }
            Iterator it = classAPI.getInterfaces().iterator();
            while (it.hasNext()) {
                if (!this.hasMethod(it.next().toString(), name, desc)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean hasMethod(String className, String name, String desc) {
        int i = className.lastIndexOf(46);
        String pkgName = i != -1 ? className.substring(0, i) : "";
        String localName = i != -1 ? className.substring(i + 1) : className;
        List locations = (List)this.pkg2APIInfo.get(pkgName);
        if (locations != null) {
            Iterator it = locations.iterator();
            while (it.hasNext()) {
                ILocation location = (ILocation)it.next();
                try {
                    ClassAPI superClassAPI;
                    PackageAPI pkgAPI;
                    ComponentAPI compAPI = this.getComponentAPI(location);
                    if (compAPI == null || (pkgAPI = compAPI.getPackageAPI(pkgName)) == null || (superClassAPI = pkgAPI.getClassAPI(localName)) == null) continue;
                    return this.hasMethod(superClassAPI, name, desc);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        } else {
            ClassAPI superClassAPI = this.loadClass(className);
            if (superClassAPI != null) {
                return this.hasMethod(superClassAPI, name, desc);
            }
        }
        return false;
    }

    private boolean hasField(ClassAPI classAPI, String name) {
        if (classAPI != null && name != null) {
            if (classAPI.getFieldAPI(name) != null) {
                return true;
            }
            String superClassName = classAPI.getSuperClass();
            if (this.hasField(superClassName, name)) {
                return true;
            }
            Iterator it = classAPI.getInterfaces().iterator();
            while (it.hasNext()) {
                if (!this.hasField(it.next().toString(), name)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean hasField(String className, String name) {
        int i = className.lastIndexOf(46);
        String pkgName = i != -1 ? className.substring(0, i) : "";
        String localName = i != -1 ? className.substring(i + 1) : className;
        List locations = (List)this.pkg2APIInfo.get(pkgName);
        if (locations != null) {
            Iterator it = locations.iterator();
            while (it.hasNext()) {
                ILocation location = (ILocation)it.next();
                try {
                    ClassAPI superClassAPI;
                    PackageAPI pkgAPI;
                    ComponentAPI compAPI = this.getComponentAPI(location);
                    if (compAPI == null || (pkgAPI = compAPI.getPackageAPI(pkgName)) == null || (superClassAPI = pkgAPI.getClassAPI(localName)) == null) continue;
                    return this.hasField(superClassAPI, name);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        } else {
            ClassAPI superClassAPI = this.loadClass(className);
            if (superClassAPI != null) {
                return this.hasField(superClassAPI, name);
            }
        }
        return false;
    }

    private ClassAPI loadClass(String className) {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(className);
            ClassAPI classAPI = new ClassAPI();
            classAPI.setName(className);
            if (className.equals("java.lang.Object")) {
                classAPI.setSuperClass("");
            } else {
                classAPI.setSuperClass("java.lang.Object");
            }
            Method[] publicMethods = clazz.getMethods();
            Field[] publicFields = clazz.getFields();
            int j = 0;
            while (j < publicMethods.length) {
                MethodAPI methodAPI = new MethodAPI();
                methodAPI.setName(publicMethods[j].getName());
                StringBuffer descriptor = new StringBuffer();
                descriptor.append('(');
                Class<?>[] params = publicMethods[j].getParameterTypes();
                int k = 0;
                while (k < params.length) {
                    String paramName = params[k].getName().replace('.', '/');
                    if (paramName.charAt(0) == '[') {
                        descriptor.append(paramName);
                    } else {
                        descriptor.append(Signature.createTypeSignature((String)paramName, (boolean)true));
                    }
                    ++k;
                }
                descriptor.append(')');
                Class<?> returnType = publicMethods[j].getReturnType();
                if (returnType != null) {
                    String returnTypeName = returnType.getName().replace('.', '/');
                    if (returnTypeName.charAt(0) == '[') {
                        descriptor.append(returnTypeName);
                    } else {
                        descriptor.append(Signature.createTypeSignature((String)returnTypeName, (boolean)true));
                    }
                } else {
                    descriptor.append('V');
                }
                methodAPI.setDescriptor(descriptor.toString());
                classAPI.addMethodAPI(methodAPI);
                ++j;
            }
            j = 0;
            while (j < publicFields.length) {
                FieldAPI fieldAPI = new FieldAPI();
                fieldAPI.setName(publicFields[j].getName());
                classAPI.addFieldAPI(fieldAPI);
                ++j;
            }
            return classAPI;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private ComponentAPI getComponentAPI(ILocation location) throws IOException {
        int index = this.cachedIds.indexOf(location);
        if (index != -1) {
            ComponentAPI compAPI = (ComponentAPI)this.cachedCompAPIs.get(index);
            if (index != 0) {
                this.cachedIds.remove(index);
                this.cachedCompAPIs.remove(index);
                this.cachedIds.add(0, location);
                this.cachedCompAPIs.add(0, compAPI);
            }
            return compAPI;
        }
        ComponentAPI compAPI = new ComponentAPI();
        compAPI.setLocation(location);
        compAPI.load();
        if (this.cachedCompAPIs.size() == this.cacheSize) {
            this.cachedIds.remove(this.cacheSize - 1);
            this.cachedCompAPIs.remove(this.cacheSize - 1);
        }
        this.cachedIds.add(0, location);
        this.cachedCompAPIs.add(0, compAPI);
        return compAPI;
    }

    public void save() throws IOException {
        File file = new File(String.valueOf(this.outputDir) + "api-ref-compatibility.xml");
        file.getParentFile().mkdirs();
        this.breakageReport.save(new FileOutputStream(file));
    }

    private void genHTML() {
        try {
            XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource("org/eclipse/wtp/releng/tools/component/xsl/api-ref-compatibility.xsl").openStream(), new ByteArrayInputStream(this.breakageReport.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "api-ref-compatibility.html")), this.outputDir);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected static String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public Object run(Object arguments) {
        String src = System.getProperty("src");
        String use = System.getProperty("use");
        String outputDir = System.getProperty("outputDir");
        ArrayList<String> args = new ArrayList<String>();
        if (src != null) {
            args.add("-src");
            args.addAll(this.tokenize(src));
        }
        if (use != null) {
            args.add("-use");
            args.addAll(this.tokenize(use));
        }
        args.add("-outputDir");
        args.add(outputDir);
        try {
            APIRefCompatibilityScanner.main(args.toArray(new String[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return IPlatformRunnable.EXIT_OK;
    }

    private List tokenize(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> tokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection src = (Collection)options.get("src");
        Collection use = (Collection)options.get("use");
        Collection outputDir = (Collection)options.get("outputDir");
        if (src == null || use == null || outputDir == null || src.isEmpty() || use.isEmpty() || outputDir.isEmpty()) {
            APIRefCompatibilityScanner.printUsage();
            System.exit(-1);
        }
        String outputDirString = APIRefCompatibilityScanner.addTrailingSeperator((String)outputDir.iterator().next());
        String componentxmlref = String.valueOf(outputDirString) + "_tmp_componentxmlref";
        String componentapiref = String.valueOf(outputDirString) + "_tmp_componentapiref";
        Plugin2API plugin2API = new Plugin2API();
        plugin2API.setSrc(src);
        plugin2API.setOutputDir(componentxmlref);
        plugin2API.execute();
        API2ComponentAPI api2CompAPI = new API2ComponentAPI();
        api2CompAPI.setApi(componentxmlref);
        api2CompAPI.setOutputDir(componentapiref);
        api2CompAPI.setIncludeInnerClass(true);
        api2CompAPI.setIncludeInterfaces(true);
        Iterator it = src.iterator();
        while (it.hasNext()) {
            api2CompAPI.setSrc((String)it.next());
            api2CompAPI.execute();
        }
        APIRefCompatibilityScanner scanner = new APIRefCompatibilityScanner();
        scanner.setUse((String)use.iterator().next());
        scanner.setOutputDir(outputDirString);
        scanner.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.adopters.APIRefCompatibilityScanner -src <src> -use <use> -outputDir <outputDir> [-options]");
        System.out.println("");
        System.out.println("\t-src\t\t<src>\t\tlocation of your Eclipse-based product");
        System.out.println("\t-use\t\t<use>\t\tlocation of adopters' API usage data");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory");
    }
}

