/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal;

import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.contentassist.NoRegionContentAssistProcessor;
import org.eclipse.wst.xsl.core.internal.text.rules.StructuredTextPartitionerForXSL;
import org.eclipse.wst.xsl.ui.internal.contentassist.XSLContentAssistProcessor;
import org.eclipse.wst.xsl.ui.internal.editor.XSLHyperlinkDetector;
import org.eclipse.wst.xsl.ui.internal.style.LineStyleProviderForXSL;

public class StructuredTextViewerConfigurationXSL
extends StructuredTextViewerConfigurationXML {
    private String[] fConfiguredContentTypes;
    private LineStyleProvider fLineStyleProviderForXSL;

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (partitionType.equals("org.eclipse.wst.sse.ST_DEFAULT") || partitionType.equals("org.eclipse.wst.xml.XML_DEFAULT") || partitionType.equals("org.eclipse.wst.xsl.XSL_XPATH")) {
            processors = new IContentAssistProcessor[]{new XSLContentAssistProcessor()};
        } else if (partitionType.equals("org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE")) {
            processors = new IContentAssistProcessor[]{new NoRegionContentAssistProcessor()};
        }
        return processors;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] superDetectors = super.getHyperlinkDetectors(sourceViewer);
        IHyperlinkDetector[] allDetectors = new IHyperlinkDetector[superDetectors.length + 1];
        allDetectors[0] = new XSLHyperlinkDetector();
        System.arraycopy(superDetectors, 0, allDetectors, 1, superDetectors.length);
        return allDetectors;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.fConfiguredContentTypes == null) {
            String[] xslTypes = StructuredTextPartitionerForXSL.getConfiguredContentTypes();
            this.fConfiguredContentTypes = new String[xslTypes.length + 2];
            this.fConfiguredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.fConfiguredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int index = 0;
            System.arraycopy(xslTypes, 0, this.fConfiguredContentTypes, index += 2, xslTypes.length);
        }
        return this.fConfiguredContentTypes;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        if (this.isXMLPartition(partitionType)) {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForXSL()};
        }
        return providers;
    }

    private boolean isXMLPartition(String partitionType) {
        return partitionType.equals("org.eclipse.wst.xml.XML_DEFAULT") || partitionType.equals("org.eclipse.wst.xml.XML_CDATA") || partitionType.equals("org.eclipse.wst.xml.XML_COMMENT") || partitionType.equals("org.eclipse.wst.xml.XML_DECL") || partitionType.equals("org.eclipse.wst.xml.XML_PI") || partitionType.equals("org.eclipse.wst.xsl.XSL_XPATH");
    }

    protected LineStyleProvider getLineStyleProviderForXSL() {
        if (this.fLineStyleProviderForXSL == null) {
            this.fLineStyleProviderForXSL = new LineStyleProviderForXSL();
        }
        return this.fLineStyleProviderForXSL;
    }
}

