/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.invoker;

import org.eclipse.wst.xsl.jaxp.debug.invoker.Messages;
import org.eclipse.wst.xsl.jaxp.debug.invoker.internal.CreationException;

public class TypedValue {
    public static final String TYPE_STRING = "string";
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_INT = "int";
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_FLOAT = "float";
    private static final String TYPE_CLASS = "class";
    private static final String TYPE_OBJECT = "object";
    final String uri;
    final String type;
    final String value;

    public TypedValue(String uri, String type, String value) {
        this.uri = uri;
        this.type = type;
        this.value = value;
    }

    public Object createValue() throws CreationException {
        Class<?> o = null;
        if (TYPE_STRING.equals(this.type)) {
            o = this.value;
        } else if (TYPE_BOOLEAN.equals(this.type)) {
            boolean b = "yes".equalsIgnoreCase(this.value) || "true".equalsIgnoreCase(this.value);
            o = new Boolean(b);
        } else if (TYPE_INT.equals(this.type)) {
            try {
                o = new Integer(this.value);
            }
            catch (NumberFormatException e) {
                throw new CreationException(String.valueOf(Messages.getString("TypedValue.9")) + this.value + Messages.getString("TypedValue.10"), e);
            }
        } else if (TYPE_DOUBLE.equals(this.type)) {
            try {
                o = new Double(this.value);
            }
            catch (NumberFormatException e) {
                throw new CreationException(String.valueOf(Messages.getString("TypedValue.11")) + this.value + Messages.getString("TypedValue.12"), e);
            }
        } else if (TYPE_FLOAT.equals(this.type)) {
            try {
                o = new Float(this.value);
            }
            catch (NumberFormatException e) {
                throw new CreationException(String.valueOf(Messages.getString("TypedValue.13")) + this.value + Messages.getString("TypedValue.14"), e);
            }
        } else if (TYPE_CLASS.equals(this.type)) {
            try {
                o = Class.forName(this.value);
            }
            catch (ClassNotFoundException e) {
                throw new CreationException(String.valueOf(Messages.getString("TypedValue.15")) + this.value + Messages.getString("TypedValue.16"), e);
            }
        } else if (TYPE_OBJECT.equals(this.type)) {
            try {
                Class<?> c = Class.forName(this.value);
                o = c.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new CreationException(String.valueOf(Messages.getString("TypedValue.17")) + this.value + Messages.getString("TypedValue.18"), e);
            }
            catch (InstantiationException e) {
                throw new CreationException(String.valueOf(Messages.getString("TypedValue.19")) + this.value + Messages.getString("TypedValue.20"), e);
            }
            catch (IllegalAccessException e) {
                throw new CreationException(String.valueOf(Messages.getString("TypedValue.21")) + this.value + Messages.getString("TypedValue.22"), e);
            }
        } else {
            throw new CreationException(String.valueOf(Messages.getString("TypedValue.23")) + this.type + Messages.getString("TypedValue.24"));
        }
        return o;
    }
}

