/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import java.net.URL;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.function.FnFunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.function.XSCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.function.XDTCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;

public class TestXPath20
extends AbstractPsychoPathTest {
    protected void setUp() throws Exception {
        super.setUp();
        URL fileURL = this.bundle.getEntry("/TestSources/acme_corp.xml");
        this.loadDOMDocument(fileURL);
    }

    public void testLoadXML() throws Exception {
        TestXPath20.assertNotNull((Object)this.domDoc);
    }

    public void testSetupNullContenxt() throws Exception {
        DefaultDynamicContext dc = new DefaultDynamicContext(null, this.domDoc);
        dc.add_namespace("xsd", "http://www.w3.org/2001/XMLSchema");
        dc.add_namespace("xdt", "http://www.w3.org/2004/10/xpath-datatypes");
    }

    public void testAddLibraries() throws Exception {
        DefaultDynamicContext dc = new DefaultDynamicContext(null, this.domDoc);
        dc.add_namespace("xsd", "http://www.w3.org/2001/XMLSchema");
        dc.add_namespace("xdt", "http://www.w3.org/2004/10/xpath-datatypes");
        dc.add_function_library((FunctionLibrary)new FnFunctionLibrary());
        dc.add_function_library((FunctionLibrary)new XSCtrLibrary());
        dc.add_function_library((FunctionLibrary)new XDTCtrLibrary());
    }

    public void testParseInvalidXPathExpression() throws Exception {
        try {
            JFlexCupParser xpp = new JFlexCupParser();
            String xpath = "for  in /order/item return $x/price * $x/quantity";
            xpp.parse(xpath);
            TestXPath20.fail((String)"XPath parsing suceeded when it should have failed.");
        }
        catch (XPathParserException xPathParserException) {}
    }

    public void testParseValidXPathExpression() throws Exception {
        JFlexCupParser xpp = new JFlexCupParser();
        String xpath = "some $x in /students/student/name satisfies $x = \"Fred\"";
        xpp.parse(xpath);
    }

    public void testProcessSimpleXpath() throws Exception {
        XSModel schema = this.getGrammar();
        DynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "/employees/employee[1]/location";
        XPath path = this.compileXPath(dc, xpath);
        DefaultEvaluator eval = new DefaultEvaluator(dc, this.domDoc);
        ResultSequence rs = eval.evaluate((XPathNode)path);
        ElementType result = (ElementType)rs.first();
        String resultValue = result.node_value().getTextContent();
        TestXPath20.assertEquals((String)"Unexpected value returned", (String)"Boston", (String)resultValue);
    }
}

