/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompoundEditExitStrategy;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompoundEditListener;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;

public class JavaMoveLinesAction
extends TextEditorAction {
    private final boolean fUpwards;
    private final boolean fCopy;
    private final SharedState fSharedState;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static JavaMoveLinesAction[] createMoveCopyActionSet(ResourceBundle bundle, CompilationUnitEditor editor) {
        SharedState state = new SharedState(editor);
        JavaMoveLinesAction[] actions = new JavaMoveLinesAction[]{new JavaMoveLinesAction(bundle, "Editor.MoveLinesUp.", true, false, state), new JavaMoveLinesAction(bundle, "Editor.MoveLinesDown.", false, false, state), new JavaMoveLinesAction(bundle, "Editor.CopyLineUp.", true, true, state), new JavaMoveLinesAction(bundle, "Editor.CopyLineDown.", false, true, state)};
        return actions;
    }

    public void setEditor(ITextEditor editor) {
        Assert.isTrue((boolean)(editor instanceof CompilationUnitEditor));
        super.setEditor(editor);
        if (this.fSharedState != null) {
            this.fSharedState.fEditor = (CompilationUnitEditor)editor;
        }
    }

    private JavaMoveLinesAction(ResourceBundle bundle, String prefix, boolean upwards, boolean copy, SharedState state) {
        super(bundle, prefix, (ITextEditor)state.fEditor);
        this.fUpwards = upwards;
        this.fCopy = copy;
        this.fSharedState = state;
        this.update();
    }

    private boolean containedByVisibleRegion(ITextSelection selection, ISourceViewer viewer) {
        block7: {
            int visEnd;
            IDocument document;
            int max;
            block8: {
                int visOffset;
                IRegion visible;
                block5: {
                    int min;
                    block6: {
                        min = selection.getOffset();
                        max = min + selection.getLength();
                        document = viewer.getDocument();
                        visible = viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)viewer).getModelCoverage() : viewer.getVisibleRegion();
                        visOffset = visible.getOffset();
                        try {
                            if (visOffset <= min) break block5;
                            if (document.getLineOfOffset(visOffset) == selection.getStartLine()) break block6;
                            return false;
                        }
                        catch (BadLocationException badLocationException) {
                            return false;
                        }
                    }
                    if (this.isWhitespace(document.get(min, visOffset - min))) break block5;
                    this.showStatus();
                    return false;
                }
                visEnd = visOffset + visible.getLength();
                if (visEnd >= max) break block7;
                if (document.getLineOfOffset(visEnd) == selection.getEndLine()) break block8;
                return false;
            }
            if (this.isWhitespace(document.get(visEnd, max - visEnd))) break block7;
            this.showStatus();
            return false;
        }
        return true;
    }

    private ITextSelection getMovingSelection(IDocument document, ITextSelection selection, ISourceViewer viewer) throws BadLocationException {
        int low = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int high = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String delim = document.getLineDelimiter(endLine);
        if (delim != null) {
            high -= delim.length();
        }
        return new TextSelection(document, low, high - low);
    }

    private ITextSelection getSkippedLine(IDocument document, ITextSelection selection) {
        int skippedLineN;
        int n = skippedLineN = this.fUpwards ? selection.getStartLine() - 1 : selection.getEndLine() + 1;
        if (skippedLineN > document.getNumberOfLines() || !this.fCopy && (skippedLineN < 0 || skippedLineN == document.getNumberOfLines())) {
            return null;
        }
        try {
            if (this.fCopy && skippedLineN == -1) {
                skippedLineN = 0;
            }
            IRegion line = document.getLineInformation(skippedLineN);
            return new TextSelection(document, line.getOffset(), line.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runWithEvent(Event event) {
        if (this.fSharedState.fEditor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        ISourceViewer viewer = this.fSharedState.fEditor.getViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText widget = viewer.getTextWidget();
        if (widget == null) {
            return;
        }
        ITextSelection sel = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (sel.isEmpty()) {
            return;
        }
        ITextSelection skippedLine = this.getSkippedLine(document, sel);
        if (skippedLine == null) {
            return;
        }
        try {
            block24: {
                block22: {
                    try {
                        int offset;
                        String insertion;
                        ITextSelection movingArea = this.getMovingSelection(document, sel, viewer);
                        if (!this.containedByVisibleRegion(movingArea, viewer)) break block22;
                        if (!this.containedByVisibleRegion(skippedLine, viewer)) {
                            break block22;
                        }
                        String moving = movingArea.getText();
                        String skipped = skippedLine.getText();
                        if (moving == null || skipped == null || document.getLength() == 0) break block22;
                        if (this.fUpwards) {
                            String delim = document.getLineDelimiter(skippedLine.getEndLine());
                            if (this.fCopy) {
                                delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                                insertion = String.valueOf(moving) + delim;
                                offset = movingArea.getOffset();
                            } else {
                                Assert.isNotNull((Object)delim);
                                insertion = String.valueOf(moving) + delim + skipped;
                                offset = skippedLine.getOffset();
                            }
                        } else {
                            String delim = document.getLineDelimiter(movingArea.getEndLine());
                            if (this.fCopy) {
                                if (delim == null) {
                                    delim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                                    insertion = String.valueOf(delim) + moving;
                                } else {
                                    insertion = String.valueOf(moving) + delim;
                                }
                                offset = skippedLine.getOffset();
                            } else {
                                Assert.isNotNull((Object)delim);
                                insertion = String.valueOf(skipped) + delim + moving;
                                offset = movingArea.getOffset();
                            }
                        }
                        int lenght = this.fCopy ? 0 : insertion.length();
                        ILineRange selectionBefore = this.getLineRange(document, movingArea);
                        if (this.fCopy) {
                            this.fSharedState.endCompoundEdit();
                        }
                        this.fSharedState.beginCompoundEdit();
                        this.fSharedState.fIsChanging = true;
                        document.replace(offset, lenght, insertion);
                        Object selectionAfter = this.fUpwards && this.fCopy ? selectionBefore : (this.fUpwards ? new LineRange(selectionBefore.getStartLine() - 1, selectionBefore.getNumberOfLines()) : (this.fCopy ? new LineRange(selectionBefore.getStartLine() + selectionBefore.getNumberOfLines(), selectionBefore.getNumberOfLines()) : new LineRange(selectionBefore.getStartLine() + 1, selectionBefore.getNumberOfLines())));
                        this.fSharedState.fResult = IndentUtil.indentLines(document, selectionAfter, this.getProject(), this.fSharedState.fResult);
                        IRegion region = this.getRegion(document, (ILineRange)selectionAfter);
                        this.selectAndReveal((ITextViewer)viewer, region.getOffset(), region.getLength());
                        break block24;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                Object var17_8 = null;
                this.fSharedState.fIsChanging = false;
                if (!this.fCopy) return;
                this.fSharedState.endCompoundEdit();
                return;
            }
            Object var17_10 = null;
            this.fSharedState.fIsChanging = false;
            if (!this.fCopy) return;
            this.fSharedState.endCompoundEdit();
            return;
        }
        catch (Throwable throwable) {
            Object var17_9 = null;
            this.fSharedState.fIsChanging = false;
            if (!this.fCopy) throw throwable;
            this.fSharedState.endCompoundEdit();
            throw throwable;
        }
    }

    private IJavaScriptProject getProject() {
        IEditorInput editorInput = this.fSharedState.fEditor.getEditorInput();
        IJavaScriptUnit unit = JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (unit != null) {
            return unit.getJavaScriptProject();
        }
        return null;
    }

    private ILineRange getLineRange(IDocument document, ITextSelection selection) throws BadLocationException {
        int offset = selection.getOffset();
        int startLine = document.getLineOfOffset(offset);
        int endOffset = offset + selection.getLength();
        int endLine = document.getLineOfOffset(endOffset);
        int nLines = endLine - startLine + 1;
        return new LineRange(startLine, nLines);
    }

    private IRegion getRegion(IDocument document, ILineRange lineRange) throws BadLocationException {
        int endOffset;
        int startLine = lineRange.getStartLine();
        int offset = document.getLineOffset(startLine);
        int numberOfLines = lineRange.getNumberOfLines();
        if (numberOfLines < 1) {
            return new Region(offset, 0);
        }
        int endLine = startLine + numberOfLines - 1;
        if (this.fSharedState.fEditor.isBlockSelectionModeEnabled()) {
            IRegion endLineInfo = document.getLineInformation(endLine);
            endOffset = endLineInfo.getOffset() + endLineInfo.getLength();
        } else {
            endOffset = document.getLineOffset(endLine) + document.getLineLength(endLine);
        }
        return new Region(offset, endOffset - offset);
    }

    private void selectAndReveal(ITextViewer viewer, int offset, int length) {
        viewer.setSelectedRange(offset + length, -length);
        StyledText st = viewer.getTextWidget();
        if (st != null) {
            st.showSelection();
        }
    }

    private void showStatus() {
        IEditorStatusLine status;
        CompilationUnitEditor compilationUnitEditor = this.fSharedState.fEditor;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((status = (IEditorStatusLine)compilationUnitEditor.getAdapter(clazz)) == null) {
            return;
        }
        status.setMessage(false, JavaEditorMessages.Editor_MoveLines_IllegalMove_status, null);
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }

    private static final class SharedState {
        public CompilationUnitEditor fEditor;
        public IndentUtil.IndentResult fResult = null;
        boolean fIsChanging = false;
        private boolean fEditInProgress = false;
        private final CompoundEditExitStrategy fExitStrategy;

        public SharedState(CompilationUnitEditor editor) {
            this.fEditor = editor;
            this.fExitStrategy = new CompoundEditExitStrategy(new String[]{"org.eclipse.ui.edit.text.moveLineUp", "org.eclipse.ui.edit.text.moveLineDown", "org.eclipse.ui.edit.text.copyLineUp", "org.eclipse.ui.edit.text.copyLineDown"});
            this.fExitStrategy.addCompoundListener(new ICompoundEditListener(this){
                final /* synthetic */ SharedState this$1;
                {
                    this.this$1 = sharedState;
                }

                public void endCompoundEdit() {
                    this.this$1.endCompoundEdit();
                }
            });
        }

        public void beginCompoundEdit() {
            IRewriteTarget target;
            if (this.fEditInProgress || this.fEditor == null) {
                return;
            }
            this.fEditInProgress = true;
            this.fExitStrategy.arm((ITextViewer)this.fEditor.getViewer());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
                target.beginCompoundChange();
            }
        }

        public void endCompoundEdit() {
            IRewriteTarget target;
            if (!this.fEditInProgress || this.fEditor == null) {
                return;
            }
            this.fExitStrategy.disarm();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
                target.endCompoundChange();
            }
            this.fResult = null;
            this.fEditInProgress = false;
        }
    }
}

