/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyLabelDecorator;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.TreeTermination;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

class CallHierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private static final long TEXTFLAGS = 0x21000020002AL | JavaScriptElementLabels.ALL_POST_QUALIFIED | 0x2000000000L;
    private static final int IMAGEFLAGS = 3;
    private ILabelDecorator fDecorator = new CallHierarchyLabelDecorator();

    CallHierarchyLabelProvider() {
        super(TEXTFLAGS, 3);
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)element);
            if (methodWrapper.getMember() != null) {
                result = this.fDecorator.decorateImage(super.getImage(methodWrapper.getMember()), (Object)methodWrapper);
            }
        } else {
            if (this.isPendingUpdate(element)) {
                return null;
            }
            result = super.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        if (element instanceof MethodWrapper && ((MethodWrapper)((Object)element)).getMember() != null) {
            return this.getElementLabel((MethodWrapper)((Object)element));
        }
        return this.getSpecialLabel(element);
    }

    public ColoredString getRichTextLabel(Object element) {
        if (element instanceof MethodWrapper && ((MethodWrapper)((Object)element)).getMember() != null) {
            MethodWrapper wrapper = (MethodWrapper)((Object)element);
            String decorated = this.getElementLabel(wrapper);
            ColoredString text = super.getRichTextLabel(wrapper.getMember());
            return ColoredJavaElementLabels.decorateColoredString(text, decorated, ColoredJavaElementLabels.COUNTER_STYLE);
        }
        return new ColoredString(this.getSpecialLabel(element));
    }

    private String getSpecialLabel(Object element) {
        if (element instanceof MethodWrapper) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_root;
        }
        if (element == TreeTermination.SEARCH_CANCELED) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_searchCanceled;
        }
        if (this.isPendingUpdate(element)) {
            return CallHierarchyMessages.CallHierarchyLabelProvider_updatePending;
        }
        return CallHierarchyMessages.CallHierarchyLabelProvider_noMethodSelected;
    }

    private boolean isPendingUpdate(Object element) {
        return element instanceof IWorkbenchAdapter;
    }

    private String getElementLabel(MethodWrapper methodWrapper) {
        String label = super.getText(methodWrapper.getMember());
        Collection callLocations = methodWrapper.getMethodCall().getCallLocations();
        if (callLocations != null && callLocations.size() > 1) {
            return Messages.format(CallHierarchyMessages.CallHierarchyLabelProvider_matches, new String[]{label, String.valueOf(callLocations.size())});
        }
        return label;
    }
}

