/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class InterfaceIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ListenerList fListeners;
    private IElementChangedListener fChangeListener;

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fChangeListener == null) {
            this.fChangeListener = new IntefaceIndicatorChangeListener();
            JavaScriptCore.addElementChangedListener((IElementChangedListener)this.fChangeListener);
        }
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fChangeListener != null) {
            JavaScriptCore.removeElementChangedListener((IElementChangedListener)this.fChangeListener);
            this.fChangeListener = null;
        }
        if (this.fListeners != null) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                this.fListeners.remove(listeners[i]);
                ++i;
            }
            this.fListeners = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty() && this.fChangeListener != null) {
            JavaScriptCore.removeElementChangedListener((IElementChangedListener)this.fChangeListener);
            this.fChangeListener = null;
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            ImageDescriptor overlay = this.getOverlay(element);
            if (overlay == null) {
                return;
            }
            decoration.addOverlay(overlay, 1);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return;
        }
    }

    private ImageDescriptor getOverlay(Object element) throws JavaScriptModelException {
        if (element instanceof IJavaScriptUnit) {
            IJavaScriptUnit unit = (IJavaScriptUnit)element;
            if (unit.isOpen()) {
                IType mainType = unit.findPrimaryType();
                if (mainType != null) {
                    return this.getOverlayFromFlags(mainType.getFlags());
                }
                return null;
            }
            String typeName = JavaScriptCore.removeJavaScriptLikeExtension((String)unit.getElementName());
            return this.getOverlayWithSearchEngine((ITypeRoot)unit, typeName);
        }
        if (element instanceof IClassFile) {
            IClassFile classFile = (IClassFile)element;
            if (classFile.isOpen()) {
                return this.getOverlayFromFlags(classFile.getType().getFlags());
            }
            String typeName = classFile.getType().getElementName();
            return this.getOverlayWithSearchEngine((ITypeRoot)classFile, typeName);
        }
        return null;
    }

    private ImageDescriptor getOverlayWithSearchEngine(ITypeRoot element, String typeName) {
        class Result
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            int modifiers;

            public Result(int modifiers) {
                this.modifiers = modifiers;
            }
        }
        SearchEngine engine = new SearchEngine();
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{element});
        TypeNameRequestor requestor = new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (enclosingTypeNames.length == 0 && Flags.isPublic((int)modifiers)) {
                    throw new Result(modifiers);
                }
            }
        };
        try {
            String packName = element.getParent().getElementName();
            int matchRule = 8;
            engine.searchAllTypeNames(packName.toCharArray(), matchRule, typeName.toCharArray(), matchRule, 0, scope, requestor, 3, null);
        }
        catch (Result e) {
            return this.getOverlayFromFlags(e.modifiers);
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
        return null;
    }

    private ImageDescriptor getOverlayFromFlags(int flags) {
        if (Flags.isAnnotation((int)flags)) {
            return JavaPluginImages.DESC_OVR_ANNOTATION;
        }
        if (Flags.isEnum((int)flags)) {
            return JavaPluginImages.DESC_OVR_ENUM;
        }
        if (Flags.isInterface((int)flags)) {
            return JavaPluginImages.DESC_OVR_INTERFACE;
        }
        if (Flags.isAbstract((int)flags)) {
            return JavaPluginImages.DESC_OVR_ABSTRACT_CLASS;
        }
        return null;
    }

    private void fireChange(IJavaScriptElement[] elements) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])elements);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private void processDelta(IJavaScriptElementDelta delta, List result) {
        IJavaScriptElement elem = delta.getElement();
        boolean isChanged = delta.getKind() == 4;
        boolean isRemoved = delta.getKind() == 2;
        int flags = delta.getFlags();
        switch (elem.getElementType()) {
            case 2: {
                if (isRemoved || isChanged && (flags & 0x400) != 0) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 3: {
                if (isRemoved || isChanged && ((flags & 0x8000) != 0 || (flags & 0x80) != 0)) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 4: {
                if (isRemoved) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 6: 
            case 7: {
                return;
            }
            case 1: {
                this.processChildrenDelta(delta, result);
                return;
            }
            case 5: {
                if (!JavaModelUtil.isPrimary((IJavaScriptUnit)elem)) {
                    return;
                }
                if (isChanged && ((flags & 1) != 0 || (flags & 0x4000) != 0)) {
                    if (delta.getAffectedChildren().length == 0) {
                        return;
                    }
                    result.add(elem);
                }
                return;
            }
        }
    }

    private boolean processChildrenDelta(IJavaScriptElementDelta delta, List result) {
        IJavaScriptElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], result);
            ++i;
        }
        return false;
    }

    private class IntefaceIndicatorChangeListener
    implements IElementChangedListener {
        private IntefaceIndicatorChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            ArrayList changed = new ArrayList();
            InterfaceIndicatorLabelDecorator.this.processDelta(event.getDelta(), changed);
            if (changed.size() == 0) {
                return;
            }
            InterfaceIndicatorLabelDecorator.this.fireChange(changed.toArray(new IJavaScriptElement[changed.size()]));
        }
    }
}

