/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest;

public class ASTRewritingModifyingReplaceTest
extends ASTRewritingModifyingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingReplaceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingModifyingReplaceTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test suite() {
        return ASTRewritingModifyingReplaceTest.allTests();
    }

    public void test0001() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0001", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0001;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        SimpleName name = astRoot.getAST().newSimpleName("aaa");
        astRoot.getPackage().setName((Name)name);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package aaa;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ASTRewritingModifyingReplaceTest.assertEqualString(preview, buf.toString());
    }

    public void test0002() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0002", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0002;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        SimpleName name = a.newSimpleName("aaa");
        PackageDeclaration pack = a.newPackageDeclaration();
        pack.setName((Name)name);
        astRoot.setPackage(pack);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package aaa;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ASTRewritingModifyingReplaceTest.assertEqualString(preview, buf.toString());
    }

    public void test0003() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0003", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0003;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.lang.*;\n");
        buf.append("import java.awt.*;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        SimpleName name = astRoot.getAST().newSimpleName("aaa");
        List imports = astRoot.imports();
        ImportDeclaration imp = (ImportDeclaration)imports.get(0);
        imp.setName((Name)name);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0003;\n");
        buf.append("import aaa.*;\n");
        buf.append("import java.lang.*;\n");
        buf.append("import java.awt.*;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ASTRewritingModifyingReplaceTest.assertEqualString(preview, buf.toString());
    }

    public void test0004() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0004", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0004;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.lang.*;\n");
        buf.append("import java.awt.*;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        SimpleName name = astRoot.getAST().newSimpleName("AAA");
        TypeDeclaration t = (TypeDeclaration)types.get(0);
        t.setName(name);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0004;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.lang.*;\n");
        buf.append("import java.awt.*;\n");
        buf.append("public class AAA {\n");
        buf.append("}\n");
        ASTRewritingModifyingReplaceTest.assertEqualString(preview, buf.toString());
    }

    public void test0005() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0005", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0005;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = a.newTypeDeclaration();
        SimpleName name = a.newSimpleName("AAA");
        typeDeclaration.setName(name);
        types.set(1, typeDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0005;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class AAA {\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingReplaceTest.assertEqualString(preview, buf.toString());
    }

    public void test0006() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0006", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0006;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration1 = a.newTypeDeclaration();
        typeDeclaration1.setName(a.newSimpleName("A"));
        types.set(1, typeDeclaration1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0006;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class A {\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingReplaceTest.assertEqualString(preview, buf.toString());
    }
}

