/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest;

public class ASTRewritingModifyingRemoveTest
extends ASTRewritingModifyingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingRemoveTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingModifyingRemoveTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test suite() {
        return ASTRewritingModifyingRemoveTest.allTests();
    }

    public void test0001() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0001", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0001;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        astRoot.setPackage(null);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0002() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0002", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0002;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.lang.*;\n");
        buf.append("import java.awt.*;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List imports = astRoot.imports();
        imports.remove(0);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0002;\n");
        buf.append("import java.lang.*;\n");
        buf.append("import java.awt.*;\n");
        buf.append("public class X {\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0003() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0003", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0003;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        types.remove(1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0003;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0004() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0004", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0004;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration1 = a.newTypeDeclaration();
        typeDeclaration1.setName(a.newSimpleName("A"));
        types.add(1, typeDeclaration1);
        types.remove(1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0004;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Y {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("class Z {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0006() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0006", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0006;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    void foo() {\n");
        buf.append("        bar1();\n");
        buf.append("        \n");
        buf.append("        //comment1\n");
        buf.append("        bar2();//comment2\n");
        buf.append("        //comment3\n");
        buf.append("        bar3();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        FunctionDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Block body = methodDeclaration.getBody();
        List statements = body.statements();
        statements.remove(1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0006;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    void foo() {\n");
        buf.append("        bar1();\n");
        buf.append("        \n");
        buf.append("        //comment3\n");
        buf.append("        bar3();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0009() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0009", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0009;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    // comment1\n");
        buf.append("\n");
        buf.append("    // comment2\n");
        buf.append("    // comment3\n");
        buf.append("    void foo() {\n");
        buf.append("    }\n");
        buf.append("    // comment4\n");
        buf.append("    void foo2() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        FunctionDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        typeDeclaration.bodyDeclarations().remove(methodDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0009;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    // comment1\n");
        buf.append("\n");
        buf.append("    // comment4\n");
        buf.append("    void foo2() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0010() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0010", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0010;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("    // comment1\n");
        buf.append("\n");
        buf.append("    // comment2\n");
        buf.append("    // comment3\n");
        buf.append("    void foo() {\n");
        buf.append("    }\n");
        buf.append("    // comment4\n");
        buf.append("\n");
        buf.append("    // comment5\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        FunctionDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        typeDeclaration.bodyDeclarations().remove(methodDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0010;\n");
        buf.append("\n");
        buf.append("public class X {\n");
        buf.append("\n");
        buf.append("    // comment5\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }

    public void test0011() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0011", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test0011;\n");
        buf.append("public class X {\n");
        buf.append("    // one line comment\n");
        buf.append("    private void foo(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List types = astRoot.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        FunctionDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        typeDeclaration.bodyDeclarations().remove(methodDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("package test0011;\n");
        buf.append("public class X {\n");
        buf.append("    /**\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingRemoveTest.assertEqualString(preview, buf.toString());
    }
}

