/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingInsertBoundTest
extends ASTRewritingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingInsertBoundTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingInsertBoundTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingInsertBoundTest.allTests();
    }

    private FunctionDeclaration newMethodDeclaration(AST ast, String name) {
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        decl.setName(ast.newSimpleName(name));
        decl.setBody(null);
        return decl;
    }

    private FieldDeclaration newFieldDeclaration(AST ast, String name) {
        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
        frag.setName(ast.newSimpleName(name));
        FieldDeclaration decl = ast.newFieldDeclaration(frag);
        return decl;
    }

    public void testInsert1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertLast((ASTNode)decl2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function new1() {\n}\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testInsert3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        ASTNode middleDecl = (ASTNode)decls.get(1);
        ASTNode lastDecl = (ASTNode)decls.get(2);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertBefore((ASTNode)decl1, middleDecl, null);
        listRewrite.insertBefore((ASTNode)decl2, lastDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function new1() {\n    }\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testInsert2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        FunctionDeclaration decl3 = this.newMethodDeclaration(ast, "new3");
        FunctionDeclaration decl4 = this.newMethodDeclaration(ast, "new4");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertAfter((ASTNode)decl2, (ASTNode)decl1, null);
        listRewrite.insertLast((ASTNode)decl3, null);
        listRewrite.insertAfter((ASTNode)decl4, (ASTNode)decl3, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function new1() {\n}\n");
        buf.append("\n");
        buf.append("    function new2() {\n}\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("    function new3() {\n    }\n");
        buf.append("\n");
        buf.append("    function new4() {\n    }\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testInsert1Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertLast((ASTNode)decl2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var new1;\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("    var new2;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testInsert2Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        FieldDeclaration decl3 = this.newFieldDeclaration(ast, "new3");
        FieldDeclaration decl4 = this.newFieldDeclaration(ast, "new4");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertAfter((ASTNode)decl2, (ASTNode)decl1, null);
        listRewrite.insertLast((ASTNode)decl3, null);
        listRewrite.insertAfter((ASTNode)decl4, (ASTNode)decl3, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var new1;\n");
        buf.append("\n");
        buf.append("    var new2;\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("    var new3;\n");
        buf.append("\n");
        buf.append("    var new4;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testInsert3Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        ASTNode firstDecl = (ASTNode)decls.get(0);
        ASTNode middleDecl = (ASTNode)decls.get(1);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertAfter((ASTNode)decl1, firstDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, middleDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("    var new1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("    var new2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemove1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemove2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(1), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemove3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(1), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemove4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(1), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertLast((ASTNode)decl2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function new1() {\n    }\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        FunctionDeclaration decl3 = this.newMethodDeclaration(ast, "new3");
        FunctionDeclaration decl4 = this.newMethodDeclaration(ast, "new4");
        ASTNode firstDecl = (ASTNode)decls.get(0);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertBefore((ASTNode)decl1, firstDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, firstDecl, null);
        listRewrite.insertLast((ASTNode)decl3, null);
        listRewrite.insertAfter((ASTNode)decl4, (ASTNode)decl3, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function new1() {\n    }\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function new3() {\n    }\n");
        buf.append("\n");
        buf.append("    function new4() {\n    }\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(1), null);
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        ASTNode middleDecl = (ASTNode)decls.get(1);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertBefore((ASTNode)decl1, middleDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, middleDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function new1() {\n    }\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert1Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertLast((ASTNode)decl2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var new1;\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var new2;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert2Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        FieldDeclaration decl3 = this.newFieldDeclaration(ast, "new3");
        FieldDeclaration decl4 = this.newFieldDeclaration(ast, "new4");
        ASTNode firstDecl = (ASTNode)decls.get(0);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertBefore((ASTNode)decl1, firstDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, firstDecl, null);
        listRewrite.insertLast((ASTNode)decl3, null);
        listRewrite.insertAfter((ASTNode)decl4, (ASTNode)decl3, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var new1;\n");
        buf.append("\n");
        buf.append("    var new2;\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var new3;\n");
        buf.append("\n");
        buf.append("    var new4;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert3Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        ASTNode middleDecl = (ASTNode)decls.get(1);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.remove(middleDecl, null);
        listRewrite.insertBefore((ASTNode)decl1, middleDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, middleDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var new1;\n");
        buf.append("\n");
        buf.append("    var new2;\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        ASTNode firstDecl = (ASTNode)decls.get(0);
        ASTNode lastDecl = (ASTNode)decls.get(2);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.remove(firstDecl, null);
        listRewrite.remove(lastDecl, null);
        listRewrite.insertAfter((ASTNode)decl1, firstDecl, null);
        listRewrite.insertBefore((ASTNode)decl2, lastDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function new1() {\n    }\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert4Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        ASTNode firstDecl = (ASTNode)decls.get(0);
        ASTNode lastDecl = (ASTNode)decls.get(2);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.remove(firstDecl, null);
        listRewrite.remove(lastDecl, null);
        listRewrite.insertAfter((ASTNode)decl1, firstDecl, null);
        listRewrite.insertBefore((ASTNode)decl2, lastDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    int new1;\n");
        buf.append("\n");
        buf.append("    public int x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    int new2;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert5() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        FunctionDeclaration decl3 = this.newMethodDeclaration(ast, "new3");
        FunctionDeclaration decl4 = this.newMethodDeclaration(ast, "new4");
        ASTNode firstDecl = (ASTNode)decls.get(0);
        ASTNode lastDecl = (ASTNode)decls.get(2);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        rewrite.remove(firstDecl, null);
        rewrite.remove(lastDecl, null);
        listRewrite.insertBefore((ASTNode)decl1, firstDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, firstDecl, null);
        listRewrite.insertBefore((ASTNode)decl3, lastDecl, null);
        listRewrite.insertAfter((ASTNode)decl4, lastDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function new1() {\n    }\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function new3() {\n    }\n");
        buf.append("\n");
        buf.append("    function new4() {\n    }\n");
        buf.append("\n");
        buf.append("//c4\n");
        buf.append("}\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert5Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        FieldDeclaration decl3 = this.newFieldDeclaration(ast, "new3");
        FieldDeclaration decl4 = this.newFieldDeclaration(ast, "new4");
        ASTNode firstDecl = (ASTNode)decls.get(0);
        ASTNode lastDecl = (ASTNode)decls.get(2);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        rewrite.remove(firstDecl, null);
        rewrite.remove(lastDecl, null);
        listRewrite.insertBefore((ASTNode)decl1, firstDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, firstDecl, null);
        listRewrite.insertBefore((ASTNode)decl3, lastDecl, null);
        listRewrite.insertAfter((ASTNode)decl4, lastDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var new1;\n");
        buf.append("\n");
        buf.append("    var new2;\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var new3;\n");
        buf.append("\n");
        buf.append("    var new4;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert6() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(1), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertLast((ASTNode)decl2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function new1() {\n    }\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert6Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    public int x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    public int x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    public int x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(1), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertLast((ASTNode)decl2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    int new1;\n");
        buf.append("\n");
        buf.append("    int new2;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert7() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function foo1();\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    function foo2();\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    function foo3();\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(1), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        FunctionDeclaration decl1 = this.newMethodDeclaration(ast, "new1");
        FunctionDeclaration decl2 = this.newMethodDeclaration(ast, "new2");
        ASTNode middleDecl = (ASTNode)decls.get(1);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertBefore((ASTNode)decl1, middleDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, middleDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    function new1() {\n    }\n");
        buf.append("\n");
        buf.append("    function new2() {\n    }\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testRemoveInsert7Before() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("//c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("//c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("//c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        rewrite.remove((ASTNode)decls.get(0), null);
        rewrite.remove((ASTNode)decls.get(1), null);
        rewrite.remove((ASTNode)decls.get(2), null);
        FieldDeclaration decl1 = this.newFieldDeclaration(ast, "new1");
        FieldDeclaration decl2 = this.newFieldDeclaration(ast, "new2");
        ASTNode middleDecl = (ASTNode)decls.get(1);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astRoot, JavaScriptUnit.STATEMENTS_PROPERTY);
        listRewrite.insertBefore((ASTNode)decl1, middleDecl, null);
        listRewrite.insertAfter((ASTNode)decl2, middleDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("//c1\n");
        buf.append("\n");
        buf.append("    var new1;\n");
        buf.append("\n");
        buf.append("    var new2;\n");
        buf.append("\n");
        buf.append("//c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }

    public void testTargetSourceRangeComputer() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    //c1\n");
        buf.append("\n");
        buf.append("    var x1;\n");
        buf.append("\n");
        buf.append("    //c2\n");
        buf.append("\n");
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("    //c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("    //c4\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        List decls = astRoot.statements();
        final HashMap<VariableDeclarationStatement, TargetSourceRangeComputer.SourceRange> extendedRanges = new HashMap<VariableDeclarationStatement, TargetSourceRangeComputer.SourceRange>();
        VariableDeclarationStatement f1 = (VariableDeclarationStatement)decls.get(0);
        int off1 = buf.indexOf("//c1");
        int end1 = f1.getStartPosition() + f1.getLength();
        extendedRanges.put(f1, new TargetSourceRangeComputer.SourceRange(off1, end1 - off1));
        rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

            public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
                TargetSourceRangeComputer.SourceRange range = (TargetSourceRangeComputer.SourceRange)extendedRanges.get(node);
                if (range != null) {
                    return range;
                }
                return super.computeSourceRange(node);
            }
        });
        rewrite.remove((ASTNode)f1, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    var x2;\n");
        buf.append("\n");
        buf.append("    //c3\n");
        buf.append("\n");
        buf.append("    var x3;\n");
        buf.append("\n");
        buf.append("    //c4\n");
        ASTRewritingInsertBoundTest.assertEqualString(preview, buf.toString());
    }
}

