/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class CreatePackageTests
extends ModifyingResourceTests {
    static /* synthetic */ Class class$0;

    public CreatePackageTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.CreatePackageTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CreatePackageTests.buildModelTestSuite(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createJavaProject("P");
        this.createFolder("/P/p");
        this.startDeltas();
    }

    public void tearDown() throws Exception {
        this.stopDeltas();
        this.deleteProject("P");
        super.tearDown();
    }

    public void testCreatePackageFragment1() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "");
        IPackageFragment frag = root.createPackageFragment("one.two.three", false, null);
        this.assertCreation((IJavaScriptElement)frag);
        CreatePackageTests.assertTrue((String)"Fragment return not correct", (boolean)frag.getElementName().equals("one.two.three"));
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tone[+]: {}\n\t\tone.two[+]: {}\n\t\tone.two.three[+]: {}");
    }

    public void testCreatePackageFragment2() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "");
        IPackageFragment frag = root.createPackageFragment("one.two.three.four", false, null);
        this.assertCreation((IJavaScriptElement)frag);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tone[+]: {}\n\t\tone.two[+]: {}\n\t\tone.two.three[+]: {}\n\t\tone.two.three.four[+]: {}");
    }

    public void testCreatePackageFragment3() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "");
        IPackageFragment frag = root.createPackageFragment("", false, null);
        this.assertCreation((IJavaScriptElement)frag);
        CreatePackageTests.assertTrue((String)"Fragment return not correct", (boolean)frag.getElementName().equals(""));
    }

    public void testCreatePackageFragment4() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "");
        IPackageFragment frag = root.createPackageFragment("A", false, null);
        this.assertCreation((IJavaScriptElement)frag);
        CreatePackageTests.assertTrue((String)"Fragment return not correct", (boolean)frag.getElementName().equals("A"));
    }

    public void testDuplicatePackageFragment() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "");
        IPackageFragment frag = root.createPackageFragment("p", false, null);
        this.assertCreation((IJavaScriptElement)frag);
        this.assertDeltas("Unexpected delta", "");
    }

    public void testInvalidPackageFragment() throws CoreException {
        this.createFile("/P/p/other", "");
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "");
        try {
            root.createPackageFragment(null, false, null);
        }
        catch (JavaScriptModelException jme) {
            CreatePackageTests.assertTrue((String)"Incorrect JavaScriptModelException thrown for creating an package fragment with invalid name", (jme.getStatus().getCode() == 983 ? 1 : 0) != 0);
            try {
                root.createPackageFragment("java.jfg.", false, null);
            }
            catch (JavaScriptModelException jme2) {
                CreatePackageTests.assertTrue((String)"Incorrect JavaScriptModelException thrown for creating a package fragment with invalid name", (jme2.getStatus().getCode() == 983 ? 1 : 0) != 0);
                try {
                    root.createPackageFragment("p.other", false, null);
                }
                catch (JavaScriptModelException jme3) {
                    CreatePackageTests.assertTrue((String)"Incorrect JavaScriptModelException thrown for creating a package fragment that collides with a file", (jme3.getStatus().getCode() == 977 ? 1 : 0) != 0);
                    return;
                }
            }
        }
        CreatePackageTests.assertTrue((String)"No JavaScriptModelException thrown for creating a package fragment with an invalid parameters", (boolean)false);
    }
}

