/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class CreateCompilationUnitTests
extends ModifyingResourceTests {
    static /* synthetic */ Class class$0;

    public CreateCompilationUnitTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.CreateCompilationUnitTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CreateCompilationUnitTests.buildModelTestSuite(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createJavaProject("P");
        this.createFolder("/P/p");
        this.startDeltas();
    }

    public void tearDown() throws Exception {
        this.stopDeltas();
        this.deleteProject("P");
        super.tearDown();
    }

    public void testCUAndImportContainer() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackage("/P/p");
        IJavaScriptUnit cu = pkg.createCompilationUnit("HelloImports.js", "package p;\n\nimport java.util.Enumeration;\nimport java.util.Vector;\n\npublic class HelloImports {\n\n\tpublic static main(String[] args) {\n\t\tSystem.out.println(\"HelloWorld\");\n\t}\n}\n", false, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tHelloImports.java[+]: {}");
        IImportDeclaration[] imprts = cu.getImports();
        CreateCompilationUnitTests.assertTrue((String)"Import does not exist", (imprts.length == 2 && imprts[0].exists() ? 1 : 0) != 0);
        cu.close();
        imprts = cu.getImports();
        CreateCompilationUnitTests.assertTrue((String)"Import does not exist", (imprts.length == 2 && imprts[0].exists() ? 1 : 0) != 0);
    }

    public void testDefaultCU() throws CoreException {
        IPackageFragment pkg = this.getPackage("/P/p");
        IJavaScriptUnit cu = pkg.getJavaScriptUnit("Default.js");
        IType type = cu.createType("public class Default {}", null, false, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertCreation((IJavaScriptElement)type);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tDefault.java[+]: {}\n\nP[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tDefault.java[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tDefault[+]: {}");
        this.assertElementDescendants("Unexpected children", "Default.java\n  package p\n  class Default", (IJavaScriptElement)cu);
        try {
            pkg.createCompilationUnit("Default.js", "", false, null);
        }
        catch (JavaScriptModelException jme) {
            CreateCompilationUnitTests.assertTrue((String)"Exception status not correct for creating a cu that already exists", (jme.getStatus().getCode() == 977 ? 1 : 0) != 0);
        }
        try {
            pkg.createCompilationUnit("Default.js", "public class Default {}", true, null);
            return;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            CreateCompilationUnitTests.assertTrue((String)"Creation should not fail if the compilation unit already exists", (boolean)false);
            return;
        }
    }

    public void testEmptyCU() {
        IPackageFragment pkg = this.getPackage("/P/p");
        try {
            pkg.createCompilationUnit("Empty.js", "", true, null);
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        IJavaScriptUnit cu = pkg.getJavaScriptUnit("Empty.js");
        this.assertCreation((IJavaScriptElement)cu);
    }

    public void testForce() throws JavaScriptModelException, IOException {
        IPackageFragment pkg = this.getPackage("/P/p");
        File folder = pkg.getResource().getLocation().toFile();
        new File(folder, "X.js").createNewFile();
        IJavaScriptUnit cu = pkg.createCompilationUnit("X.js", "package p;\npublic class X {\n}", true, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tX.java[+]: {}");
    }

    public void testInvalidName() {
        IPackageFragment pkg = this.getPackage("/P/p");
        try {
            pkg.createCompilationUnit("HelloWorld.j", null, false, null);
        }
        catch (JavaScriptModelException jme) {
            CreateCompilationUnitTests.assertTrue((String)"Incorrect JavaScriptModelException thrown for creating a cu with invalid name", (jme.getStatus().getCode() == 983 ? 1 : 0) != 0);
            try {
                pkg.createCompilationUnit(null, null, false, null);
            }
            catch (JavaScriptModelException jme2) {
                CreateCompilationUnitTests.assertTrue((String)"Incorrect JavaScriptModelException thrown for creating a cu with invalid name", (jme2.getStatus().getCode() == 983 ? 1 : 0) != 0);
                return;
            }
        }
        CreateCompilationUnitTests.assertTrue((String)"No JavaScriptModelException thrown for creating a cu with an invalid name", (boolean)false);
    }

    public void testNullContents() {
        IPackageFragment pkg = this.getPackage("/P/p");
        try {
            pkg.createCompilationUnit("HelloWorld.js", null, false, null);
        }
        catch (JavaScriptModelException jme) {
            CreateCompilationUnitTests.assertTrue((String)("Incorrect JavaScriptModelException thrown for creating a cu with null contents: " + (Object)((Object)jme)), (jme.getStatus().getCode() == 984 ? 1 : 0) != 0);
            return;
        }
        CreateCompilationUnitTests.assertTrue((String)"No JavaScriptModelException thrown for creating a cu with null contents", (boolean)false);
    }

    public void testSimpleCreation() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackage("/P/p");
        IJavaScriptUnit cu = pkg.createCompilationUnit("HelloWorld.js", "package p;\n\npublic class HelloWorld {\n\n\tpublic static main(String[] args) {\n\t\tSystem.out.println(\"HelloWorld\");\n\t}\n}\n", false, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tHelloWorld.java[+]: {}");
    }
}

