/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaCorePreferenceInitializer;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceMethod;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceType;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class AbstractJavaModelTests
extends SuiteOfTestCases {
    protected static String EXTERNAL_JAR_DIR_PATH;
    protected IJavaScriptProject currentProject;
    protected IJavaScriptUnit[] workingCopies;
    protected WorkingCopyOwner wcOwner;
    protected int tabs = 2;
    protected boolean displayName = false;
    protected String endChar = ",";
    protected DeltaListener deltaListener = new DeltaListener();

    public AbstractJavaModelTests(String name) {
        super(name);
    }

    public AbstractJavaModelTests(String name, int tabs) {
        super(name);
        this.tabs = tabs;
    }

    public static Test buildModelTestSuite(Class evaluationTestClass) {
        return AbstractJavaModelTests.buildModelTestSuite(evaluationTestClass, ORDERING);
    }

    public static Test buildModelTestSuite(Class evaluationTestClass, long ordering) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite(evaluationTestClass.getName());
        List tests = AbstractJavaModelTests.buildTestsList((Class)evaluationTestClass, (int)0, (long)ordering);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            suite.addTest((Test)tests.get(index));
            ++index;
        }
        return suite;
    }

    protected void addJavaNature(String projectName) throws CoreException {
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
        project.setDescription(description, null);
    }

    protected void assertSearchResults(String expected, Object collector) {
        this.assertSearchResults("Unexpected search results", expected, collector);
    }

    protected void assertSearchResults(String message, String expected, Object collector) {
        String actual = collector.toString();
        if (!expected.equals(actual)) {
            if (this.displayName) {
                System.out.println(String.valueOf(this.getName()) + " actual result is:");
            }
            System.out.print(this.displayString(actual, this.tabs));
            System.out.println(",");
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void addLibrary(String jarName, String sourceZipName, String[] pathAndContents, String compliance) throws CoreException, IOException {
        this.addLibrary(this.currentProject, jarName, sourceZipName, pathAndContents, null, null, compliance);
    }

    protected void addLibrary(IJavaScriptProject javaProject, String jarName, String sourceZipName, String[] pathAndContents, String compliance) throws CoreException, IOException {
        this.addLibrary(javaProject, jarName, sourceZipName, pathAndContents, null, null, compliance);
    }

    protected void addLibrary(IJavaScriptProject javaProject, String libraryPath, String sourceZipName, String[] pathAndContents, String[] librariesInclusionPatterns, String[] librariesExclusionPatterns, String compliance) throws CoreException, IOException {
        boolean projectbased;
        IProject project = javaProject.getProject();
        String projectLocation = project.getLocation().toOSString();
        boolean bl = projectbased = libraryPath == null;
        if (projectbased) {
            libraryPath = projectLocation;
        }
        int i = 0;
        while (i < pathAndContents.length) {
            String jarPath = String.valueOf(libraryPath) + File.separator + pathAndContents[i];
            Util.createFile((String)jarPath, (String)pathAndContents[i + 1]);
            if (projectbased) {
                project.refreshLocal(2, null);
            }
            String projectPath = String.valueOf('/') + project.getName() + '/';
            Path path = projectbased ? new Path(String.valueOf(projectPath) + pathAndContents[i]) : new Path(jarPath);
            this.addLibraryEntry(javaProject, (IPath)path, null, null, this.toIPathArray(librariesInclusionPatterns), this.toIPathArray(librariesExclusionPatterns), true);
            i += 2;
        }
    }

    protected void addLibraryEntry(String path, boolean exported) throws JavaScriptModelException {
        this.addLibraryEntry(this.currentProject, (IPath)new Path(path), null, null, null, null, exported);
    }

    protected void addLibraryEntry(IJavaScriptProject project, String path, boolean exported) throws JavaScriptModelException {
        this.addLibraryEntry(project, (IPath)new Path(path), null, null, null, null, exported);
    }

    protected void addLibraryEntry(IJavaScriptProject project, String path, String srcAttachmentPath, String srcAttachmentPathRoot, boolean exported) throws JavaScriptModelException {
        this.addLibraryEntry(project, (IPath)new Path(path), (IPath)(srcAttachmentPath == null ? null : new Path(srcAttachmentPath)), (IPath)(srcAttachmentPathRoot == null ? null : new Path(srcAttachmentPathRoot)), null, null, new IIncludePathAttribute[0], exported);
    }

    protected void addLibraryEntry(IJavaScriptProject project, IPath path, IPath srcAttachmentPath, IPath srcAttachmentPathRoot, IPath[] accessibleFiles, IPath[] nonAccessibleFiles, boolean exported) throws JavaScriptModelException {
        this.addLibraryEntry(project, path, srcAttachmentPath, srcAttachmentPathRoot, accessibleFiles, nonAccessibleFiles, new IIncludePathAttribute[0], exported);
    }

    protected void addLibraryEntry(IJavaScriptProject project, IPath path, IPath srcAttachmentPath, IPath srcAttachmentPathRoot, IPath[] accessibleFiles, IPath[] nonAccessibleFiles, IIncludePathAttribute[] extraAttributes, boolean exported) throws JavaScriptModelException {
        IIncludePathEntry[] entries = project.getRawIncludepath();
        int length = entries.length;
        IIncludePathEntry[] iIncludePathEntryArray = entries;
        entries = new IIncludePathEntry[length + 1];
        System.arraycopy(iIncludePathEntryArray, 0, entries, 0, length);
        entries[length] = JavaScriptCore.newLibraryEntry((IPath)path, (IPath)srcAttachmentPath, (IPath)srcAttachmentPathRoot, (IAccessRule[])ClasspathEntry.getAccessRules((IPath[])accessibleFiles, (IPath[])nonAccessibleFiles), (IIncludePathAttribute[])extraAttributes, (boolean)exported);
        project.setRawIncludepath(entries, null);
    }

    protected void assertSortedElementsEqual(String message, String expected, IJavaScriptElement[] elements) {
        this.sortElements(elements);
        this.assertElementsEqual(message, expected, elements);
    }

    protected void assertResourcesEqual(String message, String expected, Object[] resources) {
        this.sortResources(resources);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = resources.length;
        while (i < length) {
            if (resources[i] instanceof IResource) {
                buffer.append(((IResource)resources[i]).getFullPath().toString());
            } else if (resources[i] instanceof IStorage) {
                buffer.append(((IStorage)resources[i]).getFullPath().toString());
            } else if (resources[i] == null) {
                buffer.append("<null>");
            }
            if (i != length - 1) {
                buffer.append("\n");
            }
            ++i;
        }
        if (!expected.equals(buffer.toString())) {
            System.out.print(Util.displayString((String)buffer.toString(), (int)2));
            System.out.println(this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)buffer.toString());
    }

    protected void assertResourceNamesEqual(String message, String expected, Object[] resources) {
        this.sortResources(resources);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = resources.length;
        while (i < length) {
            if (resources[i] instanceof IResource) {
                buffer.append(((IResource)resources[i]).getName());
            } else if (resources[i] instanceof IStorage) {
                buffer.append(((IStorage)resources[i]).getName());
            } else if (resources[i] == null) {
                buffer.append("<null>");
            }
            if (i != length - 1) {
                buffer.append("\n");
            }
            ++i;
        }
        if (!expected.equals(buffer.toString())) {
            System.out.print(Util.displayString((String)buffer.toString(), (int)2));
            System.out.println(this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)buffer.toString());
    }

    protected void assertElementEquals(String message, String expected, IJavaScriptElement element) {
        String actual;
        String string = actual = element == null ? "<null>" : ((JavaElement)element).toStringWithAncestors(false);
        if (!expected.equals(actual)) {
            if (this.displayName) {
                System.out.println(String.valueOf(this.getName()) + " actual result is:");
            }
            System.out.println(String.valueOf(this.displayString(actual, this.tabs)) + this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertElementsEqual(String message, String expected, IJavaScriptElement[] elements) {
        this.assertElementsEqual(message, expected, elements, false);
    }

    protected void assertElementsEqual(String message, String expected, IJavaScriptElement[] elements, boolean showResolvedInfo) {
        StringBuffer buffer = new StringBuffer();
        if (elements != null) {
            int i = 0;
            int length = elements.length;
            while (i < length) {
                JavaElement element = (JavaElement)elements[i];
                if (element == null) {
                    buffer.append("<null>");
                } else {
                    buffer.append(element.toStringWithAncestors(showResolvedInfo));
                }
                if (i != length - 1) {
                    buffer.append("\n");
                }
                ++i;
            }
        } else {
            buffer.append("<null>");
        }
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            if (this.displayName) {
                System.out.println(String.valueOf(this.getName()) + " actual result is:");
            }
            System.out.println(String.valueOf(this.displayString(actual, this.tabs)) + this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertExceptionEquals(String message, String expected, JavaScriptModelException exception) {
        String actual;
        String string = actual = exception == null ? "<null>" : exception.getStatus().getMessage();
        if (!expected.equals(actual)) {
            if (this.displayName) {
                System.out.println(String.valueOf(this.getName()) + " actual result is:");
            }
            System.out.println(String.valueOf(this.displayString(actual, this.tabs)) + this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertHierarchyEquals(String expected, ITypeHierarchy hierarchy) {
        String actual = hierarchy.toString();
        if (!expected.equals(actual)) {
            if (this.displayName) {
                System.out.println(String.valueOf(this.getName()) + " actual result is:");
            }
            System.out.println(String.valueOf(this.displayString(actual, this.tabs)) + this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)"Unexpected type hierarchy", (String)expected, (String)actual);
    }

    protected void assertMarkers(String message, String expectedMarkers, IJavaScriptProject project) throws CoreException {
        AbstractJavaModelTests.waitForAutoBuild();
        IMarker[] markers = project.getProject().findMarkers("org.eclipse.wst.jsdt.core.buildpath_problem", false, 0);
        this.sortMarkers(markers);
        this.assertMarkers(message, expectedMarkers, markers);
    }

    protected void sortMarkers(IMarker[] markers) {
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object a, Object b) {
                IMarker markerA = (IMarker)a;
                IMarker markerB = (IMarker)b;
                return markerA.getAttribute("message", "").compareTo(markerB.getAttribute("message", ""));
            }
        };
        org.eclipse.wst.jsdt.internal.core.util.Util.sort((Object[])markers, (Util.Comparer)comparer);
    }

    protected void assertMarkers(String message, String expectedMarkers, IMarker[] markers) throws CoreException {
        String actual;
        StringBuffer buffer = new StringBuffer();
        if (markers != null) {
            int i = 0;
            int length = markers.length;
            while (i < length) {
                IMarker marker = markers[i];
                buffer.append(marker.getAttribute("message"));
                if (i != length - 1) {
                    buffer.append("\n");
                }
                ++i;
            }
        }
        if (!expectedMarkers.equals(actual = buffer.toString())) {
            System.out.println(Util.displayString((String)actual, (int)2));
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expectedMarkers, (String)actual);
    }

    protected void assertProblems(String message, String expected, ProblemRequestor problemRequestor) {
        String actual = Util.convertToIndependantLineDelimiter((String)problemRequestor.problems.toString());
        String independantExpectedString = Util.convertToIndependantLineDelimiter((String)expected);
        if (!independantExpectedString.equals(actual)) {
            System.out.println(Util.displayString((String)actual, (int)this.tabs));
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)independantExpectedString, (String)actual);
    }

    protected void assertSourceEquals(String message, String expected, String actual) {
        if (actual == null) {
            AbstractJavaModelTests.assertEquals((String)message, (String)expected, null);
            return;
        }
        if (!(actual = Util.convertToIndependantLineDelimiter((String)actual)).equals(expected)) {
            System.out.print(Util.displayString((String)actual.toString(), (int)2));
            System.out.println(this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    public void assertASTNodeEquals(String message, String expected, ASTNode actual) {
        String actualString = actual == null ? "null" : actual.toString();
        this.assertSourceEquals(message, expected, actualString);
    }

    public void assertCreation(IJavaScriptElement[] newElements) {
        int i = 0;
        while (i < newElements.length) {
            IJavaScriptElement newElement = newElements[i];
            AbstractJavaModelTests.assertTrue((String)"Element should be present after creation", (boolean)newElement.exists());
            ++i;
        }
    }

    protected void assertClasspathEquals(IIncludePathEntry[] classpath, String expected) {
        String actual;
        if (classpath == null) {
            actual = "<null>";
        } else {
            StringBuffer buffer = new StringBuffer();
            int length = classpath.length;
            int i = 0;
            while (i < length) {
                buffer.append(classpath[i]);
                if (i < length - 1) {
                    buffer.append('\n');
                }
                ++i;
            }
            actual = buffer.toString();
        }
        if (!actual.equals(expected)) {
            System.out.print(Util.displayString((String)actual, (int)2));
        }
        AbstractJavaModelTests.assertEquals((String)expected, (String)actual);
    }

    public void assertCreation(IJavaScriptElement newElement) {
        this.assertCreation(new IJavaScriptElement[]{newElement});
    }

    public void assertDeletion(IJavaScriptElement[] elementsToDelete) throws JavaScriptModelException {
        IJavaScriptElement elementToDelete = null;
        int i = 0;
        while (i < elementsToDelete.length) {
            elementToDelete = elementsToDelete[i];
            AbstractJavaModelTests.assertTrue((String)"Element must be present to be deleted", (boolean)elementToDelete.exists());
            ++i;
        }
        this.getJavaModel().delete(elementsToDelete, false, null);
        i = 0;
        while (i < elementsToDelete.length) {
            elementToDelete = elementsToDelete[i];
            AbstractJavaModelTests.assertTrue((String)("Element should not be present after deletion: " + elementToDelete), (!elementToDelete.exists() ? 1 : 0) != 0);
            ++i;
        }
    }

    protected void assertDeltas(String message, String expected) {
        String actual = this.deltaListener.toString();
        if (!expected.equals(actual)) {
            System.out.println(this.displayString(actual, 2));
            System.err.println(this.deltaListener.stackTraces.toString());
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertDeltas(String message, String expected, IJavaScriptElementDelta delta) {
        String actual;
        String string = actual = delta == null ? "<null>" : delta.toString();
        if (!expected.equals(actual)) {
            System.out.println(this.displayString(actual, 2));
            System.err.println(this.deltaListener.stackTraces.toString());
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertTypesEqual(String message, String expected, IType[] types) {
        this.assertTypesEqual(message, expected, types, true);
    }

    protected void assertTypesEqual(String message, String expected, IType[] types, boolean sort) {
        if (sort) {
            this.sortTypes(types);
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            if (types[i] == null) {
                buffer.append("<null>");
            } else {
                buffer.append(types[i].getFullyQualifiedName());
            }
            buffer.append("\n");
            ++i;
        }
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            System.out.println(String.valueOf(this.displayString(actual, 2)) + this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertTypeParametersEqual(String expected, ITypeParameter[] typeParameters) throws JavaScriptModelException {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < typeParameters.length) {
            ITypeParameter typeParameter = typeParameters[i];
            buffer.append(typeParameter.getElementName());
            String[] bounds = typeParameter.getBounds();
            int length = bounds.length;
            if (length > 0) {
                buffer.append(" extends ");
            }
            int j = 0;
            while (j < length) {
                buffer.append(bounds[j]);
                if (j != length - 1) {
                    buffer.append(" & ");
                }
                ++j;
            }
            buffer.append("\n");
            ++i;
        }
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            System.out.println(String.valueOf(this.displayString(actual, 3)) + this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)"Unepexeted type parameters", (String)expected, (String)actual);
    }

    protected void assertSortedStringsEqual(String message, String expected, String[] strings) {
        org.eclipse.wst.jsdt.internal.core.util.Util.sort((String[])strings);
        this.assertStringsEqual(message, expected, strings);
    }

    protected void assertStringsEqual(String message, String expected, String[] strings) {
        String actual = this.toString(strings, true);
        if (!expected.equals(actual)) {
            System.out.println(String.valueOf(this.displayString(actual, this.tabs)) + this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertStringsEqual(String message, String[] expectedStrings, String[] actualStrings) {
        String actual;
        String expected = this.toString(expectedStrings, false);
        if (!expected.equals(actual = this.toString(actualStrings, false))) {
            System.out.println(String.valueOf(this.displayString(actual, this.tabs)) + this.endChar);
        }
        AbstractJavaModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void attachSource(IPackageFragmentRoot root, String sourcePath, String sourceRoot) throws JavaScriptModelException {
        IJavaScriptProject javaProject = root.getJavaScriptProject();
        IIncludePathEntry[] entries = (IIncludePathEntry[])javaProject.getRawIncludepath().clone();
        int i = 0;
        while (i < entries.length) {
            IIncludePathEntry entry = entries[i];
            if (entry.getPath().toOSString().toLowerCase().equals(root.getPath().toOSString().toLowerCase())) {
                entries[i] = JavaScriptCore.newLibraryEntry((IPath)root.getPath(), (IPath)(sourcePath == null ? null : new Path(sourcePath)), (IPath)(sourceRoot == null ? null : new Path(sourceRoot)), (boolean)false);
                break;
            }
            ++i;
        }
        javaProject.setRawIncludepath(entries, null);
    }

    public void assertDeletion(IJavaScriptElement elementToDelete) throws JavaScriptModelException {
        this.assertDeletion(new IJavaScriptElement[]{elementToDelete});
    }

    public void clearDeltas() {
        this.deltaListener.deltas = new IJavaScriptElementDelta[0];
        this.deltaListener.stackTraces = new ByteArrayOutputStream();
    }

    protected IJavaScriptElement[] codeSelect(ISourceReference sourceReference, String selectAt, String selection) throws JavaScriptModelException {
        String str = sourceReference.getSource();
        int start = str.indexOf(selectAt);
        int length = selection.length();
        return ((ICodeAssist)sourceReference).codeSelect(start, length);
    }

    protected IJavaScriptElement[] codeSelectAt(ISourceReference sourceReference, String selectAt) throws JavaScriptModelException {
        String str = sourceReference.getSource();
        int start = str.indexOf(selectAt) + selectAt.length();
        int length = 0;
        return ((ICodeAssist)sourceReference).codeSelect(start, length);
    }

    public void copy(File src, File dest) throws IOException {
        byte[] srcBytes = this.read(src);
        if (this.convertToIndependantLineDelimiter(src)) {
            String contents = new String(srcBytes);
            contents = Util.convertToIndependantLineDelimiter((String)contents);
            srcBytes = contents.getBytes();
        }
        FileOutputStream out = new FileOutputStream(dest);
        out.write(srcBytes);
        out.close();
    }

    public boolean convertToIndependantLineDelimiter(File file) {
        return file.getName().endsWith(".js");
    }

    protected void copyDirectory(File source, File target) throws IOException {
        File[] files;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((files = source.listFiles()) == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File sourceChild = files[i];
            String name = sourceChild.getName();
            if (!name.equals("CVS") && !name.equals(".svn")) {
                File targetChild = new File(target, name);
                if (sourceChild.isDirectory()) {
                    this.copyDirectory(sourceChild, targetChild);
                } else {
                    this.copy(sourceChild, targetChild);
                }
            }
            ++i;
        }
    }

    protected IFolder createFolder(IPath path) throws CoreException {
        final IFolder folder = this.getWorkspaceRoot().getFolder(path);
        this.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IContainer parent = folder.getParent();
                if (parent instanceof IFolder && !parent.exists()) {
                    AbstractJavaModelTests.this.createFolder(parent.getFullPath());
                }
                folder.create(true, true, null);
            }
        }, null);
        return folder;
    }

    protected IJavaScriptProject createJavaProject(String projectName) throws CoreException {
        return this.createJavaProject(projectName, new String[]{""}, new String[]{"JCL_LIB"}, "");
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String output) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, null, null, null, null, null, null, null, output, null, null, null, "1.4");
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String output, String[] sourceOutputs) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, null, null, null, null, null, null, null, output, sourceOutputs, null, null, "1.4");
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String[] libraries, String output) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, libraries, null, null, null, null, null, null, output, null, null, null, "1.4");
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String[] libraries, String output, String compliance) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, libraries, null, null, null, null, null, null, output, null, null, null, compliance);
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String[] libraries, String[] projects, String projectOutput) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, libraries, null, null, projects, null, null, null, projectOutput, null, null, null, "1.4");
    }

    protected SearchPattern createPattern(IJavaScriptElement element, int limitTo) {
        return SearchPattern.createPattern((IJavaScriptElement)element, (int)limitTo);
    }

    protected SearchPattern createPattern(String stringPattern, int searchFor, int limitTo, boolean isCaseSensitive) {
        int matchMode = stringPattern.indexOf(42) != -1 || stringPattern.indexOf(63) != -1 ? 2 : 0;
        int matchRule = isCaseSensitive ? matchMode | 8 : matchMode;
        return SearchPattern.createPattern((String)stringPattern, (int)searchFor, (int)limitTo, (int)matchRule);
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String[] libraries, String[] projects, boolean[] exportedProject, String projectOutput) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, libraries, null, null, projects, null, null, exportedProject, projectOutput, null, null, null, "1.4");
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String[] libraries, String[] projects, String projectOutput, String compliance) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, libraries, null, null, projects, null, null, null, projectOutput, null, null, null, compliance);
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String[] libraries, String[] projects, boolean[] exportedProjects, String projectOutput, String[] sourceOutputs, String[][] inclusionPatterns, String[][] exclusionPatterns, String compliance) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, libraries, null, null, projects, null, null, exportedProjects, projectOutput, sourceOutputs, inclusionPatterns, exclusionPatterns, compliance);
    }

    protected IJavaScriptProject createJavaProject(String projectName, String[] sourceFolders, String[] libraries, String[][] librariesInclusionPatterns, String[][] librariesExclusionPatterns, String[] projects, String[][] projectsInclusionPatterns, String[][] projectsExclusionPatterns, boolean[] exportedProjects, String projectOutput, String[] sourceOutputs, String[][] inclusionPatterns, String[][] exclusionPatterns, String compliance) throws CoreException {
        return this.createJavaProject(projectName, sourceFolders, libraries, librariesInclusionPatterns, librariesExclusionPatterns, projects, projectsInclusionPatterns, projectsExclusionPatterns, true, exportedProjects, projectOutput, sourceOutputs, inclusionPatterns, exclusionPatterns, compliance);
    }

    protected IJavaScriptProject createJavaProject(final String projectName, final String[] sourceFolders, final String[] libraries, final String[][] librariesInclusionPatterns, final String[][] librariesExclusionPatterns, final String[] projects, final String[][] projectsInclusionPatterns, final String[][] projectsExclusionPatterns, final boolean combineAccessRestrictions, final boolean[] exportedProjects, final String projectOutput, final String[] sourceOutputs, final String[][] inclusionPatterns, final String[][] exclusionPatterns, final String compliance) throws CoreException {
        final IJavaScriptProject[] result = new IJavaScriptProject[1];
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IIncludePathEntry jreEntry;
                IFolder output;
                IPath[] nonAccessibleFiles;
                String[] patterns;
                AbstractJavaModelTests.this.createProject(projectName);
                AbstractJavaModelTests.this.addJavaNature(projectName);
                IProject project = AbstractJavaModelTests.this.getWorkspaceRoot().getProject(projectName);
                IPath projectPath = project.getFullPath();
                int sourceLength = sourceFolders == null ? 0 : sourceFolders.length;
                int libLength = libraries == null ? 0 : libraries.length;
                int projectLength = projects == null ? 0 : projects.length;
                IIncludePathEntry[] entries = new IIncludePathEntry[sourceLength + libLength + projectLength + 1];
                int i = 0;
                while (i < sourceLength) {
                    IPath[] exclusionPaths;
                    IPath[] inclusionPaths;
                    Path sourcePath = new Path(sourceFolders[i]);
                    int segmentCount = sourcePath.segmentCount();
                    if (segmentCount > 0) {
                        IProject container = project;
                        int j = 0;
                        while (j < segmentCount) {
                            IFolder folder = container.getFolder((IPath)new Path(sourcePath.segment(j)));
                            if (!folder.exists()) {
                                folder.create(true, true, null);
                            }
                            container = folder;
                            ++j;
                        }
                    }
                    Path outputPath = null;
                    if (sourceOutputs != null) {
                        IFolder output2;
                        Path path = outputPath = sourceOutputs[i] == null ? null : new Path(sourceOutputs[i]);
                        if (outputPath != null && outputPath.segmentCount() > 0 && !(output2 = project.getFolder((IPath)outputPath)).exists()) {
                            output2.create(true, true, null);
                        }
                    }
                    if (inclusionPatterns == null) {
                        inclusionPaths = new IPath[]{};
                    } else {
                        String[] patterns2 = inclusionPatterns[i];
                        int length = patterns2.length;
                        inclusionPaths = new IPath[length];
                        int j = 0;
                        while (j < length) {
                            String inclusionPattern = patterns2[j];
                            inclusionPaths[j] = new Path(inclusionPattern);
                            ++j;
                        }
                    }
                    if (exclusionPatterns == null) {
                        exclusionPaths = new IPath[]{};
                    } else {
                        String[] patterns3 = exclusionPatterns[i];
                        int length = patterns3.length;
                        exclusionPaths = new IPath[length];
                        int j = 0;
                        while (j < length) {
                            String exclusionPattern = patterns3[j];
                            exclusionPaths[j] = new Path(exclusionPattern);
                            ++j;
                        }
                    }
                    entries[i] = JavaScriptCore.newSourceEntry((IPath)projectPath.append((IPath)sourcePath), (IPath[])inclusionPaths, (IPath[])exclusionPaths, outputPath == null ? null : projectPath.append((IPath)outputPath));
                    ++i;
                }
                i = 0;
                while (i < libLength) {
                    IPath[] accessibleFiles;
                    String lib = libraries[i];
                    if (lib.startsWith("JCL")) {
                        try {
                            AbstractJavaModelTests.this.setUpJCLClasspathVariables(compliance);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (librariesInclusionPatterns == null) {
                        accessibleFiles = new IPath[]{};
                    } else {
                        patterns = librariesInclusionPatterns[i];
                        int length = patterns.length;
                        accessibleFiles = new IPath[length];
                        int j = 0;
                        while (j < length) {
                            String inclusionPattern = patterns[j];
                            accessibleFiles[j] = new Path(inclusionPattern);
                            ++j;
                        }
                    }
                    if (librariesExclusionPatterns == null) {
                        nonAccessibleFiles = new IPath[]{};
                    } else {
                        String[] patterns4 = librariesExclusionPatterns[i];
                        int length = patterns4.length;
                        nonAccessibleFiles = new IPath[length];
                        int j = 0;
                        while (j < length) {
                            String exclusionPattern = patterns4[j];
                            nonAccessibleFiles[j] = new Path(exclusionPattern);
                            ++j;
                        }
                    }
                    if (lib.indexOf(File.separatorChar) == -1 && lib.charAt(0) != '/' && lib.equals(lib.toUpperCase())) {
                        char[][] vars = CharOperation.splitOn((char)',', (char[])lib.toCharArray());
                        entries[sourceLength + i] = JavaScriptCore.newVariableEntry((IPath)new Path(new String(vars[0])), (IPath)(vars.length > 1 ? new Path(new String(vars[1])) : null), (IPath)(vars.length > 2 ? new Path(new String(vars[2])) : null));
                    } else if (lib.startsWith("org.eclipse.wst.jsdt.core.tests.model.")) {
                        entries[sourceLength + i] = JavaScriptCore.newContainerEntry((IPath)new Path(lib), (IAccessRule[])ClasspathEntry.getAccessRules((IPath[])accessibleFiles, (IPath[])nonAccessibleFiles), (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)false);
                    } else {
                        Path libPath = new Path(lib);
                        if (!libPath.isAbsolute() && libPath.segmentCount() > 0 && libPath.getFileExtension() == null) {
                            project.getFolder((IPath)libPath).create(true, true, null);
                            libPath = projectPath.append((IPath)libPath);
                        }
                        entries[sourceLength + i] = JavaScriptCore.newLibraryEntry((IPath)libPath, null, null, (IAccessRule[])ClasspathEntry.getAccessRules((IPath[])accessibleFiles, (IPath[])nonAccessibleFiles), (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)false);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectLength) {
                    IPath[] accessibleFiles;
                    boolean isExported;
                    boolean bl = isExported = exportedProjects != null && exportedProjects.length > i && exportedProjects[i];
                    if (projectsInclusionPatterns == null) {
                        accessibleFiles = new IPath[]{};
                    } else {
                        patterns = projectsInclusionPatterns[i];
                        int length = patterns.length;
                        accessibleFiles = new IPath[length];
                        int j = 0;
                        while (j < length) {
                            String inclusionPattern = patterns[j];
                            accessibleFiles[j] = new Path(inclusionPattern);
                            ++j;
                        }
                    }
                    if (projectsExclusionPatterns == null) {
                        nonAccessibleFiles = new IPath[]{};
                    } else {
                        String[] patterns5 = projectsExclusionPatterns[i];
                        int length = patterns5.length;
                        nonAccessibleFiles = new IPath[length];
                        int j = 0;
                        while (j < length) {
                            String exclusionPattern = patterns5[j];
                            nonAccessibleFiles[j] = new Path(exclusionPattern);
                            ++j;
                        }
                    }
                    entries[sourceLength + libLength + i] = JavaScriptCore.newProjectEntry((IPath)new Path(projects[i]), (IAccessRule[])ClasspathEntry.getAccessRules((IPath[])accessibleFiles, (IPath[])nonAccessibleFiles), (boolean)combineAccessRestrictions, (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)isExported);
                    ++i;
                }
                Path outputPath = new Path(projectOutput);
                if (outputPath.segmentCount() > 0 && !(output = project.getFolder((IPath)outputPath)).exists()) {
                    output.create(true, true, null);
                }
                IJavaScriptProject javaProject = JavaScriptCore.create((IProject)project);
                entries[entries.length - 1] = jreEntry = JavaScriptCore.newContainerEntry((IPath)new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER"));
                javaProject.setRawIncludepath(entries, projectPath.append((IPath)outputPath), null);
                if ("1.5".equals(compliance)) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
                    options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
                    options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
                    javaProject.setOptions(options);
                }
                result[0] = javaProject;
            }
        };
        this.getWorkspace().run(create, null);
        return result[0];
    }

    protected IProject createProject(String projectName) throws CoreException {
        final IProject project = this.getProject(projectName);
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(null);
                project.open(null);
            }
        };
        this.getWorkspace().run(create, null);
        return project;
    }

    public void deleteFile(File file) {
        int retryCount = 0;
        while (++retryCount <= 60) {
            if (Util.delete((File)file)) break;
        }
    }

    protected void deleteFolder(IPath folderPath) throws CoreException {
        this.deleteResource((IResource)this.getFolder(folderPath));
    }

    protected void deleteProject(String projectName) throws CoreException {
        IProject project = this.getProject(projectName);
        if (project.exists() && !project.isOpen()) {
            project.open(null);
        }
        this.deleteResource((IResource)project);
    }

    protected void deleteProject(IJavaScriptProject project) throws CoreException {
        if (project.exists() && !project.isOpen()) {
            project.open(null);
        }
        this.deleteResource((IResource)project.getProject());
    }

    protected void deleteProjects(final String[] projectNames) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (projectNames != null) {
                    int i = 0;
                    int max = projectNames.length;
                    while (i < max) {
                        if (projectNames[i] != null) {
                            AbstractJavaModelTests.this.deleteProject(projectNames[i]);
                        }
                        ++i;
                    }
                }
            }
        }, null);
    }

    public void deleteResource(IResource resource) throws CoreException {
        int retryCount = 0;
        while (++retryCount <= 60) {
            if (Util.delete((IResource)resource)) continue;
            System.gc();
        }
    }

    protected boolean deltaChildrenChanged(IJavaScriptElementDelta delta) {
        return delta.getKind() == 4 && (delta.getFlags() & 8) != 0;
    }

    protected boolean deltaContentChanged(IJavaScriptElementDelta delta) {
        return delta.getKind() == 4 && (delta.getFlags() & 1) != 0;
    }

    protected boolean deltaMovedFrom(IJavaScriptElementDelta delta) {
        return delta.getKind() == 1 && (delta.getFlags() & 0x10) != 0;
    }

    protected boolean deltaMovedTo(IJavaScriptElementDelta delta) {
        return delta.getKind() == 2 && (delta.getFlags() & 0x20) != 0;
    }

    public void ensureCorrectPositioning(IParent container, IJavaScriptElement sibling, IJavaScriptElement positioned) throws JavaScriptModelException {
        IJavaScriptElement[] children = container.getChildren();
        if (sibling != null) {
            boolean found = false;
            int i = 0;
            while (i < children.length) {
                if (children[i].equals(sibling)) {
                    AbstractJavaModelTests.assertTrue((String)"element should be before sibling", (i > 0 && children[i - 1].equals(positioned) ? 1 : 0) != 0);
                    found = true;
                    break;
                }
                ++i;
            }
            AbstractJavaModelTests.assertTrue((String)"Did not find sibling", (boolean)found);
        }
    }

    public IClassFile getClassFile(String projectName, String rootPath, String packageName, String className) throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment(projectName, rootPath, packageName);
        if (pkg == null) {
            return null;
        }
        return pkg.getClassFile(className);
    }

    protected IJavaScriptUnit getCompilationUnit(String path) {
        return (IJavaScriptUnit)JavaScriptCore.create((IFile)this.getFile(path));
    }

    public IJavaScriptUnit getCompilationUnit(String projectName, String rootPath, String packageName, String cuName) throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment(projectName, rootPath, packageName);
        if (pkg == null) {
            return null;
        }
        return pkg.getJavaScriptUnit(cuName);
    }

    public IJavaScriptUnit[] getCompilationUnits(String projectName, String rootPath, String packageName) throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment(projectName, rootPath, packageName);
        if (pkg == null) {
            return null;
        }
        return pkg.getJavaScriptUnits();
    }

    protected IJavaScriptUnit getCompilationUnitFor(IJavaScriptElement element) {
        if (element instanceof IJavaScriptUnit) {
            return (IJavaScriptUnit)element;
        }
        if (element instanceof IMember) {
            return ((IMember)element).getJavaScriptUnit();
        }
        if (element instanceof IPackageDeclaration || element instanceof IImportDeclaration) {
            return (IJavaScriptUnit)element.getParent();
        }
        return null;
    }

    protected IJavaScriptElementDelta getDeltaFor(IJavaScriptElement element) {
        return this.getDeltaFor(element, false);
    }

    protected IJavaScriptElementDelta getDeltaFor(IJavaScriptElement element, boolean returnFirst) {
        IJavaScriptElementDelta[] deltas = this.deltaListener.deltas;
        if (deltas == null) {
            return null;
        }
        IJavaScriptElementDelta result = null;
        int i = 0;
        while (i < deltas.length) {
            IJavaScriptElementDelta delta = this.searchForDelta(element, this.deltaListener.deltas[i]);
            if (delta != null) {
                if (returnFirst) {
                    return delta;
                }
                result = delta;
            }
            ++i;
        }
        return result;
    }

    protected IPath getExternalJCLPath() {
        return new Path(this.getExternalJCLPathString(""));
    }

    protected IPath getExternalJCLPath(String compliance) {
        return new Path(this.getExternalJCLPathString(compliance));
    }

    protected String getExternalJCLPathString() {
        return this.getSystemJsPath();
    }

    protected String getExternalJCLPathString(String compliance) {
        return this.getSystemJsPath();
    }

    private String getSystemJsPath() {
        IPath targetRoot = new Path(System.getProperty("user.dir")).removeLastSegments(1);
        IPath pluginDir = targetRoot.append((IPath)new Path("org.eclipse.wst.jsdt.core"));
        IPath libDir = pluginDir.append((IPath)new Path(new String(SystemLibraryLocation.LIBRARY_PLUGIN_DIRECTORY)));
        IPath fullDir = libDir.append((IPath)new Path(new String(SystemLibraryLocation.SYSTEM_LIBARAY_NAME)));
        return fullDir.toOSString();
    }

    protected IPath getExternalJCLRootSourcePath() {
        return new Path("src");
    }

    protected IPath getExternalJCLSourcePath() {
        return new Path(this.getExternalJCLSourcePathString(""));
    }

    protected IPath getExternalJCLSourcePath(String compliance) {
        return new Path(this.getExternalJCLSourcePathString(compliance));
    }

    protected String getExternalJCLSourcePathString() {
        return this.getExternalJCLSourcePathString("");
    }

    protected String getExternalJCLSourcePathString(String compliance) {
        return String.valueOf(this.getExternalPath()) + "jclMin" + compliance + "src.zip";
    }

    protected String getExternalPath() {
        if (EXTERNAL_JAR_DIR_PATH == null) {
            try {
                String path = this.getWorkspaceRoot().getLocation().toFile().getParentFile().getCanonicalPath();
                if (path.charAt(path.length() - 1) != File.separatorChar) {
                    path = String.valueOf(path) + File.separatorChar;
                }
                EXTERNAL_JAR_DIR_PATH = path;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return EXTERNAL_JAR_DIR_PATH;
    }

    protected IFile getFile(String path) {
        return this.getWorkspaceRoot().getFile((IPath)new Path(path));
    }

    protected IFolder getFolder(IPath path) {
        return this.getWorkspaceRoot().getFolder(path);
    }

    public IJavaScriptModel getJavaModel() {
        return JavaScriptCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public IJavaScriptProject getJavaProject(String name) {
        IProject project = this.getProject(name);
        return JavaScriptCore.create((IProject)project);
    }

    protected ILocalVariable getLocalVariable(ISourceReference cu, String selectAt, String selection) throws JavaScriptModelException {
        IJavaScriptElement[] elements = this.codeSelect(cu, selectAt, selection);
        if (elements.length == 0) {
            return null;
        }
        if (elements[0] instanceof ILocalVariable) {
            return (ILocalVariable)elements[0];
        }
        return null;
    }

    protected ILocalVariable getLocalVariable(String cuPath, String selectAt, String selection) throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit(cuPath);
        return this.getLocalVariable((ISourceReference)cu, selectAt, selection);
    }

    protected String getNameSource(String cuSource, IJavaScriptElement element) throws JavaScriptModelException {
        ISourceRange nameRange = element instanceof ITypeParameter ? ((ITypeParameter)element).getNameRange() : ((IMember)element).getNameRange();
        int start = nameRange.getOffset();
        int end = start + nameRange.getLength();
        String actualSource = start >= 0 && end >= start ? cuSource.substring(start, end) : "";
        return actualSource;
    }

    public IPackageFragment getPackageFragment(String projectName, String rootPath, String packageName) throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(projectName, rootPath);
        if (root == null) {
            return null;
        }
        return root.getPackageFragment(packageName);
    }

    public IPackageFragmentRoot getPackageFragmentRoot(String projectName, String rootPath) throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject(projectName);
        if (project == null) {
            return null;
        }
        Path path = new Path(rootPath);
        if (path.isAbsolute()) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = workspaceRoot.findMember((IPath)path);
            IPackageFragmentRoot root = resource == null ? project.getPackageFragmentRoot(rootPath) : project.getPackageFragmentRoot(resource);
            return root;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        if (roots == null || roots.length == 0) {
            return null;
        }
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!root.isExternal() && root.getUnderlyingResource().getProjectRelativePath().equals((Object)path)) {
                return root;
            }
            ++i;
        }
        return null;
    }

    protected IProject getProject(String project) {
        return this.getWorkspaceRoot().getProject(project);
    }

    protected String getPluginDirectoryPath() {
        try {
            URL platformURL = Platform.getBundle((String)"org.eclipse.wst.jsdt.core.tests.model").getEntry("/");
            return new File(FileLocator.toFileURL((URL)platformURL).getFile()).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSourceWorkspacePath() {
        return String.valueOf(this.getPluginDirectoryPath()) + File.separator + "workspace";
    }

    public IJavaScriptUnit getWorkingCopy(String path, boolean computeProblems) throws JavaScriptModelException {
        return this.getWorkingCopy(path, "", computeProblems);
    }

    public IJavaScriptUnit getWorkingCopy(String path, String source) throws JavaScriptModelException {
        return this.getWorkingCopy(path, source, false);
    }

    public IJavaScriptUnit getWorkingCopy(String path, String source, boolean computeProblems) throws JavaScriptModelException {
        if (this.wcOwner == null) {
            this.wcOwner = new WorkingCopyOwner(){};
        }
        return this.getWorkingCopy(path, source, this.wcOwner, computeProblems);
    }

    public IJavaScriptUnit getWorkingCopy(String path, String source, WorkingCopyOwner owner, boolean computeProblems) throws JavaScriptModelException {
        IProblemRequestor problemRequestor = computeProblems ? new IProblemRequestor(){

            public void acceptProblem(IProblem problem) {
            }

            public void beginReporting() {
            }

            public void endReporting() {
            }

            public boolean isActive() {
                return true;
            }
        } : null;
        return this.getWorkingCopy(path, source, owner, problemRequestor);
    }

    public IJavaScriptUnit getWorkingCopy(String path, String source, WorkingCopyOwner owner, IProblemRequestor problemRequestor) throws JavaScriptModelException {
        IJavaScriptUnit workingCopy = this.getCompilationUnit(path);
        if (owner != null) {
            workingCopy = workingCopy.getWorkingCopy(owner, problemRequestor, null);
        } else {
            workingCopy.becomeWorkingCopy(problemRequestor, null);
        }
        workingCopy.getBuffer().setContents(source);
        if (problemRequestor instanceof ProblemRequestor) {
            ((ProblemRequestor)problemRequestor).initialize(source.toCharArray());
        }
        workingCopy.makeConsistent(null);
        return workingCopy;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    protected void discardWorkingCopies(IJavaScriptUnit[] units) throws JavaScriptModelException {
        if (units == null) {
            return;
        }
        int i = 0;
        int length = units.length;
        while (i < length) {
            if (units[i] != null) {
                units[i].discardWorkingCopy();
            }
            ++i;
        }
    }

    protected String displayString(String toPrint, int indent) {
        char[] toDisplay = CharOperation.replace((char[])toPrint.toCharArray(), (char[])this.getExternalJCLPathString().toCharArray(), (char[])"getExternalJCLPathString()".toCharArray());
        toDisplay = CharOperation.replace((char[])toDisplay, (char[])this.getExternalJCLPathString("1.5").toCharArray(), (char[])"getExternalJCLPathString(\"1.5\")".toCharArray());
        toDisplay = CharOperation.replace((char[])toDisplay, (char[])Util.displayString((String)this.getExternalJCLSourcePathString(), (int)0).toCharArray(), (char[])"getExternalJCLSourcePathString()".toCharArray());
        toDisplay = CharOperation.replace((char[])toDisplay, (char[])Util.displayString((String)this.getExternalJCLSourcePathString("1.5"), (int)0).toCharArray(), (char[])"getExternalJCLSourcePathString(\"1.5\")".toCharArray());
        toDisplay = Util.displayString((String)new String(toDisplay), (int)indent).toCharArray();
        toDisplay = CharOperation.replace((char[])toDisplay, (char[])"getExternalJCLPathString()".toCharArray(), (char[])"\"+ getExternalJCLPathString() + \"".toCharArray());
        toDisplay = CharOperation.replace((char[])toDisplay, (char[])"getExternalJCLPathString(\\\"1.5\\\")".toCharArray(), (char[])"\"+ getExternalJCLPathString(\"1.5\") + \"".toCharArray());
        toDisplay = CharOperation.replace((char[])toDisplay, (char[])"getExternalJCLSourcePathString()".toCharArray(), (char[])"\"+ getExternalJCLSourcePathString() + \"".toCharArray());
        toDisplay = CharOperation.replace((char[])toDisplay, (char[])"getExternalJCLSourcePathString(\\\"1.5\\\")".toCharArray(), (char[])"\"+ getExternalJCLSourcePathString(\"1.5\") + \"".toCharArray());
        return new String(toDisplay);
    }

    protected IJavaScriptUnit newExternalWorkingCopy(String name, String contents) throws JavaScriptModelException {
        return this.newExternalWorkingCopy(name, null, null, contents);
    }

    protected IJavaScriptUnit newExternalWorkingCopy(String name, IIncludePathEntry[] classpath, IProblemRequestor problemRequestor, final String contents) throws JavaScriptModelException {
        WorkingCopyOwner owner = new WorkingCopyOwner(){

            public IBuffer createBuffer(IJavaScriptUnit wc) {
                IBuffer buffer = super.createBuffer(wc);
                buffer.setContents(contents);
                return buffer;
            }
        };
        return owner.newWorkingCopy(name, classpath, problemRequestor, null);
    }

    public byte[] read(File file) throws IOException {
        int fileLength = (int)file.length();
        byte[] fileBytes = new byte[fileLength];
        FileInputStream stream = new FileInputStream(file);
        int bytesRead = 0;
        int lastReadSize = 0;
        while (lastReadSize != -1 && bytesRead != fileLength) {
            lastReadSize = stream.read(fileBytes, bytesRead, fileLength - bytesRead);
            bytesRead += lastReadSize;
        }
        stream.close();
        return fileBytes;
    }

    protected void removeJavaNature(String projectName) throws CoreException {
        IProject project = this.getProject(projectName);
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[0]);
        project.setDescription(description, null);
    }

    protected void removeLibrary(IJavaScriptProject javaProject, String jarName, String sourceZipName) throws CoreException, IOException {
        IProject project = javaProject.getProject();
        String projectPath = String.valueOf('/') + project.getName() + '/';
        this.removeLibraryEntry(javaProject, new Path(String.valueOf(projectPath) + jarName));
        Util.delete((IResource)project.getFile(jarName));
        if (sourceZipName != null && sourceZipName.length() != 0) {
            Util.delete((IResource)project.getFile(sourceZipName));
        }
    }

    protected void removeLibraryEntry(Path path) throws JavaScriptModelException {
        this.removeLibraryEntry(this.currentProject, path);
    }

    protected void removeLibraryEntry(IJavaScriptProject project, Path path) throws JavaScriptModelException {
        IIncludePathEntry[] entries = project.getRawIncludepath();
        int length = entries.length;
        IIncludePathEntry[] newEntries = null;
        int i = 0;
        while (i < length) {
            IIncludePathEntry entry = entries[i];
            if (entry.getPath().equals((Object)path)) {
                newEntries = new IIncludePathEntry[length - 1];
                if (i > 0) {
                    System.arraycopy(entries, 0, newEntries, 0, i);
                }
                if (i >= length - 1) break;
                System.arraycopy(entries, i + 1, newEntries, i, length - 1 - i);
                break;
            }
            ++i;
        }
        if (newEntries != null) {
            project.setRawIncludepath(newEntries, null);
        }
    }

    protected IJavaScriptElementDelta searchForDelta(IJavaScriptElement element, IJavaScriptElementDelta delta) {
        if (delta == null) {
            return null;
        }
        if (delta.getElement().equals(element)) {
            return delta;
        }
        int i = 0;
        while (i < delta.getAffectedChildren().length) {
            IJavaScriptElementDelta child = this.searchForDelta(element, delta.getAffectedChildren()[i]);
            if (child != null) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected void search(IJavaScriptElement element, int limitTo, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        this.search(element, limitTo, 8, scope, requestor);
    }

    protected void search(IJavaScriptElement element, int limitTo, int matchRule, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)element, (int)limitTo, (int)matchRule);
        AbstractJavaModelTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected void search(String patternString, int searchFor, int limitTo, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        this.search(patternString, searchFor, limitTo, 8, scope, requestor);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IJavaScriptSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule);
        AbstractJavaModelTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int[] selectionInfo(IJavaScriptUnit cu, String selection, int occurences) throws JavaScriptModelException {
        String source = cu.getSource();
        int index = occurences < 0 ? source.lastIndexOf(selection) : source.indexOf(selection);
        int max = Math.abs(occurences) - 1;
        int n = 0;
        while (index >= 0 && n < max) {
            index = occurences < 0 ? source.lastIndexOf(selection, index) : source.indexOf(selection, index + selection.length());
            ++n;
        }
        StringBuffer msg = new StringBuffer("Selection '");
        msg.append(selection);
        if (index >= 0) {
            if (selection.startsWith("/**")) {
                int start = source.indexOf("*/", index);
                if (start >= 0) {
                    return new int[]{start + 2, selection.length() - (start + 2 - index)};
                }
                msg.append("' starts with an unterminated comment");
            } else {
                if (!selection.endsWith("*/")) return new int[]{index, selection.length()};
                int end = source.lastIndexOf("/**", index + selection.length());
                if (end >= 0) {
                    return new int[]{index, index - end};
                }
                msg.append("' ends with an unstartted comment");
            }
        } else {
            msg.append("' was not found in ");
        }
        msg.append(cu.getElementName());
        msg.append(":\n");
        msg.append(source);
        AbstractJavaModelTests.assertTrue((String)msg.toString(), (boolean)false);
        return null;
    }

    protected IField selectField(IJavaScriptUnit unit, String selection) throws JavaScriptModelException {
        return this.selectField(unit, selection, 1);
    }

    protected IField selectField(IJavaScriptUnit unit, String selection, int occurences) throws JavaScriptModelException {
        return (IField)this.selectJavaElement(unit, selection, occurences, 8);
    }

    protected ILocalVariable selectLocalVariable(IJavaScriptUnit unit, String selection) throws JavaScriptModelException {
        return this.selectLocalVariable(unit, selection, 1);
    }

    protected ILocalVariable selectLocalVariable(IJavaScriptUnit unit, String selection, int occurences) throws JavaScriptModelException {
        return (ILocalVariable)this.selectJavaElement(unit, selection, occurences, 14);
    }

    protected IFunction selectMethod(IJavaScriptUnit unit, String selection) throws JavaScriptModelException {
        return this.selectMethod(unit, selection, 1);
    }

    protected IFunction selectMethod(IJavaScriptUnit unit, String selection, int occurences) throws JavaScriptModelException {
        return (IFunction)this.selectJavaElement(unit, selection, occurences, 9);
    }

    protected ResolvedSourceMethod selectParameterizedMethod(IJavaScriptUnit unit, String selection) throws JavaScriptModelException {
        return this.selectParameterizedMethod(unit, selection, 1);
    }

    protected ResolvedSourceMethod selectParameterizedMethod(IJavaScriptUnit unit, String selection, int occurences) throws JavaScriptModelException {
        IFunction type = this.selectMethod(unit, selection, occurences);
        AbstractJavaModelTests.assertTrue((String)("Not a parameterized source type: " + type.getElementName()), (boolean)(type instanceof ResolvedSourceMethod));
        return (ResolvedSourceMethod)type;
    }

    protected ResolvedSourceType selectParameterizedType(IJavaScriptUnit unit, String selection) throws JavaScriptModelException {
        return this.selectParameterizedType(unit, selection, 1);
    }

    protected ResolvedSourceType selectParameterizedType(IJavaScriptUnit unit, String selection, int occurences) throws JavaScriptModelException {
        IType type = this.selectType(unit, selection, occurences);
        AbstractJavaModelTests.assertTrue((String)("Not a parameterized source type: " + type.getElementName()), (boolean)(type instanceof ResolvedSourceType));
        return (ResolvedSourceType)type;
    }

    protected IType selectType(IJavaScriptUnit unit, String selection) throws JavaScriptModelException {
        return this.selectType(unit, selection, 1);
    }

    protected IType selectType(IJavaScriptUnit unit, String selection, int occurences) throws JavaScriptModelException {
        return (IType)this.selectJavaElement(unit, selection, occurences, 7);
    }

    protected ITypeParameter selectTypeParameter(IJavaScriptUnit unit, String selection) throws JavaScriptModelException {
        return this.selectTypeParameter(unit, selection, 1);
    }

    protected ITypeParameter selectTypeParameter(IJavaScriptUnit unit, String selection, int occurences) throws JavaScriptModelException {
        return (ITypeParameter)this.selectJavaElement(unit, selection, occurences, 15);
    }

    IJavaScriptElement selectJavaElement(IJavaScriptUnit unit, String selection, int occurences, int elementType) throws JavaScriptModelException {
        int[] selectionPositions = this.selectionInfo(unit, selection, occurences);
        IJavaScriptElement[] elements = null;
        elements = this.wcOwner == null ? unit.codeSelect(selectionPositions[0], selectionPositions[1]) : unit.codeSelect(selectionPositions[0], selectionPositions[1], this.wcOwner);
        AbstractJavaModelTests.assertEquals((String)"Invalid selection number", (int)1, (int)elements.length);
        AbstractJavaModelTests.assertEquals((String)("Invalid java element type: " + elements[0].getElementName()), (int)elements[0].getElementType(), (int)elementType);
        return elements[0];
    }

    public void setClasspath(IJavaScriptProject javaProject, IIncludePathEntry[] classpath) {
        try {
            javaProject.setRawIncludepath(classpath, null);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            AbstractJavaModelTests.assertTrue((String)"failed to set classpath", (boolean)false);
        }
    }

    public void setupExternalJCL(String jclName) throws IOException {
        String externalPath = this.getExternalPath();
        String separator = File.separator;
        String resourceJCLDir = String.valueOf(this.getPluginDirectoryPath()) + separator + "JCL";
        File jclDir = new File(externalPath);
        File jclMin = new File(String.valueOf(externalPath) + jclName + ".jar");
        File jclMinsrc = new File(String.valueOf(externalPath) + jclName + "src.zip");
        if (!jclDir.exists()) {
            if (!jclDir.mkdir()) {
                throw new IOException("Could not create the directory " + jclDir);
            }
            File resourceJCLMin = new File(String.valueOf(resourceJCLDir) + separator + jclName + ".jar");
            this.copy(resourceJCLMin, jclMin);
            File resourceJCLMinsrc = new File(String.valueOf(resourceJCLDir) + separator + jclName + "src.zip");
            this.copy(resourceJCLMinsrc, jclMinsrc);
        } else {
            File resourceJCLMin = new File(String.valueOf(resourceJCLDir) + separator + jclName + ".jar");
            if (jclMin.lastModified() < resourceJCLMin.lastModified() || jclMin.length() != resourceJCLMin.length()) {
                this.copy(resourceJCLMin, jclMin);
            }
            File resourceJCLMinsrc = new File(String.valueOf(resourceJCLDir) + separator + jclName + "src.zip");
            if (jclMinsrc.lastModified() < resourceJCLMinsrc.lastModified() || jclMinsrc.length() != resourceJCLMinsrc.length()) {
                this.copy(resourceJCLMinsrc, jclMinsrc);
            }
        }
    }

    protected IJavaScriptProject setUpJavaProject(String projectName) throws CoreException, IOException {
        this.currentProject = this.setUpJavaProject(projectName, "1.4");
        return this.currentProject;
    }

    protected IJavaScriptProject setUpJavaProject(String projectName, String compliance) throws CoreException, IOException {
        String sourceWorkspacePath = this.getSourceWorkspacePath();
        String targetWorkspacePath = this.getWorkspaceRoot().getLocation().toFile().getCanonicalPath();
        this.copyDirectory(new File(sourceWorkspacePath, projectName), new File(targetWorkspacePath, projectName));
        this.setUpJCLClasspathVariables(compliance);
        final IProject project = this.getWorkspaceRoot().getProject(projectName);
        IWorkspaceRunnable populate = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(null);
                project.open(null);
            }
        };
        this.getWorkspace().run(populate, null);
        IJavaScriptProject javaProject = JavaScriptCore.create((IProject)project);
        this.setUpProjectCompliance(javaProject, compliance);
        javaProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
        javaProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "ignore");
        javaProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
        javaProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.localVariableHiding", "ignore");
        javaProject.setOption("org.eclipse.wst.jsdt.core.compiler.problem.typeParameterHiding", "ignore");
        return javaProject;
    }

    protected void setUpProjectCompliance(IJavaScriptProject javaProject, String compliance) throws JavaScriptModelException, IOException {
        String version = "1.4";
        String jclLibString = null;
        String newJclLibString = null;
        String newJclSrcString = null;
        switch (compliance.charAt(2)) {
            case '5': {
                version = "1.5";
                if (version.equals(javaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", false))) {
                    return;
                }
                jclLibString = "JCL_LIB";
                newJclLibString = "JCL15_LIB";
                newJclSrcString = "JCL15_SRC";
                break;
            }
            case '3': {
                version = "1.3";
            }
            default: {
                if (version.equals(javaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", false))) {
                    return;
                }
                jclLibString = "JCL15_LIB";
                newJclLibString = "JCL_LIB";
                newJclSrcString = "JCL_SRC";
            }
        }
        this.setUpJCLClasspathVariables(compliance);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.wst.jsdt.core.compiler.compliance", version);
        options.put("org.eclipse.wst.jsdt.core.compiler.source", version);
        options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", version);
        javaProject.setOptions(options);
        IIncludePathEntry[] classpath = javaProject.getRawIncludepath();
        Path jclLib = new Path(jclLibString);
        int i = 0;
        int length = classpath.length;
        while (i < length) {
            IIncludePathEntry entry = classpath[i];
            if (entry.getPath().equals((Object)jclLib)) {
                classpath[i] = JavaScriptCore.newVariableEntry((IPath)new Path(newJclLibString), (IPath)new Path(newJclSrcString), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)entry.isExported());
                break;
            }
            ++i;
        }
        javaProject.setRawIncludepath(classpath, null);
    }

    public void setUpJCLClasspathVariables(String compliance) throws JavaScriptModelException, IOException {
        if ("1.5".equals(compliance)) {
            if (JavaScriptCore.getIncludepathVariable((String)"JCL15_LIB") == null) {
                JavaScriptCore.setIncludepathVariables((String[])new String[]{"JCL15_LIB", "JCL15_SRC", "JCL_SRCROOT"}, (IPath[])new IPath[]{this.getExternalJCLPath(compliance), this.getExternalJCLSourcePath(compliance), this.getExternalJCLRootSourcePath()}, null);
            }
        } else if (JavaScriptCore.getIncludepathVariable((String)"JCL_LIB") == null) {
            JavaScriptCore.setIncludepathVariables((String[])new String[]{"JCL_LIB", "JCL_SRC", "JCL_SRCROOT"}, (IPath[])new IPath[]{this.getExternalJCLPath(), this.getExternalJCLSourcePath(), this.getExternalJCLRootSourcePath()}, null);
        }
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IWorkspaceDescription description = this.getWorkspace().getDescription();
        if (description.isAutoBuilding()) {
            description.setAutoBuilding(false);
            this.getWorkspace().setDescription(description);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (NameLookup.VERBOSE || BasicSearchEngine.VERBOSE || JavaModelManager.VERBOSE) {
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println("Running test " + this.getName() + "...");
        }
    }

    protected void sortElements(IJavaScriptElement[] elements) {
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object a, Object b) {
                JavaElement elementA = (JavaElement)a;
                JavaElement elementB = (JavaElement)b;
                char[] tempJCLPath = "<externalJCLPath>".toCharArray();
                String idA = new String(CharOperation.replace((char[])elementA.toStringWithAncestors().toCharArray(), (char[])AbstractJavaModelTests.this.getExternalJCLPathString().toCharArray(), (char[])tempJCLPath));
                String idB = new String(CharOperation.replace((char[])elementB.toStringWithAncestors().toCharArray(), (char[])AbstractJavaModelTests.this.getExternalJCLPathString().toCharArray(), (char[])tempJCLPath));
                return idA.compareTo(idB);
            }
        };
        org.eclipse.wst.jsdt.internal.core.util.Util.sort((Object[])elements, (Util.Comparer)comparer);
    }

    protected void sortResources(Object[] resources) {
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object a, Object b) {
                IResource resourceA = (IResource)a;
                IResource resourceB = (IResource)b;
                return resourceA.getFullPath().toString().compareTo(resourceB.getFullPath().toString());
            }
        };
        org.eclipse.wst.jsdt.internal.core.util.Util.sort((Object[])resources, (Util.Comparer)comparer);
    }

    protected void sortTypes(IType[] types) {
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object a, Object b) {
                IType typeA = (IType)a;
                IType typeB = (IType)b;
                return typeA.getFullyQualifiedName().compareTo(typeB.getFullyQualifiedName());
            }
        };
        org.eclipse.wst.jsdt.internal.core.util.Util.sort((Object[])types, (Util.Comparer)comparer);
    }

    protected void simulateExit() throws CoreException {
        AbstractJavaModelTests.waitForAutoBuild();
        this.getWorkspace().save(true, null);
        JavaModelManager.getJavaModelManager().shutdown();
    }

    protected void simulateExitRestart() throws CoreException {
        this.simulateExit();
        this.simulateRestart();
    }

    protected void simulateRestart() throws CoreException {
        JavaModelManager.doNotUse();
        JavaModelManager.getJavaModelManager().startup();
        new JavaCorePreferenceInitializer().initializeDefaultPreferences();
    }

    public void startDeltas() {
        this.clearDeltas();
        JavaScriptCore.addElementChangedListener((IElementChangedListener)this.deltaListener);
    }

    public void stopDeltas() {
        JavaScriptCore.removeElementChangedListener((IElementChangedListener)this.deltaListener);
        this.clearDeltas();
    }

    protected IPath[] toIPathArray(String[] paths) {
        if (paths == null) {
            return null;
        }
        int length = paths.length;
        IPath[] result = new IPath[length];
        int i = 0;
        while (i < length) {
            result[i] = new Path(paths[i]);
            ++i;
        }
        return result;
    }

    protected String toString(String[] strings) {
        return this.toString(strings, false);
    }

    protected String toString(String[] strings, boolean addExtraNewLine) {
        if (strings == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = strings.length;
        while (i < length) {
            buffer.append(strings[i]);
            if (addExtraNewLine || i < length - 1) {
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.workingCopies != null) {
            this.discardWorkingCopies(this.workingCopies);
            this.workingCopies = null;
        }
        this.wcOwner = null;
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    public static void waitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static void waitUntilIndexesReady() {
        SearchEngine engine = new SearchEngine();
        IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
        try {
            engine.searchAllTypeNames(null, 0, "!@$#!@".toCharArray(), 10, 5, scope, new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                }
            }, 3, null);
        }
        catch (CoreException coreException) {}
    }

    protected class DeltaListener
    implements IElementChangedListener {
        public IJavaScriptElementDelta[] deltas;
        public ByteArrayOutputStream stackTraces;

        protected DeltaListener() {
        }

        public void elementChanged(ElementChangedEvent ev) {
            IJavaScriptElementDelta[] copy = new IJavaScriptElementDelta[this.deltas.length + 1];
            System.arraycopy(this.deltas, 0, copy, 0, this.deltas.length);
            copy[this.deltas.length] = ev.getDelta();
            this.deltas = copy;
        }

        public JavaScriptUnit getCompilationUnitAST(IJavaScriptUnit workingCopy) {
            int i = 0;
            int length = this.deltas.length;
            while (i < length) {
                JavaScriptUnit result = this.getCompilationUnitAST(workingCopy, this.deltas[i]);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }

        private JavaScriptUnit getCompilationUnitAST(IJavaScriptUnit workingCopy, IJavaScriptElementDelta delta) {
            if ((delta.getFlags() & 0x80000) != 0 && workingCopy.equals(delta.getElement())) {
                return delta.getJavaScriptUnitAST();
            }
            return null;
        }

        protected void sortDeltas(IJavaScriptElementDelta[] elementDeltas) {
            Util.Comparer comparer = new Util.Comparer(this){
                final /* synthetic */ DeltaListener this$1;
                {
                    this.this$1 = deltaListener;
                }

                public int compare(Object a, Object b) {
                    IJavaScriptElementDelta deltaA = (IJavaScriptElementDelta)a;
                    IJavaScriptElementDelta deltaB = (IJavaScriptElementDelta)b;
                    return deltaA.getElement().getElementName().compareTo(deltaB.getElement().getElementName());
                }
            };
            org.eclipse.wst.jsdt.internal.core.util.Util.sort((Object[])elementDeltas, (Util.Comparer)comparer);
            int i = 0;
            int max = elementDeltas.length;
            while (i < max) {
                IJavaScriptElementDelta delta = elementDeltas[i];
                IJavaScriptElementDelta[] children = delta.getAffectedChildren();
                if (children != null) {
                    this.sortDeltas(children);
                }
                ++i;
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            int length = this.deltas.length;
            while (i < length) {
                int resourceDeltasLength;
                IJavaScriptElementDelta delta = this.deltas[i];
                IJavaScriptElementDelta[] children = delta.getAffectedChildren();
                int childrenLength = children.length;
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                int n = resourceDeltasLength = resourceDeltas == null ? 0 : resourceDeltas.length;
                if (childrenLength == 0 && resourceDeltasLength == 0) {
                    buffer.append(delta);
                } else {
                    this.sortDeltas(children);
                    int j = 0;
                    while (j < childrenLength) {
                        buffer.append(children[j]);
                        if (j != childrenLength - 1) {
                            buffer.append("\n");
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < resourceDeltasLength) {
                        if (j == 0 && buffer.length() != 0) {
                            buffer.append("\n");
                        }
                        buffer.append(resourceDeltas[j]);
                        if (j != resourceDeltasLength - 1) {
                            buffer.append("\n");
                        }
                        ++j;
                    }
                }
                if (i != length - 1) {
                    buffer.append("\n\n");
                }
                ++i;
            }
            return buffer.toString();
        }
    }

    public static class ProblemRequestor
    implements IProblemRequestor {
        public StringBuffer problems;
        public int problemCount;
        protected char[] unitSource;

        public ProblemRequestor() {
            this.initialize(null);
        }

        public void acceptProblem(IProblem problem) {
            Util.appendProblem((StringBuffer)this.problems, (IProblem)problem, (char[])this.unitSource, (int)(++this.problemCount));
            this.problems.append("----------\n");
        }

        public void beginReporting() {
            this.problems.append("----------\n");
        }

        public void endReporting() {
            if (this.problemCount == 0) {
                this.problems.append("----------\n");
            }
        }

        public boolean isActive() {
            return true;
        }

        public void initialize(char[] source) {
            this.problems = new StringBuffer();
            this.problemCount = 0;
            this.unitSource = source;
        }
    }
}

