/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.tests.dom.AbstractASTTests;

public class CompatibilityRulesTests
extends AbstractASTTests {
    static /* synthetic */ Class class$0;

    public CompatibilityRulesTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.CompatibilityRulesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CompatibilityRulesTests.buildModelTestSuite(clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    public void test001() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should be subtype compatible with Y", (boolean)bindings[1].isSubTypeCompatible(bindings[0]));
    }

    public void test002() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}"}, new String[]{"Lp1/X;"});
        CompatibilityRulesTests.assertTrue((String)"X should be subtype compatible with itself", (boolean)bindings[0].isSubTypeCompatible(bindings[0]));
    }

    public void test003() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should not be subtype compatible with Y", (!bindings[0].isSubTypeCompatible(bindings[1]) ? 1 : 0) != 0);
    }

    public void test004() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should not be subtype compatible with Y", (!bindings[0].isSubTypeCompatible(bindings[1]) ? 1 : 0) != 0);
    }

    public void test005() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"I", "J"});
        CompatibilityRulesTests.assertTrue((String)"int should not be subtype compatible with long", (!bindings[0].isSubTypeCompatible(bindings[1]) ? 1 : 0) != 0);
    }

    public void test006() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"I", "Ljava/lang/Object;"});
        CompatibilityRulesTests.assertTrue((String)"int should not be subtype compatible with Object", (!bindings[0].isSubTypeCompatible(bindings[1]) ? 1 : 0) != 0);
    }

    public void test007() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should be assignment compatible with Y", (boolean)bindings[1].isAssignmentCompatible(bindings[0]));
    }

    public void test008() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}"}, new String[]{"Lp1/X;"});
        CompatibilityRulesTests.assertTrue((String)"X should be assignment compatible with itself", (boolean)bindings[0].isAssignmentCompatible(bindings[0]));
    }

    public void test009() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should not be assignment compatible with Y", (!bindings[0].isAssignmentCompatible(bindings[1]) ? 1 : 0) != 0);
    }

    public void test010() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should not be assigment compatible with Y", (!bindings[0].isAssignmentCompatible(bindings[1]) ? 1 : 0) != 0);
    }

    public void test011() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"I", "J"});
        CompatibilityRulesTests.assertTrue((String)"int should be assignment compatible with long", (boolean)bindings[0].isAssignmentCompatible(bindings[1]));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test012() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P14", new String[]{""}, new String[]{"JCL_LIB"}, "", "1.4");
            ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"I", "Ljava/lang/Object;"}, project);
            CompatibilityRulesTests.assertTrue((String)"int should not be assignment compatible with Object", (!bindings[0].isAssignmentCompatible(bindings[1]) ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P14");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P14");
    }

    public void test013() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should be cast compatible with Y", (boolean)bindings[1].isCastCompatible(bindings[0]));
    }

    public void test014() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}"}, new String[]{"Lp1/X;"});
        CompatibilityRulesTests.assertTrue((String)"X should be cast compatible with itself", (boolean)bindings[0].isCastCompatible(bindings[0]));
    }

    public void test015() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should be cast compatible with Y", (boolean)bindings[0].isCastCompatible(bindings[1]));
    }

    public void test016() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n}"}, new String[]{"Lp1/X;", "Lp1/Y;"});
        CompatibilityRulesTests.assertTrue((String)"X should not be cast compatible with Y", (!bindings[0].isCastCompatible(bindings[1]) ? 1 : 0) != 0);
    }

    public void test017() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"I", "J"});
        CompatibilityRulesTests.assertTrue((String)"int should be cast compatible with long", (boolean)bindings[0].isCastCompatible(bindings[1]));
    }

    public void test018() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"I", "Ljava/lang/Object;"});
        CompatibilityRulesTests.assertTrue((String)"int should not be cast compatible with Object", (!bindings[0].isCastCompatible(bindings[1]) ? 1 : 0) != 0);
    }

    public void test019() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n  void foo() {\n  }\n}"}, new String[]{"Lp1/Y;.foo()V", "Lp1/X;.foo()V"});
        CompatibilityRulesTests.assertTrue((String)"Y#foo() should override X#foo()", (boolean)bindings[0].overrides(bindings[1]));
    }

    public void test020() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n  void foo() {\n  }\n}"}, new String[]{"Lp1/X;.foo()V", "Lp1/Y;.foo()V"});
        CompatibilityRulesTests.assertTrue((String)"X#foo() should not override Y#foo()", (!bindings[0].overrides(bindings[1]) ? 1 : 0) != 0);
    }

    public void test021() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n  void foo() {\n  }\n}"}, new String[]{"Lp1/X;.foo()V", "Lp1/Y;.foo()V"});
        CompatibilityRulesTests.assertTrue((String)"X#foo() should not override Y#foo()", (!bindings[0].overrides(bindings[1]) ? 1 : 0) != 0);
    }

    /*
     * Exception decompiling
     */
    public void test022() throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 71->75)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void test023() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/java/lang/Integer.js", "package java.lang;\npublic class Integer {\n}"}, new String[]{"I", "Ljava/lang/Integer;"});
        CompatibilityRulesTests.assertTrue((String)"int should be assignment compatible with Integer", (boolean)bindings[0].isAssignmentCompatible(bindings[1]));
    }

    public void test024() throws JavaScriptModelException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"I", "Ljava/lang/Object;"});
        CompatibilityRulesTests.assertTrue((String)"int should be assignment compatible with Object", (boolean)bindings[0].isAssignmentCompatible(bindings[1]));
    }

    public void test025() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}"}, new String[]{"Lp1/X;.foo()V"});
        CompatibilityRulesTests.assertTrue((String)"X#foo() should be a subsignature of X#foo()", (boolean)bindings[0].isSubsignature(bindings[0]));
    }

    public void test026() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  String foo(Object o) {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n  String foo(Object o) {\n  }\n}"}, new String[]{"Lp1/X;.foo(Ljava/lang/Object;)Ljava/lang/String;", "Lp1/Y;.foo(Ljava/lang/Object;)Ljava/lang/String;"});
        CompatibilityRulesTests.assertTrue((String)"Y#foo(Object) should be a subsignature of X#foo(Object)", (boolean)bindings[1].isSubsignature(bindings[0]));
    }

    public void test027() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T>  {\n  Z<T> foo(Z<T> o) {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n  Z foo(Z o) {\n  }\n}", "/P/p1/Z.js", "package p1;\npublic class Z<T> {\n}"}, new String[]{"Lp1/X;.foo(Lp1/Z<TT;>;)Lp1/Z<TT;>;", "Lp1/Y;.foo(Lp1/Z;)Lp1/Z;"});
        CompatibilityRulesTests.assertTrue((String)"Y#foo(Z) should be a subsignature of X#foo(Z<T>)", (boolean)bindings[1].isSubsignature(bindings[0]));
    }

    public void test028() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n  void bar() {\n  }\n}"}, new String[]{"Lp1/X;.foo()V", "Lp1/Y;.bar()V"});
        CompatibilityRulesTests.assertTrue((String)"Y#bar() should not be a subsignature of X#foo()", (!bindings[1].isSubsignature(bindings[0]) ? 1 : 0) != 0);
    }

    public void test029() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n  void bar() {\n  }\n}"}, new String[]{"Lp1/Y;.bar()V", "Lp1/X;.foo()V"});
        CompatibilityRulesTests.assertTrue((String)"Y#bar() should not override X#foo()", (!bindings[0].overrides(bindings[1]) ? 1 : 0) != 0);
    }

    public void test030() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  void foo(T t) {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X<String> {\n  void foo(String s) {\n  }\n}"}, new String[]{"Lp1/Y;.foo(Ljava/lang/String;)V", "Lp1/X;.foo(TT;)V"});
        CompatibilityRulesTests.assertTrue((String)"Y#foo(String) should override X#foo(T)", (boolean)bindings[0].overrides(bindings[1]));
    }

    public void test031() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}\nclass Y extends X {\n  <T> void foo() {\n  }\n}"}, new String[]{"Lp1/X;.foo()V", "Lp1/Y;.foo<T:Ljava/lang/Object;>()V"});
        CompatibilityRulesTests.assertFalse((String)"Y#foo() should not be a subsignature of X#foo()", (boolean)bindings[1].isSubsignature(bindings[0]));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test032() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, "", "1.4");
            IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  Object foo() {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n  String foo() {\n  }\n}"}, new String[]{"Lp1/Y;.foo()Ljava/lang/String;", "Lp1/X;.foo()Ljava/lang/Object;"}, project);
            CompatibilityRulesTests.assertTrue((String)"Y#foo() should override X#foo()", (boolean)bindings[0].overrides(bindings[1]));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P2");
    }

    public void test033() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  private void foo() {\n  }\n}", "/P/p1/Y.js", "package p1;\npublic class Y extends X {\n  void foo() {\n  }\n}"}, new String[]{"Lp1/Y;.foo()V", "Lp1/X;.foo()V"});
        CompatibilityRulesTests.assertTrue((String)"Y#foo() should not override X#foo()", (!bindings[0].overrides(bindings[1]) ? 1 : 0) != 0);
    }

    public void test034() throws JavaScriptModelException {
        IFunctionBinding[] bindings = this.createMethodBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}", "/P/p2/Y.js", "package p2;\npublic class Y extends p1.X {\n  void foo() {\n  }\n}"}, new String[]{"Lp2/Y;.foo()V", "Lp1/X;.foo()V"});
        CompatibilityRulesTests.assertTrue((String)"Y#foo() should not override X#foo()", (!bindings[0].overrides(bindings[1]) ? 1 : 0) != 0);
    }
}

