/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractComparableTest;

public class StaticImportTest
extends AbstractComparableTest {
    static /* synthetic */ Class class$0;

    public StaticImportTest(String name) {
        super(name);
    }

    public static Test suite() {
        return StaticImportTest.buildComparableTestSuite(StaticImportTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.StaticImportTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.Math.*;\nimport static java.lang.Math.PI;\npublic class X { double pi = abs(PI); }\n"}, "");
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p2.Y.*;\nimport static p2.Z.Zint;\nimport static p2.Z.ZMember;\npublic class X {\n\tint x = y(1);\n\tint y = Yint;\n\tint z = Zint;\n\tvoid m1(YMember m) {}\n\tvoid m2(ZMember m) {}\n}\n", "p2/Y.java", "package p2;\npublic class Y {\n\tpublic static int Yint = 1;\n\tpublic static int y(int y) { return y; }\n\tpublic static class YMember {}\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tpublic static int Zint = 1;\n\tpublic static class ZMember {}\n}\n"}, "");
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p2.Y.*;\nimport static p2.Z.Zint;\nimport static p2.Z.ZMember;\npublic class X {\n\tint x = y(1);\n\tint y = Yint;\n\tint z = Zint;\n\tvoid m1(YMember m) {}\n\tvoid m2(ZMember m) {}\n}\n", "p2/YY.java", "package p2;\npublic class YY {\n\tpublic static int Yint = 1;\n\tpublic static int y(int y) { return y; }\n\tpublic static class YMember {}\n}\n", "p2/Y.java", "package p2;\npublic class Y extends YY {}\n", "p2/ZZ.java", "package p2;\npublic class ZZ {\n\tpublic static int Zint = 1;\n\tpublic static class ZMember {}\n}\n", "p2/Z.java", "package p2;\npublic class Z extends ZZ {}\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.A.C;\npublic class X { int i = C; }\n", "p/A.java", "package p;\npublic class A extends B implements I {}\nclass B implements I {}\n", "p/I.java", "package p;\npublic interface I { public static int C = 1; }\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.A.C;\npublic class X { \n\tint i = C; \n\tint j = p.A.C; \n}\n", "p/A.java", "package p;\npublic class A implements I {}\ninterface I { public static int C = 1; }\n"}, "");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p2.Y.*;\nimport static p2.Z.Zint;\nimport static p2.Z.ZMember;\npublic class X {\n\tint x = y(1);\n\tint y = Yint;\n\tint z = Zint;\n\tvoid m1(YMember m) {}\n\tvoid m2(ZMember m) {}\n}\n", "p2/Y.java", "package p2;\npublic class Y {\n\tpublic int Yint = 1;\n\tpublic int y(int y) { return y; }\n\tpublic class YMember {}\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tpublic int Zint = 1;\n\tpublic class ZMember {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\timport static p2.Z.Zint;\n\t              ^^^^^^^^^\nThe import p2.Z.Zint cannot be resolved\n----------\n2. ERROR in p\\X.java (at line 4)\n\timport static p2.Z.ZMember;\n\t              ^^^^^^^^^^^^\nThe import p2.Z.ZMember cannot be resolved\n----------\n3. ERROR in p\\X.java (at line 6)\n\tint x = y(1);\n\t        ^\nThe method y(int) is undefined for the type X\n----------\n4. ERROR in p\\X.java (at line 7)\n\tint y = Yint;\n\t        ^^^^\nYint cannot be resolved\n----------\n5. ERROR in p\\X.java (at line 8)\n\tint z = Zint;\n\t        ^^^^\nZint cannot be resolved\n----------\n6. ERROR in p\\X.java (at line 9)\n\tvoid m1(YMember m) {}\n\t        ^^^^^^^\nYMember cannot be resolved to a type\n----------\n7. ERROR in p\\X.java (at line 10)\n\tvoid m2(ZMember m) {}\n\t        ^^^^^^^\nZMember cannot be resolved to a type\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p2.Y.*;\nimport static p2.Z.Zint;\nimport static p2.Z.ZMember;\npublic class X {\n\tint x = y(1);\n\tint y = Yint;\n\tint z = Zint;\n\tvoid m1(YMember m) {}\n\tvoid m2(ZMember m) {}\n}\n", "p2/Y.java", "package p2;\npublic class Y {\n\tstatic int Yint = 1;\n\tstatic int y(int y) { return y; }\n\tstatic class YMember {}\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tstatic int Zint = 1;\n\tstatic class ZMember {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\timport static p2.Z.Zint;\n\t              ^^^^^^^^^\nThe field Z.p2.Z.Zint is not visible\n----------\n2. ERROR in p\\X.java (at line 4)\n\timport static p2.Z.ZMember;\n\t              ^^^^^^^^^^^^\nThe type p2.Z.ZMember is not visible\n----------\n3. ERROR in p\\X.java (at line 6)\n\tint x = y(1);\n\t        ^\nThe method y(int) from the type Y is not visible\n----------\n4. ERROR in p\\X.java (at line 7)\n\tint y = Yint;\n\t        ^^^^\nThe field Y.Yint is not visible\n----------\n5. ERROR in p\\X.java (at line 8)\n\tint z = Zint;\n\t        ^^^^\nZint cannot be resolved\n----------\n6. ERROR in p\\X.java (at line 9)\n\tvoid m1(YMember m) {}\n\t        ^^^^^^^\nThe type YMember is not visible\n----------\n7. ERROR in p\\X.java (at line 10)\n\tvoid m2(ZMember m) {}\n\t        ^^^^^^^\nZMember cannot be resolved to a type\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p2.Z.ZStatic;\nimport static p2.Z.ZNonStatic;\nimport p2.Z.ZNonStatic;\npublic class X {\n\tvoid m2(ZStatic m) {}\n\tvoid m3(ZNonStatic m) {}\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tpublic static class ZStatic {}\n\tpublic class ZNonStatic {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\timport static p2.Z.ZNonStatic;\n\t              ^^^^^^^^^^^^^^^\nThe import p2.Z.ZNonStatic cannot be resolved\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p2.Z.ZFieldOverMember;\npublic class X {\n\tint z = ZFieldOverMember;\n}\n", "p2/Z.java", "package p2;\npublic class Z {\n\tpublic static int ZFieldOverMember = 1;\n\tpublic class ZFieldOverMember {}\n}\n"}, "");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static java.lang.System;\npublic class X {}\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\timport static java.lang.System;\n\t              ^^^^^^^^^^^^^^^^\nThe static import java.lang.System must be a field or member type\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static java.lang.reflect.Method.*;\npublic class X {Method m;}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\tpublic class X {Method m;}\n\t                ^^^^^^\nMethod cannot be resolved to a type\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "import static java.lang.System.*;\npublic class X {\n\tvoid foo() { arraycopy(); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo() { arraycopy(); }\n\t             ^^^^^^^^^\nThe method arraycopy(Object, int, Object, int, int) in the type System is not applicable for the arguments ()\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "import static p.Y.*;\npublic class X extends p.Z {}\nclass XX extends M.N {}\nclass XXX extends M.Missing {}\n", "p/YY.java", "package p;\npublic class YY {\n\tpublic static class M {\n\t\tpublic static class N {}\n\t}\n}\n", "p/Y.java", "package p;\npublic class Y extends YY {}\n", "p/Z.java", "package p;\npublic class Z {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tclass XXX extends M.Missing {}\n\t                  ^^^^^^^^^\nM.Missing cannot be resolved to a type\n----------\n");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.Math.*;\npublic class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(max(1, 2));\n\t}\n}\n"}, "2");
        this.runConformTest(new String[]{"X.java", "import static java.lang.Math.max;\npublic class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.println(max(1, 3));\n\t}\n}\n"}, "3");
        this.runConformTest(new String[]{"X.java", "import static p1.C.F;\nimport p2.*;\npublic class X implements F {\tint i = F();}\n", "p1/C.java", "package p1;\npublic class C {\n\tpublic static int F() { return 0; }\n}\n", "p2/F.java", "package p2;\npublic interface F {}\n"}, "");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "import static p.Y.ZZ;\nimport static p.Z.ZZ.WW;\nimport static p.Z.Zz.WW;\nimport static p.Z.Zz.*;\nimport static p.Z.Zz.Zzz;\nimport static p.Y.Zz;\nimport static p.Z.Zz.WW.*;\nimport p.Y.ZZ;\nimport static p.Y.ZZ.*;\nimport static p.Y.ZZ.WW;\nimport static p.Y.ZZ.WW.*;\nimport static p.Y.ZZ.ZZZ;\nimport static p.Y.ZZ.WW.WWW;\npublic class X {\n\tint i = Zzz + Zzzz;\n\tZZ z;\n\tWW w;\n}\n", "p/Y.java", "package p;\npublic class Y extends Z {}\n", "p/Z.java", "package p;\npublic class Z {\n\tpublic class Zz extends W { public static final int Zzz = 0; public static final int Zzzz = 1; }\n\tpublic static class ZZ extends W { public static final int ZZZ = 0; }\n}\n", "p/W.java", "package p;\npublic class W {\n\tpublic static class WW { public static final int WWW = 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\r\n\timport static p.Y.Zz;\r\n\t              ^^^^^^\nThe import p.Y.Zz cannot be resolved\n----------\n2. ERROR in X.java (at line 7)\r\n\timport static p.Z.Zz.WW.*;\r\n\t              ^^^^^^^^^\nThe import p.Z.Zz.WW cannot be resolved\n----------\n3. ERROR in X.java (at line 8)\r\n\timport p.Y.ZZ;\r\n\t       ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n4. ERROR in X.java (at line 9)\r\n\timport static p.Y.ZZ.*;\r\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n5. ERROR in X.java (at line 10)\r\n\timport static p.Y.ZZ.WW;\r\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n6. ERROR in X.java (at line 11)\r\n\timport static p.Y.ZZ.WW.*;\r\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n7. ERROR in X.java (at line 12)\r\n\timport static p.Y.ZZ.ZZZ;\r\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n8. ERROR in X.java (at line 13)\r\n\timport static p.Y.ZZ.WW.WWW;\r\n\t              ^^^^^^\nThe import p.Y.ZZ cannot be resolved\n----------\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "import static p.Z.ZZ.ZZZ;\npublic class X {}\n", "p/Z.java", "package p;\npublic class Z {\n\tpublic class ZZ { public static final  int ZZZ = 0; }\n}\n"}, "");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "import p.Z.*;\nimport static p.Z.*;\npublic class X { int i = COUNT; }\n", "p/Z.java", "package p;\npublic class Z {\n\tpublic static final  int COUNT = 0;\n}\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.Z.*;\nimport p.Z.*;\npublic class X { int i = COUNT; }\n", "p/Z.java", "package p;\npublic class Z {\n\tpublic static final  int COUNT = 0;\n}\n"}, "");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "import static java.lang.*;\npublic class X {}\n"}, "----------\n1. ERROR in X.java (at line 1)\r\n\timport static java.lang.*;\r\n\t              ^^^^^^^^^\nOnly a type can be imported. java.lang resolves to a package\n----------\n");
    }

    public void test017() {
        this.runConformTest(new String[]{"bug/A.java", "package bug;\nimport static bug.C.*;\npublic class A {\n   private B b;\n}\n", "bug/B.java", "package bug;\nimport static bug.C.*;\npublic class B {\n}\n", "bug/C.java", "package bug;\npublic class C {\n   private B b;\n}\n"}, "");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"bug/A.java", "package bug;\nimport static bug.C.*;\npublic class A {\n   private B b2 = b;\n}\n", "bug/B.java", "package bug;\nimport static bug.C.*;\npublic class B {\n}\n", "bug/C.java", "package bug;\npublic class C {\n   private static B b;\n}\n"}, "----------\n1. ERROR in bug\\A.java (at line 4)\n\tprivate B b2 = b;\n\t               ^\nThe field C.b is not visible\n----------\n----------\n1. WARNING in bug\\B.java (at line 2)\n\timport static bug.C.*;\n\t              ^^^^^\nThe import bug.C is never used\n----------\n----------\n1. WARNING in bug\\C.java (at line 3)\n\tprivate static B b;\n\t                 ^\nThe field C.b is never read locally\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "import static java.lang.Math.PI;\n\npublic class X {\n  boolean PI;\n  Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "import static java.lang.Math.round;\npublic class X {\n  void foo() { cos(0); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo() { cos(0); }\n\t             ^^^\nThe method cos(int) is undefined for the type X\n----------\n");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "import static p.B.foo;\npublic class X {\n  void test() { foo(); }\n}\n", "p/A.java", "package p;\npublic class A { public static void foo() {} }\n", "p/B.java", "package p;\npublic class B extends A { }\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "import static p.B.foo;\npublic class X {\n  void test() { foo(); }\n}\n", "p/A.java", "package p;\npublic class A { public void foo() {} }\n", "p/B.java", "package p;\npublic class B extends A { static void foo(int i) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p.B.foo;\n\t              ^^^^^^^\nThe import p.B.foo cannot be resolved\n----------\n2. ERROR in X.java (at line 3)\n\tvoid test() { foo(); }\n\t              ^^^\nThe method foo() is undefined for the type X\n----------\n");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "import static p.A.F;\nimport static p.B.F;\npublic class X {\n\tint i = F;\n}\n", "p/A.java", "package p;\npublic class A { public static class F {} }\n", "p/B.java", "package p;\npublic class B { public static int F = 2; }\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.A.F;\nimport static p.B.F;\npublic class X {\n\tint i = F + F();\n}\n", "p/A.java", "package p;\npublic class A { public static int F() { return 1; } }\n", "p/B.java", "package p;\npublic class B { public static int F = 2; }\n"}, "");
        this.runConformTest(new String[]{"X.java", "import static p.A.F;\nimport static p.B.F;\npublic class X {\n\tint i = F;\n}\n", "p/A.java", "package p;\npublic class A { public static int F = 1; }\n", "p/B.java", "package p;\npublic class B extends A {}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "import static p.A.F;\nimport static p.B.F;\npublic class X {\n\tint i = F;\n}\n", "p/A.java", "package p;\npublic class A { public static int F = 1; }\n", "p/B.java", "package p;\npublic class B { public static int F = 2; }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\timport static p.B.F;\n\t              ^^^^^\nThe import p.B.F collides with another import statement\n----------\n");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "import static p.A.C;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(C);\n\t\tSystem.out.print(C());\n\t}\n}\n", "p/A.java", "package p;\npublic class A {\n\tpublic static int C = 1;\n\tpublic static int C() { return C + 3; }\n}\n"}, "14");
        this.runConformTest(new String[]{"X.java", "import static p.A.C;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(C);\n\t\tSystem.out.print(C());\n\t}\n}\n", "p/A.java", "package p;\npublic class A extends B {\n\tpublic static int C() { return C + 3; }\n}\n", "p/B.java", "package p;\npublic class B {\n\tpublic static int C = 1;\n}\n"}, "14");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"p/B.java", "package p;\nimport static p.A.m;\nimport static p2.C.m;\nclass A { static void m() {} }\npublic class B { public static void main(String[] args) { m(); } }\n", "p2/C.java", "package p2;\npublic class C { public static void m() {} }\n"}, "----------\n1. ERROR in p\\B.java (at line 5)\r\n\tpublic class B { public static void main(String[] args) { m(); } }\r\n\t                                                          ^\nThe method m() is ambiguous for the type B\n----------\n");
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p.A.m;\nimport static p.B.m;\npublic class X { void test() { m(); } }\nclass B extends A {}\n", "p/A.java", "package p;\npublic class A { public static int m() { return 0; } }\n"}, "");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.Math.*;\npublic class X {\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print(max(PI, 4));\n\t\tnew Runnable() {\n\t\t\tpublic void run() {\n\t\t\t\tSystem.out.println(max(PI, 5));\n\t\t\t}\n\t\t}.run();\n\t}\n}\n"}, "4.05.0");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y { static void test() { java.lang.String.valueOf(0); } }\nclass Y { private String java; }\n"}, "");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "import static p.ST.foo;\npublic class X {\n\t\n\tfoo bar;\n}\n", "p/ST.java", "package p; \npublic class ST {\n\tpublic static int foo;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfoo bar;\n\t^^^\nfoo cannot be resolved to a type\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"p1/Z.java", "package p1;\npublic class Z {\n\tpublic interface I {\n\t}\n}\n", "q/Y.java", "package q;\nimport static p.X.I;\nimport static p1.Z.I;\npublic class Y implements I {\n}\n", "p/X.java", "package p;\npublic enum X {\n\tI, J, K\n}\n"}, "");
        this.runConformTest(new String[]{"q/Y.java", "package q;\nimport static p.X.I;\nimport static p1.Z.I;\npublic class Y implements I {\n}\n"}, "", null, false, null);
    }

    public void test029() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\nimport static p2.C.B;\npublic class A extends B {\n\tvoid test() {\t\tint i = B();\n\t\tB b = null;\n\t\tb.fooB();\n\t\tb.fooC();\n\t\tfooC();\n\t}\n}\n", "p1/B.java", "package p1;\npublic class B {\n\tpublic void fooB() {}\n}\n", "p2/C.java", "package p2;\npublic class C {\n\tpublic static class B { public void fooC() {} }\n\tpublic static int B() { return 0; }\n}\n"}, "----------\n1. ERROR in p1\\A.java (at line 6)\n\tb.fooB();\n\t  ^^^^\nThe method fooB() is undefined for the type C.B\n----------\n");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"p2/Test.java", "package p2;\nimport static p1.A.*;\npublic class Test {\n\tInner1 i; // not found\n\tInner2 j;\n}\n", "p1/A.java", "package p1;\npublic class A {\n\tpublic class Inner1 {}\n\tpublic static class Inner2 {}\n}\n"}, "----------\n1. ERROR in p2\\Test.java (at line 4)\n\tInner1 i; // not found\n\t^^^^^^\nInner1 cannot be resolved to a type\n----------\n");
        this.runConformTest(new String[]{"p2/Test.java", "package p2;\nimport p1.A.*;\nimport static p1.A.*;\nimport static p1.A.*;\npublic class Test {\n\tInner1 i;\n\tInner2 j;\n}\n", "p1/A.java", "package p1;\npublic class A {\n\tpublic class Inner1 {}\n\tpublic static class Inner2 {}\n}\n"}, "");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"PointRadius.java", "import static java.lang.Math.sqrt;\n\npublic class PointRadius {\n\n\tpublic static void main(String[] args) {\n\t\tdouble radius = 0;\n\t\tradius = sqrt(pondArea / Math.PI);\n\n\t}\n}\n"}, "----------\n1. ERROR in PointRadius.java (at line 7)\n\tradius = sqrt(pondArea / Math.PI);\n\t              ^^^^^^^^\npondArea cannot be resolved\n----------\n");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "import static p.A.*;\nimport static p.B.*;\npublic class X {\n\tpublic static void main(String[] args) {foo();}\n}\n", "p/A.java", "package p;public class A {\n\tpublic static void foo() {System.out.print(false);}\n}\n", "p/B.java", "package p;public class B extends A {\n\tpublic static void foo() {System.out.print(true);}\n}\n"}, "true");
    }

    public void test032b() {
        this.runNegativeTest(new String[]{"X2.java", "import static p2.A.*;\nimport static p2.B.*;\npublic class X2 { void test() {foo();} }\n", "p2/A.java", "package p2;public class A {\n\tpublic static void foo() {}\n}\n", "p2/B.java", "package p2;public class B {\n\tpublic static void foo() {}\n}\n"}, "----------\n1. ERROR in X2.java (at line 3)\r\n\tpublic class X2 { void test() {foo();} }\r\n\t                               ^^^\nThe method foo() is ambiguous for the type X2\n----------\n");
    }

    public void test032c() {
        this.runConformTest(new String[]{"X3.java", "import static p3.A.*;\nimport static p3.B.foo;\npublic class X3 {\n\tpublic static void main(String[] args) {foo();}\n}\n", "p3/A.java", "package p3;public class A {\n\tpublic static void foo() {System.out.print(false);}\n}\n", "p3/B.java", "package p3;public class B {\n\tpublic static void foo() {System.out.print(true);}\n}\n"}, "true");
    }

    public void test032d() {
        this.runConformTest(new String[]{"X4.java", "import static p4.A.foo;\nimport static p4.B.*;\npublic class X4 {\n\tpublic static void main(String[] args) {foo();}\n}\n", "p4/A.java", "package p4;public class A {\n\tpublic static void foo() {System.out.print(true);}\n}\n", "p4/B.java", "package p4;public class B extends A {\n\tpublic static void foo() {System.out.print(false);}\n}\n"}, "true");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "import static p.A.*;\nimport static p.B.*;\npublic class X {\n\tpublic static void main(String[] args) {foo(\"aa\");}\n}\n", "p/A.java", "package p;public class A {\n\tpublic static <U> void foo(U u) {System.out.print(false);}\n}\n", "p/B.java", "package p;public class B extends A {\n\tpublic static <V> void foo(String s) {System.out.print(true);}\n}\n"}, "true");
    }

    public void test033b() {
        this.runConformTest(new String[]{"X2.java", "import static p2.A.*;\nimport static p2.B.*;\npublic class X2 {\n\tpublic static void main(String[] args) {foo(\"aa\");}\n}\n", "p2/A.java", "package p2;public class A {\n\tpublic static <U> void foo(String s) {System.out.print(true);}\n}\n", "p2/B.java", "package p2;public class B extends A {\n\tpublic static <V> void foo(V v) {System.out.print(false);}\n}\n"}, "true");
    }

    public void test034() {
        this.runConformTest(new String[]{"test/AbstractTest.java", "package test;\npublic abstract class AbstractTest<Z> {\n  \n  public abstract MyEnum m(Z z);\n  \n  public enum MyEnum {\n    A,B\n  }\n}\n", "test/X.java", "package test;\nimport static test.AbstractTest.MyEnum.*;\npublic class X extends AbstractTest<String> {\n  @Override public MyEnum m(String s) {\n    return A;\n  }\n}\n"}, "");
    }

    public void test035() {
        this.runConformTest(new String[]{"Bug.java", "import static java.lang.String.format;\npublic class Bug extends p.TestCase {\n\tpublic static void main(String[] args) {\n\t\tString msg = \"test\";\n\t\tSystem.out.print(format(msg));\n\t\tSystem.out.print(format(msg, 1, 2));\n\t}\n}\n", "p/TestCase.java", "package p;\npublic class TestCase {\n\tstatic String format(String message, Object expected, Object actual) {return null;}\n}\n"}, "testtest");
        this.runNegativeTest(new String[]{"C.java", "class A {\n\tstatic class B { void foo(Object o, String s) {} }\n\tvoid foo(int i) {}\n}\nclass C extends A.B {\n\tvoid test() { foo(1); }\n}\n"}, "----------\n1. ERROR in C.java (at line 6)\r\n\tvoid test() { foo(1); }\r\n\t              ^^^\nThe method foo(Object, String) in the type A.B is not applicable for the arguments (int)\n----------\n");
        this.runNegativeTest(new String[]{"A.java", "public class A {\n  void foo(int i, long j) {}\n  class B {\n    void foo() { foo(1, 1); }\n  }\n}"}, "----------\n1. ERROR in A.java (at line 4)\n\tvoid foo() { foo(1, 1); }\n\t             ^^^\nThe method foo() in the type A.B is not applicable for the arguments (int, int)\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", "import static p.A.CONSTANT_I;\nimport static p.A.CONSTANT_B;\npublic class X {\n  static int i = p.A.CONSTANT_I;\n  static int j = p.A.CONSTANT_B;\n  static int m = CONSTANT_I;\n  static int n = CONSTANT_B;\n}", "p/A.java", "package p;\npublic class A extends B implements I {}\ninterface I { int CONSTANT_I = 1; }\nclass B { int CONSTANT_B = 1; }"}, "----------\n1. ERROR in X.java (at line 2)\n\timport static p.A.CONSTANT_B;\n\t              ^^^^^^^^^^^^^^\nThe field B.p.A.CONSTANT_B is not visible\n----------\n2. ERROR in X.java (at line 5)\n\tstatic int j = p.A.CONSTANT_B;\n\t                   ^^^^^^^^^^\nThe field B.CONSTANT_B is not visible\n----------\n3. ERROR in X.java (at line 7)\n\tstatic int n = CONSTANT_B;\n\t               ^^^^^^^^^^\nCONSTANT_B cannot be resolved\n----------\n");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "import static p.A.CONSTANT_I;\nimport static p.A.CONSTANT_B;\npublic class X {\n  static int i = p.A.CONSTANT_I;\n  static int j = p.A.CONSTANT_B;\n  static int m = CONSTANT_I;\n  static int n = CONSTANT_B;\n}", "p/A.java", "package p;\npublic class A extends B implements I {}\ninterface I { int CONSTANT_I = 1; }\nclass B { public static int CONSTANT_B = 1; }"}, "");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "import static p.A.foo_I;\nimport static p.A.foo_B;\npublic class X {\n  static int i = p.A.foo_I();\n  static int j = p.A.foo_B();\n  static int m = foo_I();\n  static int n = foo_B();\n}", "p/A.java", "package p;\npublic abstract class A extends B implements I {}\ninterface I { int foo_I(); }\nclass B { int foo_B() { return 2;} }"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p.A.foo_I;\n\t              ^^^^^^^^^\nThe import p.A.foo_I cannot be resolved\n----------\n2. ERROR in X.java (at line 2)\n\timport static p.A.foo_B;\n\t              ^^^^^^^^^\nThe import p.A.foo_B cannot be resolved\n----------\n3. ERROR in X.java (at line 4)\n\tstatic int i = p.A.foo_I();\n\t               ^^^^^^^^^^^\nCannot make a static reference to the non-static method foo_I() from the type I\n----------\n4. ERROR in X.java (at line 5)\n\tstatic int j = p.A.foo_B();\n\t                   ^^^^^\nThe method foo_B() from the type B is not visible\n----------\n5. ERROR in X.java (at line 6)\n\tstatic int m = foo_I();\n\t               ^^^^^\nThe method foo_I() is undefined for the type X\n----------\n6. ERROR in X.java (at line 7)\n\tstatic int n = foo_B();\n\t               ^^^^^\nThe method foo_B() is undefined for the type X\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "import static p.A.foo_I;\nimport static p.A.foo_B;\npublic class X {\n  static int i = p.A.foo_I();\n  static int j = p.A.foo_B();\n  static int m = foo_I();\n  static int n = foo_B();\n}", "p/A.java", "package p;\npublic abstract class A extends B implements I {}\ninterface I { int foo_I(); }\nclass B { public static int foo_B() { return 2;} }"}, "----------\n1. ERROR in X.java (at line 1)\r\n\timport static p.A.foo_I;\r\n\t              ^^^^^^^^^\nThe import p.A.foo_I cannot be resolved\n----------\n2. ERROR in X.java (at line 4)\r\n\tstatic int i = p.A.foo_I();\r\n\t               ^^^^^^^^^^^\nCannot make a static reference to the non-static method foo_I() from the type I\n----------\n3. ERROR in X.java (at line 6)\r\n\tstatic int m = foo_I();\r\n\t               ^^^^^\nThe method foo_I() is undefined for the type X\n----------\n");
    }

    public void test040() {
        this.runConformTest(new String[]{"p1/Z.java", "package p1;\npublic class Z {\n\tpublic interface I {\n\t}\n}\n", "q/Y.java", "package q;\nimport static p.X.foo;\nimport static p1.Z.I;\npublic class Y implements I {\n}\n", "p/X.java", "package p;\npublic class X {\n\tpublic static void foo() {}\n}\n"}, "");
        this.runConformTest(new String[]{"q/Y.java", "package q;\nimport static p.X.foo;\nimport static p1.Z.I;\npublic class Y implements I {\n}\n"}, "", null, false, null);
    }

    public void test041() {
        this.runNegativeTest(new String[]{"Test.java", "import static p.I.*;\nimport static p.J.*;\npublic class Test {\n\tint i = Constant;\n}\n", "p/I.java", "package p;\npublic interface I { static int Constant = 1; }\n", "p/J.java", "package p;\npublic interface J extends I {}\n"}, "----------\n1. WARNING in Test.java (at line 2)\n\timport static p.J.*;\n\t              ^^^\nThe import p.J is never used\n----------\n");
    }

    public void test042() {
        this.runNegativeTest(new String[]{"ImportTest.java", "import static p.ArrayTest.toString2;\npublic class ImportTest extends SuperTest {\n\tpublic static void main(String[] args) { printArgs(1, 2, 3, 4, 5); }\n\tstatic void printArgs(Object... args) { toString2(args); }\n}\nclass SuperTest {\n\tstatic void toString2() {}\n}\n", "p/ArrayTest.java", "package p;\npublic class ArrayTest {\n\tpublic static void toString2(String[] args) {}\n}\n"}, "----------\n1. ERROR in ImportTest.java (at line 4)\r\n\tstatic void printArgs(Object... args) { toString2(args); }\r\n\t                                        ^^^^^^^^^\nThe method toString2() in the type SuperTest is not applicable for the arguments (Object[])\n----------\n");
        this.runNegativeTest(new String[]{"ImportTest.java", "import static java.util.Arrays.toString;\npublic class ImportTest {\n\tpublic static void main(String[] args) { printArgs(1, 2, 3, 4, 5); }\n\tstatic void printArgs(Object... args) { toString(args); }\n}\n"}, "----------\n1. ERROR in ImportTest.java (at line 4)\n\tstatic void printArgs(Object... args) { toString(args); }\n\t                                        ^^^^^^^^\nThe method toString() in the type Object is not applicable for the arguments (Object[])\n----------\n");
    }

    public void test042b() {
        this.runConformTest(new String[]{"ImportTest.java", "import static p.DefinesFoo.foo;\npublic class ImportTest extends SuperImportTest {\n\tvoid test() { foo(\"fails?\"); }\n}\nclass SuperImportTest {\n\tprivate void foo() {}\n}\n", "p/DefinesFoo.java", "package p;\npublic class DefinesFoo {\n\tpublic static void foo(String s) {}\n}\n"}, "");
    }

    public void test043() {
        this.runConformTest(new String[]{"B.java", "import static java.lang.String.format;\npublic class B extends p.A {\n\tvoid test() { format(\"fails?\"); }\n\tvoid test2() { format(\"fails?\", null); }\n\tvoid test3() { format(\"fails?\", null, null); }\n\tvoid test4() { format(\"fails?\", null, null, null); }\n}\n", "p/A.java", "package p;\npublic class A {\n\tstatic String format(String message, Object expected, Object actual) { return null; }\n}\n"}, "");
    }

    public void test044() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static p.X.B.E;\nimport static p.X.B.*;\n\npublic class X {\n  public static class Y {\n    public enum E { FOO; }\n    public static Object E() { return null; }\n    public enum F { FOO; }\n    public static Object F() { return null; }\n  }\n  public static class B extends Y {}\n  Object f1 = E.FOO;\n  Object f2 = E();\n  Object f3 = F.FOO;\n  Object f4 = F();\n}\n"}, "");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "import static test.Y.arrayList;\npublic class X { static void arrayList(int x) { arrayList(); } }\n", "test/Y.java", "package test;\npublic class Y { public static void arrayList() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X { static void arrayList(int x) { arrayList(); } }\n\t                                                ^^^^^^^^^\nThe method arrayList(int) in the type X is not applicable for the arguments ()\n----------\n");
    }

    public void test045b() {
        this.runNegativeTest(new String[]{"test/One.java", "package test;\npublic class One { public static void arrayList(String s) {} }\n", "test/Two.java", "package test;\npublic class Two { public void arrayList(int i) {} }\n", "test/Three.java", "package test;\nimport static test.One.arrayList;\npublic class Three extends Two { public static void test(String s) { arrayList(s); } }\n"}, "----------\n1. ERROR in test\\Three.java (at line 3)\n\tpublic class Three extends Two { public static void test(String s) { arrayList(s); } }\n\t                                                                     ^^^^^^^^^\nThe method arrayList(int) in the type Two is not applicable for the arguments (String)\n----------\n");
        this.runNegativeTest(new String[]{"test/One.java", "package test;\npublic class One { public static void arrayList(String s) {} }\n", "test/Two.java", "package test;\npublic class Two { public static void arrayList(int i) {} }\n", "test/Three.java", "package test;\nimport static test.One.arrayList;\npublic class Three extends Two { public static void test(String s) { arrayList(s); } }\n"}, "----------\n1. ERROR in test\\Three.java (at line 3)\r\n\tpublic class Three extends Two { public static void test(String s) { arrayList(s); } }\r\n\t                                                                     ^^^^^^^^^\nThe method arrayList(int) in the type Two is not applicable for the arguments (String)\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"error/Exporter.java", "package error;\npublic class Exporter {\n  public static String getName(Class<?> c) {\n    return null;\n  }\n}", "error/Importer.java", "package error;\nimport static error.Exporter.getName;\npublic class Importer extends Base {\n  public void testSomething() {\n    getName();\n    getName(Importer.class);\n  }\n}", "error/Base.java", "package error;\npublic class Base {\n  public String getName() {\n    return \"name\";\n  }\n}"}, "----------\n1. ERROR in error\\Importer.java (at line 6)\n\tgetName(Importer.class);\n\t^^^^^^^\nThe method getName() in the type Base is not applicable for the arguments (Class<Importer>)\n----------\n");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"sample/X.java", "package sample;\nimport static sample.X.TestEnum.V1;\nimport static sample.X.TestEnum.V2;\n\npublic class X<T> {\n        public static enum TestEnum {\n                V1,\n                V2\n        }\n\n        public void test(final TestEnum value) {\n                switch (value) {\n                        case V1:\n                        case V2:\n                }\n        }\n\n        public void ref() {\n               final TestEnum v1 = TestEnum.V1;\n               final TestEnum v2 = TestEnum.V2;\n\t\t\t\tint i;\n\t\t\t\ti++;\n        }\n}"}, "----------\n1. WARNING in sample\\X.java (at line 2)\n\timport static sample.X.TestEnum.V1;\n\t              ^^^^^^^^^^^^^^^^^^^^\nThe import sample.X.TestEnum.V1 is never used\n----------\n2. WARNING in sample\\X.java (at line 3)\n\timport static sample.X.TestEnum.V2;\n\t              ^^^^^^^^^^^^^^^^^^^^\nThe import sample.X.TestEnum.V2 is never used\n----------\n3. ERROR in sample\\X.java (at line 22)\n\ti++;\n\t^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test048() {
        this.runNegativeTest(new String[]{"sample/X.java", "package sample;\nimport static sample.X.TestEnum.*;\n\npublic class X<T> {\n        public static enum TestEnum {\n                V1,\n                V2\n        }\n\n        public void test(final TestEnum value) {\n                switch (value) {\n                        case V1:\n                        case V2:\n                }\n        }\n\n        public void ref() {\n               final TestEnum v1 = TestEnum.V1;\n               final TestEnum v2 = TestEnum.V2;\n\t\t\t\tint i;\n\t\t\t\ti++;\n        }\n}"}, "----------\n1. WARNING in sample\\X.java (at line 2)\n\timport static sample.X.TestEnum.*;\n\t              ^^^^^^^^^^^^^^^^^\nThe import sample.X.TestEnum is never used\n----------\n2. ERROR in sample\\X.java (at line 21)\n\ti++;\n\t^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"sample/X.java", "package sample;\nimport static sample.X.*;\npublic class X {\n\tpublic class Member {}\n\tpublic void ref() {\n\t\tint i;\n\t\ti++;\n\t}\n}"}, "----------\n1. WARNING in sample\\X.java (at line 2)\n\timport static sample.X.*;\n\t              ^^^^^^^^\nThe import sample.X is never used\n----------\n2. ERROR in sample\\X.java (at line 7)\n\ti++;\n\t^\nThe local variable i may not have been initialized\n----------\n");
    }
}

