/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class FieldAccessTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public FieldAccessTest(String name) {
        super(name);
    }

    public static Test suite() {
        return FieldAccessTest.buildAllCompliancesTestSuite(FieldAccessTest.testClass());
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.indirectStaticAccess", "error");
        return options;
    }

    public void test001() {
        this.runConformTest(new String[]{"foo/BaseFoo.java", "package foo;\nclass BaseFoo {\n public static final int VAL = 0;\n}", "foo/NextFoo.java", "package foo;\npublic class NextFoo extends BaseFoo {\n}", "bar/Bar.java", "package bar;\npublic class Bar {\n int v = foo.NextFoo.VAL;\n}"}, "");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"foo/BaseFoo.java", "package foo;\npublic class BaseFoo {\n public static final int VAL = 0;\n}", "foo/NextFoo.java", "package foo;\npublic class NextFoo extends BaseFoo {\n}", "bar/Bar.java", "package bar;\npublic class Bar {\n int v = foo.NextFoo.VAL;\n}"}, "----------\n1. ERROR in bar\\Bar.java (at line 3)\n\tint v = foo.NextFoo.VAL;\n\t                    ^^^\nThe static field BaseFoo.VAL should be accessed directly\n----------\n");
    }

    public void test003() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runConformTest(new String[]{"foo/BaseFoo.java", "package foo;\nclass BaseFoo {\n public static final int VAL = 0;\n}", "foo/NextFoo.java", "package foo;\npublic class NextFoo extends BaseFoo {\n}", "bar/Bar.java", "package bar;\nimport foo.NextFoo;\npublic class Bar {\n\tNextFoo[] tab = new NextFoo[] { new NextFoo() };\n\tint v = tab[0].VAL;\n}"}, "", null, true, null, options, null);
    }

    public void test004() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"foo/BaseFoo.java", "package foo;\npublic class BaseFoo {\n public static final int VAL = 0;\n}", "foo/NextFoo.java", "package foo;\npublic class NextFoo extends BaseFoo {\n}", "bar/Bar.java", "package bar;\nimport foo.NextFoo;\npublic class Bar {\n\tNextFoo[] tab = new NextFoo[] { new NextFoo() };\n\tint v = tab[0].VAL;\n}"}, "----------\n1. ERROR in bar\\Bar.java (at line 5)\n\tint v = tab[0].VAL;\n\t               ^^^\nThe static field BaseFoo.VAL should be accessed directly\n----------\n", null, true, options);
    }

    public void test005() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unqualifiedFieldAccess", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate String memberVariable;\n\tpublic String getMemberVariable() {\n\t\treturn (memberVariable);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn (memberVariable);\n\t        ^^^^^^^^^^^^^^\nUnqualified access to the field X.memberVariable \n----------\n", null, true, options);
    }

    public void test006() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unqualifiedFieldAccess", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate String memberVariable;\n\tpublic String getMemberVariable() {\n\t\treturn \\u0028memberVariable\\u0029;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn \\u0028memberVariable\\u0029;\n\t             ^^^^^^^^^^^^^^\nUnqualified access to the field X.memberVariable \n----------\n", null, true, options);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.FieldAccessTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

