/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.tests.compiler.regression.ASTCollector;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CharLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;

class ASTBinaryExpressionCollector
extends ASTCollector {
    static final int LIMIT = 30;

    ASTBinaryExpressionCollector() {
    }

    String cut(String source) {
        int length = source.length();
        if (length > 30) {
            StringBuffer result = new StringBuffer(length);
            result.append(source.substring(0, 20));
            result.append("...");
            result.append(source.substring(length - 7, length));
            return result.toString();
        }
        return source;
    }

    public void endVisit(BinaryExpression binaryExpression, BlockScope scope) {
        this.collector.append("[ev BE " + this.cut(binaryExpression.toString()) + "]\n");
        super.endVisit(binaryExpression, scope);
    }

    public void endVisit(CharLiteral charLiteral, BlockScope scope) {
        this.collector.append("[ev CL " + this.cut(charLiteral.toString()) + "]\n");
        super.endVisit(charLiteral, scope);
    }

    public void endVisit(ExtendedStringLiteral literal, BlockScope scope) {
        this.collector.append("[ev ESL " + this.cut(literal.toString()) + "]\n");
        super.endVisit(literal, scope);
    }

    public void endVisit(SingleNameReference singleNameReference, BlockScope scope) {
        this.collector.append("[ev SNR " + this.cut(singleNameReference.toString()) + "]\n");
        super.endVisit(singleNameReference, scope);
    }

    public void endVisit(StringLiteral stringLiteral, BlockScope scope) {
        this.collector.append("[ev SL " + this.cut(stringLiteral.toString()) + "]\n");
        super.endVisit(stringLiteral, scope);
    }

    public void endVisit(StringLiteralConcatenation literal, BlockScope scope) {
        this.collector.append("[ev SLC " + this.cut(literal.toString()) + "]\n");
        super.endVisit(literal, scope);
    }

    public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
        this.collector.append("[v BE " + this.cut(binaryExpression.toString()) + "]\n");
        return super.visit(binaryExpression, scope);
    }

    public boolean visit(CharLiteral charLiteral, BlockScope scope) {
        this.collector.append("[v CL " + this.cut(charLiteral.toString()) + "]\n");
        return super.visit(charLiteral, scope);
    }

    public boolean visit(ExtendedStringLiteral literal, BlockScope scope) {
        this.collector.append("[v ESL " + this.cut(literal.toString()) + "]\n");
        return super.visit(literal, scope);
    }

    public boolean visit(SingleNameReference singleNameReference, BlockScope scope) {
        this.collector.append("[v SNR " + this.cut(singleNameReference.toString()) + "]\n");
        return super.visit(singleNameReference, scope);
    }

    public boolean visit(StringLiteral stringLiteral, BlockScope scope) {
        this.collector.append("[v SL " + this.cut(stringLiteral.toString()) + "]\n");
        return super.visit(stringLiteral, scope);
    }

    public boolean visit(StringLiteralConcatenation literal, BlockScope scope) {
        this.collector.append("[v SLC " + this.cut(literal.toString()) + "]\n");
        return super.visit(literal, scope);
    }
}

