/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import org.eclipse.wst.jsdt.internal.compiler.env.ISourceField;

public class SourceField
implements ISourceField {
    protected int modifiers;
    protected char[] typeName;
    protected char[] name;
    protected int declarationStart;
    protected int declarationEnd;
    protected int nameSourceStart;
    protected int nameSourceEnd;
    protected char[] source;

    public SourceField(int declarationStart, int modifiers, char[] typeName, char[] name, int nameSourceStart, int nameSourceEnd, char[] source) {
        this.declarationStart = declarationStart;
        this.modifiers = modifiers;
        this.typeName = typeName;
        this.name = name;
        this.nameSourceStart = nameSourceStart;
        this.nameSourceEnd = nameSourceEnd;
        this.source = source;
    }

    public String displayModifiers() {
        StringBuffer buffer = new StringBuffer();
        if (this.modifiers == 0) {
            return null;
        }
        if ((this.modifiers & 1) != 0) {
            buffer.append("public ");
        }
        if ((this.modifiers & 4) != 0) {
            buffer.append("protected ");
        }
        if ((this.modifiers & 2) != 0) {
            buffer.append("private ");
        }
        if ((this.modifiers & 0x10) != 0) {
            buffer.append("final ");
        }
        if ((this.modifiers & 8) != 0) {
            buffer.append("static ");
        }
        if ((this.modifiers & 0x400) != 0) {
            buffer.append("abstract ");
        }
        if ((this.modifiers & 0x100) != 0) {
            buffer.append("native ");
        }
        if ((this.modifiers & 0x20) != 0) {
            buffer.append("synchronized ");
        }
        return buffer.toString();
    }

    public String getActualName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.source, this.nameSourceStart, this.nameSourceEnd - this.nameSourceStart + 1);
        return buffer.toString();
    }

    public int getDeclarationSourceEnd() {
        return this.declarationEnd;
    }

    public int getDeclarationSourceStart() {
        return this.declarationStart;
    }

    public char[] getInitializationSource() {
        return null;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public char[] getName() {
        return this.name;
    }

    public int getNameSourceEnd() {
        return this.nameSourceEnd;
    }

    public int getNameSourceStart() {
        return this.nameSourceStart;
    }

    public char[] getTypeName() {
        return this.typeName;
    }

    protected void setDeclarationSourceEnd(int position) {
        this.declarationEnd = position;
    }

    public String tabString(int tab) {
        String s = "";
        int i = tab;
        while (i > 0) {
            s = String.valueOf(s) + "\t";
            --i;
        }
        return s;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.tabString(tab));
        String displayModifiers = this.displayModifiers();
        if (displayModifiers != null) {
            buffer.append(displayModifiers);
        }
        buffer.append("var ");
        buffer.append(this.name);
        buffer.append(";");
        return buffer.toString();
    }
}

