/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ComplianceDiagnoseTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public ComplianceDiagnoseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ComplianceDiagnoseTest.buildAllCompliancesTestSuite(ComplianceDiagnoseTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.parser.ComplianceDiagnoseTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void runComplianceParserTest(String[] testFiles, String expected13ProblemLog, String expected14ProblemLog, String expected15ProblemLog) {
        if ("1.3".equals(this.complianceLevel)) {
            this.runNegativeTest(testFiles, expected13ProblemLog);
        } else if ("1.4".equals(this.complianceLevel)) {
            this.runNegativeTest(testFiles, expected14ProblemLog);
        } else if (this.complianceLevel.compareTo("1.5") >= 0) {
            this.runNegativeTest(testFiles, expected15ProblemLog);
        }
    }

    public void test0001() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static aaa.BBB.*;\npublic class X {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.BBB.*;\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, static imports are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.BBB.*;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.BBB.*;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0002() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static aaa.BBB.CCC;\npublic class X {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.BBB.CCC;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, static imports are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.BBB.CCC;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.BBB.CCC;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0003() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public enum X {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic enum X {\n\t       ^^^^\nSyntax error on token \"enum\", interface expected\n----------\n";
        String expected15ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0004() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tfor(String o: c) {\n\t\t}\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(String o: c) {\n\t    ^^^^^^^^^^^\nSyntax error, 'for each' statements are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 3)\n\tfor(String o: c) {\n\t              ^\nc cannot be resolved\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(String o: c) {\n\t              ^\nc cannot be resolved\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0005() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(Z ... arg){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^\nZ cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^\nZ cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0006() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extends String, T2> extends Y {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                                               ^\nY cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                           ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                                               ^\nY cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0007() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public interface X <T1 extends String, T2> extends Y {\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic interface X <T1 extends String, T2> extends Y {\n\t                    ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 1)\n\tpublic interface X <T1 extends String, T2> extends Y {\n\t                                                   ^\nY cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic interface X <T1 extends String, T2> extends Y {\n\t                               ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 1)\n\tpublic interface X <T1 extends String, T2> extends Y {\n\t                                                   ^\nY cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0008() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String, T2> int foo(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t        ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t                   ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t                                   ^^^^^\nThis method must return a result of type int\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0009() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String, T2> X(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> X(){\n\t        ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T1 extends String, T2> X(){\n\t                   ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0010() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ<Y1, Y2> var;\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^^^^^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n3. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^\nY1 cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t      ^^\nY2 cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^\nY1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t      ^^\nY2 cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0011() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic X(){\n\t\t<Y1, Y2>this(null);\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t ^^^^^^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t ^^\nY1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t     ^^\nY2 cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t ^^\nY1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\t<Y1, Y2>this(null);\n\t     ^^\nY2 cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0012() {
        String expected14ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n  void foo() {\n    assert true;\n  }\n}\n\n"};
        String expected13ProblemLog = "----------\n1. WARNING in X.java (at line 3)\n\tassert true;\n\t^^^^^^\n'assert' should not be used as an identifier, since it is a reserved keyword from source level 1.4 on\n----------\n2. ERROR in X.java (at line 3)\n\tassert true;\n\t^^^^^^\nSyntax error on token \"assert\", AssignmentOperator expected after this token\n----------\n";
        String expected15ProblemLog = expected14ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0013() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static aaa.*\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t^^^^^^^^^^^^^^^^^\nSyntax error, static imports are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n3. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t                  ^\nSyntax error on token \"*\", ; expected after this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.*\n\t                  ^\nSyntax error on token \"*\", ; expected after this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0014() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public enum X \n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic enum X \n}\n\t       ^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic enum X \n\t            ^\nSyntax error on token \"X\", { expected after this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0015() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tfor(String o: c) {\n\t\t\t#\n\t\t}\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(String o: c) {\n\t    ^^^^^^^^^^^\nSyntax error, 'for each' statements are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0016() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(Z ... arg){\n\t}\n\t#\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^\nZ cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Z ... arg){\n\t         ^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0017() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extends String, T2> extends Y {\n\t#\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                                               ^\nY cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                           ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2> extends Y {\n\t                                               ^\nY cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0018() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String, T2> int foo(){\n\t}\n\t#\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t        ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T1 extends String, T2> int foo(){\n\t                   ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0019() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ<Y1, Y2> var;\n\t#\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^^^^^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n3. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^\nY1 cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t      ^^\nY2 cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 3)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t  ^^\nY1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tZ<Y1, Y2> var;\n\t      ^^\nY2 cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 3)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0020() {
        String expected14ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n  void foo() {\n    assert true;\n    #\n  }\n}\n\n"};
        String expected13ProblemLog = "----------\n1. WARNING in X.java (at line 3)\n\tassert true;\n\t^^^^^^\n'assert' should not be used as an identifier, since it is a reserved keyword from source level 1.4 on\n----------\n2. ERROR in X.java (at line 3)\n\tassert true;\n\t^^^^^^\nSyntax error on token \"assert\", AssignmentOperator expected after this token\n----------\n3. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        String expected15ProblemLog = expected14ProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\t#\n\t^\nSyntax error on token \"Invalid Character\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0021() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import staic aaa.*;\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport staic aaa.*;\n\t       ^^^^^\nThe import staic cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport staic aaa.*;\n\t             ^^^\nSyntax error on token \"aaa\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport staic aaa.*;\n\t       ^^^^^\nSyntax error on token \"staic\", static expected\n----------\n2. ERROR in X.java (at line 1)\n\timport staic aaa.*;\n\t       ^^^^^\nThe import staic cannot be resolved\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0022() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static aaa.*.*;\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t^^^^^^^^^^^^^^^^^\nSyntax error, static imports are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n3. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t                   ^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t              ^^^\nThe import aaa cannot be resolved\n----------\n2. ERROR in X.java (at line 1)\n\timport static aaa.*.*;\n\t                  ^\nSyntax error on token \"*\", Identifier expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0023() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static for;\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static for;\n\t       ^^^^^^^^^^\nSyntax error on tokens, Name expected instead\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static for;\n\t              ^^^\nSyntax error on token \"for\", Identifier expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void _test0024() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "import static {aaa};\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static {aaa};\n\t       ^^^^^^^^^^^^\nSyntax error on tokens, Name expected instead\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\timport static {aaa};\n\t              ^^^^^\nSyntax error on tokens, Name expected instead\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0025() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "static aaa.*;\npublic class X {\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tstatic aaa.*;\n\t^^^^^^\nSyntax error on token \"static\", import expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tstatic aaa.*;\n\t^^^^^^\nSyntax error on token \"static\", import expected before this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0026() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tfor(Object o ? c){\n\t\t}\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t    ^^^^^^\nSyntax error on token \"Object\", ( expected\n----------\n2. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t           ^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n3. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t                ^\nSyntax error, insert \"AssignmentOperator Expression\" to complete Assignment\n----------\n4. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t                ^\nSyntax error, insert \"; ; ) Statement\" to complete BlockStatements\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(Object o ? c){\n\t             ^\nSyntax error on token \"?\", : expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0027() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tfor(Object o : switch){\n\t\t}\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(Object o : switch){\n\t           ^\nSyntax error, insert \"; ; ) Statement\" to complete BlockStatements\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 3)\n\tfor(Object o : switch){\n\t               ^^^^^^\nSyntax error on token \"switch\", invalid Expression\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0028() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(int ... ){\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... ){\n\t             ^^^\nSyntax error on token \"...\", invalid VariableDeclaratorId\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... ){\n\t             ^^^\nSyntax error on token \"...\", VariableDeclaratorId expected after this token\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0029() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(int ... for){\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... for){\n\t             ^^^^^^^\nSyntax error on tokens, VariableDeclaratorId expected instead\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... for){\n\t                 ^^^\nSyntax error on token \"for\", invalid VariableDeclaratorId\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0030() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(int .. aaa){\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int .. aaa){\n\t             ^^\nSyntax error on tokens, delete these tokens\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int .. aaa){\n\t             ^^\nSyntax error on tokens, delete these tokens\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0031() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(int ... aaa bbb){\n\t}\n}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... aaa bbb){\n\t         ^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo(int ... aaa bbb){\n\t             ^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n4. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(int ... aaa bbb){\n\t                     ^^^\nSyntax error on token \"bbb\", delete this token\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0032() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extends String, T2 extends Y {\n\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t                           ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t                                              ^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends String, T2 extends Y {\n\t                                              ^\nY cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0033() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X T1 extends String, T2> extends Y {\n\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X T1 extends String, T2> extends Y {\n\t               ^^\nSyntax error on token \"T1\", delete this token\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X T1 extends String, T2> extends Y {\n\t                          ^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X T1 extends String, T2> extends Y {\n\t             ^\nSyntax error on token \"X\", < expected after this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0034() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extnds String, T2> extends Y {\n\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t               ^\nSyntax error on token \"<\", { expected\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                ^^^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, InterfaceHeaderName expected instead\n----------\n3. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                   ^^^^^^\nextnds cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                          ^^^^^^\nSyntax error on token \"String\", delete this token\n----------\n5. ERROR in X.java (at line 3)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                   ^^^^^^\nSyntax error on token \"extnds\", extends expected\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X <T1 extnds String, T2> extends Y {\n\t                   ^^^^^^\nextnds cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0035() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X <T1 extends for, T2> extends Y {\n\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends for, T2> extends Y {\n\t               ^^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X <T1 extends for, T2> extends Y {\n\t                           ^^^\nSyntax error on token \"for\", invalid ReferenceType\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0036() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String, T2> foo(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> foo(){\n\t        ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> foo(){\n\t                               ^^^^^\nReturn type for the method is missing\n----------\n";
        String expected15ProblemLog = "----------\n1. WARNING in X.java (at line 2)\n\tpublic <T1 extends String, T2> foo(){\n\t                   ^^^^^^\nThe type parameter T1 should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extends String, T2> foo(){\n\t                               ^^^^^\nReturn type for the method is missing\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0037() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extnds String, T2> int foo(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t       ^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t        ^^\nT1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t                            ^\nSyntax error on token \">\", ; expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t        ^^\nT1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extnds String, T2> int foo(){\n\t           ^^^^^^\nSyntax error on token \"extnds\", extends expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0038() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T1 extends String T2> int foo(){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String T2> int foo(){\n\t       ^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T1 extends String T2> int foo(){\n\t                            ^\nSyntax error on token \">\", ; expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T1 extends String T2> int foo(){\n\t                          ^^\nSyntax error on token \"T2\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0039() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ Y1, Y2> var;\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ Y1, Y2> var;\n\t        ^\nSyntax error on token \">\", , expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ Y1, Y2> var;\n\t^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 2)\n\tZ Y1, Y2> var;\n\t        ^\nSyntax error on token \">\", , expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0040() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ <Y1, Y2 var;\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ <Y1, Y2 var;\n\t  ^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n2. ERROR in X.java (at line 2)\n\tZ <Y1, Y2 var;\n\t       ^^\nY2 cannot be resolved to a type\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ <Y1, Y2 var;\n\t       ^^\nSyntax error, insert \">\" to complete ReferenceType1\n----------\n2. ERROR in X.java (at line 2)\n\tZ <Y1, Y2 var;\n\t       ^^\nY2 cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0041() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tZ <Y1, for Y2> var;\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ <Y1, for Y2> var;\n\t  ^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tZ <Y1, for Y2> var;\n\t       ^^^\nSyntax error on token \"for\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0042() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "void ___eval() {\n\tnew Runnable() {\n\t\tint ___run() throws Throwable {\n\t\t\treturn blah;\n\t\t}\n\t\tprivate String blarg;\n\t\tpublic void run() {\n\t\t}\n\t};\n}\npublic class X {\n\tprivate static int x;\n\tprivate String blah;\n\tpublic static void main(String[] args) {\n\t}\n\tpublic void hello() {\n\t}\n\tpublic boolean blah() {\n\t\treturn false;\n\t}\n\tpublic void foo() {\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 7)\n\tpublic void run() {\n\t\t}\n\t};\n}\n\t       ^^^^^^^^^^^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tvoid ___eval() {\n\t^^^^\nSyntax error on token \"void\", @ expected\n----------\n2. ERROR in X.java (at line 1)\n\tvoid ___eval() {\n\t             ^\nSyntax error on token \")\", delete this token\n----------\n3. ERROR in X.java (at line 9)\n\t};\n\t^\nSyntax error on token \"}\", { expected\n----------\n4. ERROR in X.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n5. ERROR in X.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"}\" to complete MemberValueArrayInitializer\n----------\n6. ERROR in X.java (at line 23)\n\t}\n\t^\nSyntax error, insert \")\" to complete Modifiers\n----------\n7. ERROR in X.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"enum Identifier\" to complete EnumHeader\n----------\n8. ERROR in X.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"EnumBody\" to complete JavaScriptUnit\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0043() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n}\npublic static void foo(){}\n\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n2. ERROR in X.java (at line 3)\n\tpublic static void foo(){}\n\t                         ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n";
        String expected15ProblemLog = expected13ProblemLog;
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0044() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic <T> X(T t){\n\t\tSystem.out.println(t);\n\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tclass Local extends X {\n\t\t\tLocal() {\n\t\t\t\t<String>super(\"SUCCESS\");\n\t\t\t}\n\t\t}\n\t\tnew Local();\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tpublic <T> X(T t){\n\t        ^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <T> X(T t){\n\t             ^\nT cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n4. ERROR in X.java (at line 9)\n\t<String>super(\"SUCCESS\");\n\t ^^^^^^\nSyntax error, type parameters are only available if source level is 5.0\n----------\n5. ERROR in X.java (at line 9)\n\t<String>super(\"SUCCESS\");\n\t ^^^^^^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n6. ERROR in X.java (at line 9)\n\t<String>super(\"SUCCESS\");\n\t        ^^^^^^^^^^^^^^^^^\nThe constructor X(String) is undefined\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0045() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tpublic void foo(){\n\t}\n\t}\n\tpublic void bar() {\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n";
        String expected15ProblemLog = expected13ProblemLog;
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0046() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public @interface X {\n\tString annName();\n}"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\tpublic @interface X {\n\t                  ^\nSyntax error, annotation declarations are only available if source level is 5.0\n----------\n";
        String expected15ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0047() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"A.java", "public @interface A {}", "X.java", "@A public class X {\n}"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in A.java (at line 1)\n\tpublic @interface A {}\n\t                  ^\nSyntax error, annotation declarations are only available if source level is 5.0\n----------\n----------\n1. ERROR in X.java (at line 1)\n\t@A public class X {\n\t^^\nSyntax error, annotations are only available if source level is 5.0\n----------\n";
        String expected15ProblemLog = "";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0048() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(X ... arg[]){\n\t}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(X ... arg[]){\n\t         ^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(X ... arg[]){\n\t               ^^^\nExtended dimensions are illegal for a variable argument\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0049() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "@interface MyAnn {\n\tString value1() default \"\";\n\tString value2();\n}\nclass ZZZ {}\t\t\npublic @MyAnn(\"\",\"\") class Test {\t\t\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 1)\n\t@interface MyAnn {\n\t           ^^^^^\nSyntax error, annotation declarations are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 6)\n\tpublic @MyAnn(\"\",\"\") class Test {\t\t\n\t              ^^\nSyntax error, insert \")\" to complete Modifier\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 6)\n\tpublic @MyAnn(\"\",\"\") class Test {\t\t\n\t                ^\nSyntax error on token \",\", / expected\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0050() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(List<String>... args) {}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t         ^^^^^^^^^^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t         ^^^^\nList cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t              ^^^^^^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(List<String>... args) {}\n\t         ^^^^\nList cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0051() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo(java.util.List2<String>... args) {}\n}\n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(java.util.List2<String>... args) {}\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nSyntax error, varargs are only available if source level is 5.0\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo(java.util.List2<String>... args) {}\n\t         ^^^^^^^^^^^^^^^\njava.util.List2 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 2)\n\tvoid foo(java.util.List2<String>... args) {}\n\t                         ^^^^^^\nSyntax error, parameterized types are only available if source level is 5.0\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(java.util.List2<String>... args) {}\n\t         ^^^^^^^^^^^^^^^\njava.util.List2 cannot be resolved to a type\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }

    public void test0052() {
        String expected13ProblemLog;
        String[] testFiles = new String[]{"X.java", "public class X {\n\tvoid foo1() {\n\t\tclass Y  {\n\t\t}\n\t\tvoid foo2() {\n\t\t}\n\t\tclass Z<T> { \n\t\t}\n\t}\n} \n"};
        String expected14ProblemLog = expected13ProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo2() {\n\t^^^^\nSyntax error on token \"void\", new expected\n----------\n2. ERROR in X.java (at line 7)\n\tclass Z<T> { \n\t^^^^^\nSyntax error on token \"class\", invalid AssignmentOperator\n----------\n3. ERROR in X.java (at line 7)\n\tclass Z<T> { \n\t         ^\nSyntax error on token \">\", ; expected\n----------\n";
        String expected15ProblemLog = "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo2() {\n\t^^^^\nSyntax error on token \"void\", new expected\n----------\n2. ERROR in X.java (at line 6)\n\t}\n\t^\nSyntax error, insert \";\" to complete Statement\n----------\n";
        this.runComplianceParserTest(testFiles, expected13ProblemLog, expected14ProblemLog, expected15ProblemLog);
    }
}

