/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.jsdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.wst.jsdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003,
		TokenNameUNKNOWN=1004;

	int
    TokenNameIdentifier = 32,
    TokenNameabstract = 87,
    TokenNameboolean = 88,
    TokenNamebreak = 59,
    TokenNamebyte = 89,
    TokenNamecase = 72,
    TokenNamecatch = 85,
    TokenNamechar = 90,
    TokenNameclass = 91,
    TokenNamecontinue = 60,
    TokenNameconst = 92,
    TokenNamedefault = 73,
    TokenNamedelete = 48,
    TokenNamedebugger = 93,
    TokenNamedo = 61,
    TokenNamedouble = 94,
    TokenNameelse = 70,
    TokenNameenum = 95,
    TokenNameexport = 96,
    TokenNameextends = 97,
    TokenNamefalse = 37,
    TokenNamefinal = 98,
    TokenNamefinally = 86,
    TokenNamefloat = 99,
    TokenNamefor = 62,
    TokenNamefunction = 56,
    TokenNamegoto = 100,
    TokenNameif = 63,
    TokenNamein = 25,
    TokenNameinfinity = 101,
    TokenNameimplements = 102,
    TokenNameimport = 103,
    TokenNameinstanceof = 11,
    TokenNameint = 104,
    TokenNameinterface = 105,
    TokenNamelong = 106,
    TokenNamenative = 107,
    TokenNamenew = 38,
    TokenNamenull = 39,
    TokenNamepackage = 108,
    TokenNameprivate = 109,
    TokenNameprotected = 110,
    TokenNamepublic = 111,
    TokenNamereturn = 64,
    TokenNameshort = 112,
    TokenNamestatic = 113,
    TokenNamestrictfp = 114,
    TokenNamesuper = 115,
    TokenNameswitch = 65,
    TokenNamesynchronized = 116,
    TokenNamethis = 40,
    TokenNamethrow = 66,
    TokenNamethrows = 117,
    TokenNametransient = 118,
    TokenNametrue = 41,
    TokenNametry = 67,
    TokenNametypeof = 49,
    TokenNameundefined = 42,
    TokenNamevar = 57,
    TokenNamevoid = 50,
    TokenNamevolatile = 119,
    TokenNamewith = 68,
    TokenNamewhile = 58,
    TokenNameIntegerLiteral = 34,
    TokenNameLongLiteral = 43,
    TokenNameFloatingPointLiteral = 44,
    TokenNameDoubleLiteral = 45,
    TokenNameCharacterLiteral = 35,
    TokenNameStringLiteral = 36,
    TokenNameRegExLiteral = 46,
    TokenNamePLUS_PLUS = 21,
    TokenNameMINUS_MINUS = 22,
    TokenNameEQUAL_EQUAL = 16,
    TokenNameEQUAL_EQUAL_EQUAL = 17,
    TokenNameNOT_EQUAL_EQUAL = 18,
    TokenNameLESS_EQUAL = 12,
    TokenNameGREATER_EQUAL = 13,
    TokenNameNOT_EQUAL = 19,
    TokenNameLEFT_SHIFT = 5,
    TokenNameRIGHT_SHIFT = 6,
    TokenNameUNSIGNED_RIGHT_SHIFT = 4,
    TokenNamePLUS_EQUAL = 74,
    TokenNameMINUS_EQUAL = 75,
    TokenNameMULTIPLY_EQUAL = 76,
    TokenNameDIVIDE_EQUAL = 77,
    TokenNameAND_EQUAL = 78,
    TokenNameOR_EQUAL = 79,
    TokenNameXOR_EQUAL = 80,
    TokenNameREMAINDER_EQUAL = 81,
    TokenNameLEFT_SHIFT_EQUAL = 82,
    TokenNameRIGHT_SHIFT_EQUAL = 83,
    TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 84,
    TokenNameOR_OR = 29,
    TokenNameAND_AND = 28,
    TokenNamePLUS = 1,
    TokenNameMINUS = 2,
    TokenNameNOT = 51,
    TokenNameREMAINDER = 7,
    TokenNameXOR = 24,
    TokenNameAND = 20,
    TokenNameMULTIPLY = 8,
    TokenNameOR = 26,
    TokenNameTWIDDLE = 47,
    TokenNameDIVIDE = 9,
    TokenNameGREATER = 14,
    TokenNameLESS = 15,
    TokenNameLPAREN = 3,
    TokenNameRPAREN = 33,
    TokenNameLBRACE = 53,
    TokenNameRBRACE = 69,
    TokenNameLBRACKET = 10,
    TokenNameRBRACKET = 54,
    TokenNameSEMICOLON = 31,
    TokenNameQUESTION = 30,
    TokenNameCOLON = 52,
    TokenNameCOMMA = 27,
    TokenNameDOT = 23,
    TokenNameEQUAL = 71,
    TokenNameAT = 120,
    TokenNameEOF = 55,
    TokenNameERROR = 121;
}
