/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.Iterator;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.html.core.internal.validate.AbstractErrorInfo;
import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.ErrorState;
import org.eclipse.wst.html.core.internal.validate.FMUtil;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.validate.ErrorInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.document.SourceValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SyntaxValidator
extends PrimeValidator
implements ErrorState {
    static /* synthetic */ Class class$0;

    private static boolean isValidRegion(ITextRegion rgn) {
        String type = rgn.getType();
        if (type == null) {
            return false;
        }
        return type == "XML_END_TAG_OPEN" || type == "XML_TAG_NAME" || type == "XML_TAG_CLOSE";
    }

    private static String getTagName(IStructuredDocumentRegion tag) {
        ITextRegionList regions = tag.getRegions();
        Iterator iter = regions.iterator();
        while (iter.hasNext()) {
            ITextRegion rgn = (ITextRegion)iter.next();
            if (rgn.getType() != "XML_TAG_NAME") continue;
            return tag.getText(rgn);
        }
        return "";
    }

    private static boolean isEmptyContent(CMElementDeclaration decl) {
        return decl != null && decl.getContentType() == 1;
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.html.core.internal.validate.SyntaxValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion indexedNode) {
        Node node = (Node)indexedNode;
        this.validateChildren(node);
        if (node.getNodeType() != 1) {
            return;
        }
        if (!(node instanceof IDOMElement)) {
            return;
        }
        ElementInfo info = new ElementInfo();
        info.target = (IDOMElement)node;
        this.getInfo(info);
        this.validateTags(info);
        if (info.target.isGlobalTag()) {
            this.validateNames(info);
            if (info.decl != null && info.isXHTML) {
                this.validateTagCase(info);
            }
        }
    }

    private void getInfo(ElementInfo info) {
        info.decl = CMUtil.getDeclaration((Element)info.target);
        info.startTag = info.target.getStartStructuredDocumentRegion();
        info.endTag = info.target.getEndStructuredDocumentRegion();
        Document doc = info.target.getOwnerDocument();
        if (!(doc instanceof IDOMDocument)) {
            return;
        }
        String typeid = ((IDOMDocument)doc).getDocumentTypeId();
        if (typeid != null) {
            HTMLDocumentTypeEntry entry = HTMLDocumentTypeRegistry.getInstance().getEntry(typeid);
            info.isXHTML = entry != null && entry.isXMLType();
        }
    }

    private boolean isEndTagCorrupted(ElementInfo info) {
        ITextRegionList regions = info.endTag.getRegions();
        if (regions == null || regions.isEmpty()) {
            return false;
        }
        Iterator iter = regions.iterator();
        while (iter.hasNext()) {
            ITextRegion rgn = (ITextRegion)iter.next();
            if (SyntaxValidator.isValidRegion(rgn)) continue;
            return true;
        }
        return false;
    }

    private String getEndTagFullText(ElementInfo info) {
        String hint = "";
        ITextRegionList regions = info.endTag.getRegions();
        Iterator iter = regions.iterator();
        while (iter.hasNext()) {
            ITextRegion rgn = (ITextRegion)iter.next();
            String type = rgn.getType();
            if (type == null || type == "XML_END_TAG_OPEN" || type == "XML_TAG_CLOSE") continue;
            hint = String.valueOf(hint) + info.endTag.getFullText(rgn);
        }
        return hint;
    }

    private void reportCorruptedEndTagError(ElementInfo info) {
        String hint = this.getEndTagFullText(info);
        TagErrorInfoImpl error = new TagErrorInfoImpl(11, info.endTag, hint);
        this.reporter.report((ErrorInfo)error);
    }

    private void validateTags(ElementInfo info) {
        Segment errorSeg;
        if (info.hasStartTag()) {
            if (!info.target.isStartTagClosed()) {
                errorSeg = new Segment(info.startTag);
                this.report(110, errorSeg, (Node)info.target);
            }
        } else if (info.hasEndTag() && info.decl != null) {
            if (!info.target.hasChildNodes()) {
                if (info.target.isContainer()) {
                    errorSeg = FMUtil.getSegment((IDOMNode)info.target, 3);
                    this.report(105, errorSeg, (Node)info.target);
                } else {
                    errorSeg = new Segment(info.endTag);
                    this.report(107, errorSeg, (Node)info.target);
                }
            } else if (info.isXHTML) {
                errorSeg = FMUtil.getSegment((IDOMNode)info.target, 5);
                this.report(105, errorSeg, (Node)info.target);
            }
        }
        if (info.hasEndTag()) {
            if (!info.target.isClosed()) {
                errorSeg = new Segment(info.endTag);
                this.report(111, errorSeg, (Node)info.target);
            }
        } else if (info.isXHTML) {
            if (!info.target.isEmptyTag() && "XML_TAG_OPEN".equals(info.target.getStartStructuredDocumentRegion().getFirstRegion().getType())) {
                if (SyntaxValidator.isEmptyContent(info.decl)) {
                    errorSeg = FMUtil.getSegment((IDOMNode)info.target, 2);
                    this.report(112, errorSeg, (Node)info.target);
                } else {
                    errorSeg = FMUtil.getSegment((IDOMNode)info.target, 2);
                    this.report(106, errorSeg, (Node)info.target);
                }
            }
        } else if (info.hasStartTag() && info.decl != null && CMUtil.isHTML(info.decl) && !info.target.isEmptyTag() && !CMUtil.isEndTagOmissible(info.decl) && "XML_TAG_OPEN".equals(info.startTag.getFirstRegion().getType())) {
            errorSeg = FMUtil.getSegment((IDOMNode)info.target, 2);
            this.report(106, errorSeg, (Node)info.target);
        }
    }

    private void validateNames(ElementInfo info) {
        boolean corrupted;
        boolean bl = corrupted = info.hasEndTag() && this.isEndTagCorrupted(info);
        if (info.decl == null) {
            if (!info.hasStartTag() && corrupted) {
                this.reportCorruptedEndTagError(info);
            } else {
                Segment errorSeg = FMUtil.getSegment((IDOMNode)info.target, 4);
                this.report(11, errorSeg, (Node)info.target);
            }
        } else if (corrupted) {
            this.reportCorruptedEndTagError(info);
        }
    }

    private void validateTagCase(ElementInfo info) {
        TagErrorInfoImpl error;
        String declared = info.decl.getElementName();
        String startTagName = "";
        String endTagName = "";
        if (declared == null) {
            return;
        }
        if (info.hasStartTag() && !declared.equals(startTagName = SyntaxValidator.getTagName(info.startTag))) {
            error = new TagErrorInfoImpl(103, info.startTag, startTagName);
            this.reporter.report((ErrorInfo)error);
        }
        if (info.hasEndTag()) {
            endTagName = SyntaxValidator.getTagName(info.endTag);
            if (!(info.hasStartTag() && endTagName.equals(startTagName) || declared.equals(endTagName))) {
                error = new TagErrorInfoImpl(103, info.endTag, endTagName);
                this.reporter.report((ErrorInfo)error);
            }
        }
    }

    private void validateChildren(Node target) {
        if (target.getNodeType() == 1 && CMUtil.isForeign((Element)target)) {
            return;
        }
        Node child = target.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 3: {
                    Segment errorSeg;
                    IDOMNode text = (IDOMNode)child;
                    int charOffset = this.validateTextSource(text);
                    if (charOffset < 0 || (errorSeg = new Segment(charOffset += text.getStartOffset(), 1)) == null) break;
                    this.report(102, errorSeg, (Node)text);
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 10: {
                    Segment errorSeg;
                    IDOMNode tag = (IDOMNode)child;
                    if (tag.isClosed() || (errorSeg = FMUtil.getSegment(tag, 1)) == null) break;
                    this.report(110, errorSeg, (Node)tag);
                    break;
                }
            }
            child = child.getNextSibling();
        }
    }

    private int validateTextSource(IDOMNode text) {
        try {
            SourceValidator validator = new SourceValidator((Node)text);
            validator.validateSource(text.getSource());
        }
        catch (InvalidCharacterException ex) {
            return ex.getOffset();
        }
        return -1;
    }

    private void report(int state, Segment errorSeg, Node node) {
        ErrorInfoImpl info = new ErrorInfoImpl(state, errorSeg, node);
        this.reporter.report((ErrorInfo)info);
    }

    class ElementInfo {
        public IDOMElement target = null;
        public CMElementDeclaration decl = null;
        public IStructuredDocumentRegion startTag = null;
        public IStructuredDocumentRegion endTag = null;
        public boolean isXHTML = false;

        public boolean hasStartTag() {
            return this.startTag != null;
        }

        public boolean hasEndTag() {
            return this.endTag != null;
        }
    }

    class TagErrorInfoImpl
    extends AbstractErrorInfo {
        private String hint = null;

        public TagErrorInfoImpl(int state, IStructuredDocumentRegion tag, String hint) {
            super(state, new Segment(tag));
            this.hint = hint;
        }

        public String getHint() {
            return this.hint;
        }

        public short getTargetType() {
            return 1;
        }
    }
}

