/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.Tracing;

public class TestValidator3
extends AbstractValidator {
    private static final String Name = "TestValidator3";
    static final String ID = "org.eclipse.wst.validation.tests.TestValidator3";

    public String getName() {
        return Name;
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        Tracing.log((String)("TestValidator3-04: validating: " + resource));
        this.checkState(state);
        if (resource.getName().equals("test.html")) {
            IResource depends;
            ValidationResult vr = new ValidationResult();
            ValidatorMessage vm = ValidatorMessage.create((String)"A specific test.html error", (IResource)resource);
            vm.setAttribute("lineNumber", 1);
            vm.setAttribute("severity", 2);
            vr.add(vm);
            IResource other = resource.getParent().findMember("test2.html");
            if (other != null) {
                vr.setValidated(new IResource[]{other});
            }
            if ((depends = resource.getParent().findMember("master.html")) != null) {
                vr.setDependsOn(new IResource[]{depends});
            }
            return vr;
        }
        ValidationResult vr = new ValidationResult();
        ValidatorMessage vm = ValidatorMessage.create((String)("A sample message from " + this.getName()), (IResource)resource);
        vm.setAttribute("lineNumber", 1);
        vm.setAttribute("severity", 2);
        vr.add(vm);
        vm = ValidatorMessage.create((String)("A different message from " + this.getName()), (IResource)resource);
        vm.setAttribute("lineNumber", 3);
        vm.setAttribute("severity", 1);
        vr.add(vm);
        return vr;
    }

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        String name = project == null ? "NULL" : project.getName();
        Tracing.log((Object[])new Object[]{"TestValidator3-05: thinks validation is starting for project: ", name});
        if (!this.checkState(state)) {
            state.put(ID, (Object)"my state");
        }
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        String name = project == null ? "NULL" : project.getName();
        Tracing.log((Object[])new Object[]{"TestValidator3-01: thinks validation is finishing for project: ", name});
        this.checkState(state);
    }

    public void clean(IProject project, ValidationState state, IProgressMonitor monitor) {
        String name = project == null ? "NULL" : project.getName();
        Tracing.log((Object[])new Object[]{"TestValidator3-02: thinks a clean has been requested for project: ", name});
        this.checkState(state);
    }

    private boolean checkState(ValidationState state) {
        if (state.get(ID) != null) {
            Tracing.log((String)"TestValidator3-03: has state information");
            return true;
        }
        return false;
    }
}

