/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import javax.jws.WebService;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class WebServiceTargetNamespaceRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof TypeDeclaration)) continue;
            AnnotationMirror webService = AnnotationUtils.getAnnotation((Declaration)declaration, WebService.class);
            AnnotationValue targetNamespace = AnnotationUtils.getAnnotationValue((AnnotationMirror)webService, (String)"targetNamespace");
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            PackageDeclaration packageDeclaration = typeDeclaration.getPackage();
            if (packageDeclaration.getQualifiedName().length() == 0 && targetNamespace == null) {
                this.printError(webService.getPosition(), JAXWSCoreMessages.WEBSERVICE_DEFAULT_PACKAGE_TARGET_NAMESPACE);
                continue;
            }
            if (targetNamespace == null || targetNamespace.getValue().toString().trim().length() != 0) continue;
            this.printError(targetNamespace.getPosition(), JAXWSCoreMessages.WEBSERVICE_DEFAULT_PACKAGE_TARGET_NAMESPACE);
        }
    }
}

