/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import javax.jws.soap.SOAPBinding;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class SOAPBindingRules
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration soapBindingDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(SOAPBinding.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(soapBindingDeclaration);
        for (Declaration declaration : annotatedTypes) {
            this.checkForEncodedUse(declaration);
            if (declaration instanceof TypeDeclaration) {
                this.checkForRPCBareOnTypeDeclaration((TypeDeclaration)declaration);
            }
            if (!(declaration instanceof MethodDeclaration)) continue;
            this.checkForRPCStyleOnMethodDeclaration((MethodDeclaration)declaration);
        }
    }

    private void checkForRPCBareOnTypeDeclaration(TypeDeclaration typeDeclaration) {
        AnnotationMirror soapBinding = AnnotationUtils.getAnnotation((Declaration)typeDeclaration, SOAPBinding.class);
        String style = AnnotationUtils.getStringValue((AnnotationMirror)soapBinding, (String)"style");
        if (style != null && style.equals(SOAPBinding.Style.RPC.toString())) {
            String parameterStyle = AnnotationUtils.getStringValue((AnnotationMirror)soapBinding, (String)"parameterStyle");
            if (parameterStyle != null && parameterStyle.equals(SOAPBinding.ParameterStyle.BARE.toString())) {
                this.printError(soapBinding.getPosition(), JAXWSCoreMessages.SOAPBINDING_RPC_NO_BARE_PARAMETER_STYLE);
            }
            Collection methodDeclarations = typeDeclaration.getMethods();
            for (MethodDeclaration methodDeclaration : methodDeclarations) {
                String style2;
                AnnotationMirror soapBinding2 = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, SOAPBinding.class);
                if (soapBinding2 == null || (style2 = AnnotationUtils.getStringValue((AnnotationMirror)soapBinding2, (String)"style")) != null && !style2.equals(SOAPBinding.Style.DOCUMENT.toString())) continue;
                this.printError(soapBinding2.getPosition(), JAXWSCoreMessages.SOAPBINDING_NO_MIXED_BINDINGS);
            }
        }
    }

    private void checkForEncodedUse(Declaration declaration) {
        AnnotationMirror soapBinding = AnnotationUtils.getAnnotation((Declaration)declaration, SOAPBinding.class);
        String use = AnnotationUtils.getStringValue((AnnotationMirror)soapBinding, (String)"use");
        if (use != null && use.equals(SOAPBinding.Use.ENCODED.toString())) {
            String style = AnnotationUtils.getStringValue((AnnotationMirror)soapBinding, (String)"style");
            if (style == null || style.equals(SOAPBinding.Style.DOCUMENT.toString())) {
                this.printError(soapBinding.getPosition(), JAXWSCoreMessages.SOAPBINDING_DOCUMENT_ENCODED_NOT_SUPPORTED);
            } else {
                this.printError(soapBinding.getPosition(), JAXWSCoreMessages.SOAPBINDING_RPC_ENCODED_NOT_SUPPORTED);
            }
        }
    }

    private void checkForRPCStyleOnMethodDeclaration(MethodDeclaration methodDeclaration) {
        AnnotationMirror soapBinding = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, SOAPBinding.class);
        String style = AnnotationUtils.getStringValue((AnnotationMirror)soapBinding, (String)"style");
        if (style != null && style.equals(SOAPBinding.Style.RPC.toString())) {
            this.printFixableError(soapBinding.getPosition(), JAXWSCoreMessages.SOAPBINDING_NO_RPC_STYLE_ON_METHODS);
        }
    }
}

