/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import javax.jws.Oneway;
import javax.xml.ws.Holder;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class OnewayRules
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(Oneway.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
            if (!methodDeclaration.getReturnType().equals((Object)this.environment.getTypeUtils().getVoidType())) {
                this.printError(annotationDeclaration, methodDeclaration, JAXWSCoreMessages.ONEWAY_NO_RETURN_VALUE);
            }
            if (methodDeclaration.getThrownTypes().size() > 0) {
                this.printError(annotationDeclaration, methodDeclaration, JAXWSCoreMessages.ONEWAY_NO_CHECKED_EXCEPTIONS);
            }
            this.checkParameters(methodDeclaration, annotationDeclaration);
        }
    }

    private void checkParameters(MethodDeclaration methodDeclaration, AnnotationTypeDeclaration annotationDeclaration) {
        Collection parameters = methodDeclaration.getParameters();
        for (ParameterDeclaration parameter : parameters) {
            TypeMirror typeMirror = this.environment.getTypeUtils().getErasure(parameter.getType());
            if (!typeMirror.toString().equals(Holder.class.getCanonicalName())) continue;
            this.printError(annotationDeclaration, methodDeclaration, JAXWSCoreMessages.ONEWAY_NO_HOLDER_PARAMETERS);
        }
    }
}

