/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import javax.jws.WebService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class RemoveAnnotationFromTypeTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "MyClass.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n\n");
        classContents.append("@WebService(name=\"MyClass\", endpointInterface=\"MyInterface\", ");
        classContents.append("targetNamespace=\"http://example.com/\", portName=\"MyClassPort\", ");
        classContents.append("serviceName=\"MyClassService\")\n");
        classContents.append("public class MyClass {\n\n");
        classContents.append("\tpublic String myMethod() {\n\t\treturn \"txt\";\n\t}\n\n}");
        return classContents.toString();
    }

    public Annotation getAnnotation() {
        return AnnotationsCore.createAnnotation((AST)this.ast, WebService.class, (String)WebService.class.getSimpleName(), null);
    }

    public void testRemoveAnnotationFromType() {
        try {
            RemoveAnnotationFromTypeTest.assertNotNull((Object)this.annotation);
            RemoveAnnotationFromTypeTest.assertEquals((String)WebService.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            RemoveAnnotationFromTypeTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            AnnotationUtils.removeAnnotationFromType((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IType)this.source.findPrimaryType(), (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            RemoveAnnotationFromTypeTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            RemoveAnnotationFromTypeTest.assertFalse((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
        }
        catch (CoreException ce) {
            RemoveAnnotationFromTypeTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

