/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import javax.jws.WebParam;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class RemoveAnnotationFromMethodParameterTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "Calculator.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebParam;\n\n");
        classContents.append("public class Calculator {\n\n\tpublic int add(@WebParam(name=\"i\")");
        classContents.append("int i, int k) {\n\t\treturn i + k;\n\t}\n}");
        return classContents.toString();
    }

    public Annotation getAnnotation() {
        return AnnotationsCore.createAnnotation((AST)this.ast, WebParam.class, (String)WebParam.class.getSimpleName(), null);
    }

    public void testRemoveAnnotationFromMethodParameter() {
        try {
            RemoveAnnotationFromMethodParameterTest.assertNotNull((Object)this.annotation);
            RemoveAnnotationFromMethodParameterTest.assertEquals((String)WebParam.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("add", new String[]{"I", "I"});
            RemoveAnnotationFromMethodParameterTest.assertNotNull((Object)method);
            SingleVariableDeclaration parameter = AnnotationUtils.getMethodParameter((CompilationUnit)this.compilationUnit, (IMethod)method, (int)93);
            RemoveAnnotationFromMethodParameterTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((SingleVariableDeclaration)parameter, (Annotation)this.annotation));
            AnnotationUtils.removeAnnotationFromMethodParameter((ICompilationUnit)this.source, (ASTRewrite)this.rewriter, (SingleVariableDeclaration)parameter, (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            RemoveAnnotationFromMethodParameterTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            parameter = AnnotationUtils.getMethodParameter((CompilationUnit)AnnotationUtils.getASTParser((ICompilationUnit)method.getCompilationUnit(), (boolean)false), (IMethod)method, (int)93);
            RemoveAnnotationFromMethodParameterTest.assertFalse((boolean)AnnotationUtils.isAnnotationPresent((SingleVariableDeclaration)parameter, (Annotation)this.annotation));
        }
        catch (CoreException ce) {
            RemoveAnnotationFromMethodParameterTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

