/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import java.util.ArrayList;
import javax.jws.WebService;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class WebServiceSEINoPortNameRuleTest
extends AbstractAnnotationValidationTest {
    protected Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"name", (Object)"MyClass");
        MemberValuePair targetNamespaceValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"targetNamespace", (Object)"http://example.com/");
        MemberValuePair portNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"portName", (Object)"MyClassPort");
        memberValuePairs.add(nameValuePair);
        memberValuePairs.add(targetNamespaceValuePair);
        memberValuePairs.add(portNameValuePair);
        return AnnotationsCore.createAnnotation((AST)this.ast, WebService.class, (String)WebService.class.getSimpleName(), memberValuePairs);
    }

    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("public interface MyInterface {\n\n\tpublic String myeMethod();\n\n}");
        return classContents.toString();
    }

    protected String getClassName() {
        return "MyInterface.java";
    }

    protected String getPackageName() {
        return "com.example";
    }

    public void testWebServiceSEINoPortNameRule() {
        try {
            WebServiceSEINoPortNameRuleTest.assertNotNull((Object)this.annotation);
            WebServiceSEINoPortNameRuleTest.assertEquals((String)WebService.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebService.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToType((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IType)this.source.findPrimaryType(), (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            WebServiceSEINoPortNameRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            WebServiceSEINoPortNameRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            WebServiceSEINoPortNameRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            WebServiceSEINoPortNameRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            WebServiceSEINoPortNameRuleTest.assertEquals((Object)JAXWSCoreMessages.WEBSERVICE_PORTNAME_SEI, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            WebServiceSEINoPortNameRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            WebServiceSEINoPortNameRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            WebServiceSEINoPortNameRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

