/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core.utils;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationUtils {
    private static final String FORMATTER_INSERT_SPACE_BEFORE_ASSIGNMENT_OPERATOR = "org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator";
    private static final String FORMATTER_INSERT_SPACE_AFTER_ASSIGNMENT_OPERATOR = "org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator";
    private static final String DO_NOT_INSERT = "do not insert";

    private AnnotationUtils() {
    }

    public static void addImportEdit(CompilationUnit compilationUnit, Class<? extends Annotation> annotation, TextFileChange textFileChange, boolean annotate) throws CoreException {
        String qualifiedName = annotation.getCanonicalName();
        ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)compilationUnit, (boolean)true);
        if (annotate) {
            importRewrite.addImport(qualifiedName);
        } else {
            final String annotationSimpleName = annotation.getSimpleName();
            final ArrayList occurences = new ArrayList();
            Target target = annotation.getAnnotation(Target.class);
            List<ElementType> elementTypes = Arrays.asList(target.value());
            for (ElementType elementType : elementTypes) {
                if (elementType == ElementType.TYPE) {
                    compilationUnit.accept(new ASTVisitor(){

                        public boolean visit(TypeDeclaration typeDeclaration) {
                            AnnotationUtils.countAnnotationOccurrences(typeDeclaration.modifiers(), annotationSimpleName, occurences);
                            return super.visit(typeDeclaration);
                        }
                    });
                }
                if (elementType == ElementType.FIELD) {
                    compilationUnit.accept(new ASTVisitor(){

                        public boolean visit(FieldDeclaration fieldDeclaration) {
                            AnnotationUtils.countAnnotationOccurrences(fieldDeclaration.modifiers(), annotationSimpleName, occurences);
                            return super.visit(fieldDeclaration);
                        }
                    });
                }
                if (elementType == ElementType.METHOD) {
                    compilationUnit.accept(new ASTVisitor(){

                        public boolean visit(org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration) {
                            AnnotationUtils.countAnnotationOccurrences(methodDeclaration.modifiers(), annotationSimpleName, occurences);
                            return super.visit(methodDeclaration);
                        }
                    });
                }
                if (elementType != ElementType.PARAMETER) continue;
                compilationUnit.accept(new ASTVisitor(){

                    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
                        AnnotationUtils.countAnnotationOccurrences(singleVariableDeclaration.modifiers(), annotationSimpleName, occurences);
                        return super.visit(singleVariableDeclaration);
                    }
                });
            }
            if (occurences.size() == 1) {
                importRewrite.removeImport(qualifiedName);
            }
        }
        if (importRewrite.hasRecordedChanges()) {
            TextEdit importTextEdit = importRewrite.rewriteImports(null);
            textFileChange.addEdit(importTextEdit);
        }
    }

    private static void countAnnotationOccurrences(List<IExtendedModifier> modifiers, String annotationSimpleName, List<String> occurences) {
        for (IExtendedModifier extendedModifier : modifiers) {
            org.eclipse.jdt.core.dom.Annotation existingAnnotation;
            if (!(extendedModifier instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.getAnnotationName(existingAnnotation = (org.eclipse.jdt.core.dom.Annotation)extendedModifier).equals(annotationSimpleName)) continue;
            occurences.add(annotationSimpleName);
        }
    }

    public static void addAnnotationToPackageDeclaration(ICompilationUnit source, PackageDeclaration packageDeclaration, ASTRewrite rewriter, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        try {
            if (packageDeclaration != null && !AnnotationUtils.isAnnotationPresent(packageDeclaration, annotation)) {
                bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)monitor);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)packageDeclaration, PackageDeclaration.ANNOTATIONS_PROPERTY);
                listRewrite.insertFirst((ASTNode)annotation, null);
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)monitor);
            }
        }
    }

    public static void removeAnnotationFromPackageDeclaration(ICompilationUnit source, PackageDeclaration packageDeclaration, ASTRewrite rewriter, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            if (packageDeclaration != null && AnnotationUtils.isAnnotationPresent(packageDeclaration, annotation)) {
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)packageDeclaration, PackageDeclaration.ANNOTATIONS_PROPERTY);
                List originalList = listRewrite.getOriginalList();
                for (Object object : originalList) {
                    if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                    listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
                }
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void addAnnotationToType(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, IType type, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            List types = compilationUnit.types();
            for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
                if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type) || AnnotationUtils.isAnnotationPresent((BodyDeclaration)abstractTypeDeclaration, annotation)) continue;
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)abstractTypeDeclaration, AnnotationUtils.getChildListPropertyDescriptorForType(abstractTypeDeclaration));
                listRewrite.insertFirst((ASTNode)annotation, null);
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void removeAnnotationFromType(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, IType type, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            List types = compilationUnit.types();
            for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
                if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type) || !AnnotationUtils.isAnnotationPresent((BodyDeclaration)abstractTypeDeclaration, annotation)) continue;
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)abstractTypeDeclaration, AnnotationUtils.getChildListPropertyDescriptorForType(abstractTypeDeclaration));
                List originalList = listRewrite.getOriginalList();
                for (Object object : originalList) {
                    if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                    listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
                }
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void addAnnotationToMethod(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, IMethod method, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            IType type = method.getDeclaringType();
            List types = compilationUnit.types();
            for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
                List<BodyDeclaration> bodyDeclarations;
                BodyDeclaration bodyDeclaration;
                if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type) || AnnotationUtils.isAnnotationPresent(bodyDeclaration = AnnotationUtils.getMethodDeclaration(bodyDeclarations = AnnotationUtils.getBodyDeclarationsForType(abstractTypeDeclaration), method), annotation)) continue;
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)bodyDeclaration, AnnotationUtils.getChildListPropertyDescriptorForMethod(bodyDeclaration));
                listRewrite.insertAt((ASTNode)annotation, 0, null);
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void removeAnnotationFromMethod(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, IMethod method, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            IType type = method.getDeclaringType();
            List types = compilationUnit.types();
            for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
                List<BodyDeclaration> bodyDeclarations;
                BodyDeclaration bodyDeclaration;
                if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type) || !AnnotationUtils.isAnnotationPresent(bodyDeclaration = AnnotationUtils.getMethodDeclaration(bodyDeclarations = AnnotationUtils.getBodyDeclarationsForType(abstractTypeDeclaration), method), annotation)) continue;
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)bodyDeclaration, AnnotationUtils.getChildListPropertyDescriptorForMethod(bodyDeclaration));
                List originalList = listRewrite.getOriginalList();
                for (Object object : originalList) {
                    if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                    listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
                }
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void addAnnotationToField(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, IField field, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            IType type = field.getDeclaringType();
            List types = compilationUnit.types();
            for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
                List<BodyDeclaration> bodyDeclarations;
                FieldDeclaration fieldDeclaration;
                if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type) || AnnotationUtils.isAnnotationPresent((BodyDeclaration)(fieldDeclaration = (FieldDeclaration)AnnotationUtils.getFieldDeclaration(bodyDeclarations = AnnotationUtils.getBodyDeclarationsForType(abstractTypeDeclaration), field)), annotation)) continue;
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)fieldDeclaration, FieldDeclaration.MODIFIERS2_PROPERTY);
                listRewrite.insertAt((ASTNode)annotation, 0, null);
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void removeAnnotationFromField(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, IField field, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            IType type = field.getDeclaringType();
            List types = compilationUnit.types();
            for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
                List<BodyDeclaration> bodyDeclarations;
                FieldDeclaration fieldDeclaration;
                if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type) || !AnnotationUtils.isAnnotationPresent((BodyDeclaration)(fieldDeclaration = (FieldDeclaration)AnnotationUtils.getFieldDeclaration(bodyDeclarations = AnnotationUtils.getBodyDeclarationsForType(abstractTypeDeclaration), field)), annotation)) continue;
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)fieldDeclaration, FieldDeclaration.MODIFIERS2_PROPERTY);
                List originalList = listRewrite.getOriginalList();
                for (Object object : originalList) {
                    if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                    listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
                }
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void addAnnotationToMethodParameter(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, SingleVariableDeclaration methodParameter, IMethod method, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            IType type = method.getDeclaringType();
            List types = compilationUnit.types();
            for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
                if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type)) continue;
                List<BodyDeclaration> bodyDeclarations = AnnotationUtils.getBodyDeclarationsForType(abstractTypeDeclaration);
                org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration = (org.eclipse.jdt.core.dom.MethodDeclaration)AnnotationUtils.getMethodDeclaration(bodyDeclarations, method);
                List parameters = methodDeclaration.parameters();
                for (SingleVariableDeclaration parameter : parameters) {
                    if (!AnnotationUtils.compareMethodParameters(parameter, methodParameter) || AnnotationUtils.isAnnotationPresent(parameter, annotation)) continue;
                    bufferManager.connect(path, LocationKind.IFILE, null);
                    connected = true;
                    IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                    ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)parameter, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
                    listRewrite.insertAt((ASTNode)annotation, -1, null);
                    TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                    textFileChange.addEdit(annotationTextEdit);
                    textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
                }
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void addAnnotationToMethodParameter(ICompilationUnit source, ASTRewrite rewriter, SingleVariableDeclaration methodParameter, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            if (!AnnotationUtils.isAnnotationPresent(methodParameter, annotation)) {
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)methodParameter, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
                listRewrite.insertAt((ASTNode)annotation, -1, null);
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void removeAnnotationFromMethodParameter(ICompilationUnit source, ASTRewrite rewriter, SingleVariableDeclaration methodParameter, org.eclipse.jdt.core.dom.Annotation annotation, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            if (AnnotationUtils.isAnnotationPresent(methodParameter, annotation)) {
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)methodParameter, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
                List originalList = listRewrite.getOriginalList();
                for (Object object : originalList) {
                    if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                    listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
                }
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void addMemberValuePairToAnnotation(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, IJavaElement javaElement, IAnnotation annotation, ASTNode memberValuePair, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            List<IExtendedModifier> modifiers = AnnotationUtils.getExtendedModifiers(compilationUnit, javaElement);
            for (IExtendedModifier extendedModifier : modifiers) {
                NormalAnnotation existingAnnotation;
                if (!(extendedModifier instanceof NormalAnnotation) || !AnnotationUtils.compareAnnotationNames(annotation, (org.eclipse.jdt.core.dom.Annotation)(existingAnnotation = (NormalAnnotation)extendedModifier))) continue;
                bufferManager.connect(path, LocationKind.IFILE, null);
                connected = true;
                IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)existingAnnotation, NormalAnnotation.VALUES_PROPERTY);
                listRewrite.insertLast(memberValuePair, null);
                TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                textFileChange.addEdit(annotationTextEdit);
                textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void addMemberValuePairToAnnotation(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, NormalAnnotation annotation, ASTNode memberValuePair, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            bufferManager.connect(path, LocationKind.IFILE, null);
            connected = true;
            IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
            listRewrite.insertLast(memberValuePair, null);
            TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
            textFileChange.addEdit(annotationTextEdit);
            textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void updateMemberValuePairValue(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, IJavaElement javaElement, IAnnotation annotation, IMemberValuePair memberValuePair, ASTNode value, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            List<IExtendedModifier> modifiers = AnnotationUtils.getExtendedModifiers(compilationUnit, javaElement);
            for (IExtendedModifier extendedModifier : modifiers) {
                NormalAnnotation existingAnnotation;
                if (!(extendedModifier instanceof NormalAnnotation) || !AnnotationUtils.compareAnnotationNames(annotation, (org.eclipse.jdt.core.dom.Annotation)(existingAnnotation = (NormalAnnotation)extendedModifier))) continue;
                List memberValuePairs = existingAnnotation.values();
                for (MemberValuePair memberValuePairDOM : memberValuePairs) {
                    if (!memberValuePairDOM.getName().toString().equals(memberValuePair.getMemberName())) continue;
                    bufferManager.connect(path, LocationKind.IFILE, null);
                    connected = true;
                    IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                    rewriter.set((ASTNode)memberValuePairDOM, (StructuralPropertyDescriptor)MemberValuePair.VALUE_PROPERTY, (Object)value, null);
                    TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
                    textFileChange.addEdit(annotationTextEdit);
                    textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
                }
            }
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    public static void updateMemberValuePairValue(ICompilationUnit source, CompilationUnit compilationUnit, ASTRewrite rewriter, NormalAnnotation annotation, MemberValuePair memberValuePair, ASTNode value, TextFileChange textFileChange) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = source.getResource().getFullPath();
        boolean connected = false;
        try {
            bufferManager.connect(path, LocationKind.IFILE, null);
            connected = true;
            IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
            rewriter.set((ASTNode)memberValuePair, (StructuralPropertyDescriptor)MemberValuePair.VALUE_PROPERTY, (Object)value, null);
            TextEdit annotationTextEdit = rewriter.rewriteAST(document, AnnotationUtils.getOptions(source));
            textFileChange.addEdit(annotationTextEdit);
            textFileChange.addTextEditGroup(new TextEditGroup("AA", new TextEdit[]{annotationTextEdit}));
        }
        finally {
            if (connected) {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
    }

    private static Map getOptions(ICompilationUnit source) {
        Map options = source.getJavaProject().getOptions(true);
        options.put(FORMATTER_INSERT_SPACE_BEFORE_ASSIGNMENT_OPERATOR, DO_NOT_INSERT);
        options.put(FORMATTER_INSERT_SPACE_AFTER_ASSIGNMENT_OPERATOR, DO_NOT_INSERT);
        return options;
    }

    private static ChildListPropertyDescriptor getChildListPropertyDescriptorForType(AbstractTypeDeclaration abstractTypeDeclaration) {
        ChildListPropertyDescriptor childListPropertyDescriptor = null;
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            childListPropertyDescriptor = TypeDeclaration.MODIFIERS2_PROPERTY;
        }
        if (abstractTypeDeclaration instanceof EnumDeclaration) {
            childListPropertyDescriptor = EnumDeclaration.MODIFIERS2_PROPERTY;
        }
        if (abstractTypeDeclaration instanceof org.eclipse.jdt.core.dom.AnnotationTypeDeclaration) {
            childListPropertyDescriptor = org.eclipse.jdt.core.dom.AnnotationTypeDeclaration.MODIFIERS2_PROPERTY;
        }
        return childListPropertyDescriptor;
    }

    private static ChildListPropertyDescriptor getChildListPropertyDescriptorForMethod(BodyDeclaration bodyDeclaration) {
        if (bodyDeclaration instanceof org.eclipse.jdt.core.dom.MethodDeclaration) {
            return org.eclipse.jdt.core.dom.MethodDeclaration.MODIFIERS2_PROPERTY;
        }
        if (bodyDeclaration instanceof AnnotationTypeMemberDeclaration) {
            return AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY;
        }
        return null;
    }

    public static CompilationUnit getASTParser(ICompilationUnit source, boolean resolveBindings) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        parser.setResolveBindings(resolveBindings);
        parser.setBindingsRecovery(resolveBindings);
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        compilationUnit.recordModifications();
        return compilationUnit;
    }

    public static TextFileChange createTextFileChange(String textFileChangeName, IFile file) {
        TextFileChange textFileChange = new TextFileChange(textFileChangeName, file);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        textFileChange.setEdit((TextEdit)multiTextEdit);
        return textFileChange;
    }

    public static List<SingleVariableDeclaration> getMethodParameters(IType type, final IMethod method) {
        ICompilationUnit source = type.getCompilationUnit();
        CompilationUnit compilationUnit = AnnotationUtils.getASTParser(source, false);
        final ArrayList<SingleVariableDeclaration> parameters = new ArrayList<SingleVariableDeclaration>();
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration) {
                if (AnnotationUtils.compareMethods(methodDeclaration, method)) {
                    parameters.addAll(methodDeclaration.parameters());
                }
                return super.visit(methodDeclaration);
            }
        });
        return parameters;
    }

    public static String getAnnotationName(org.eclipse.jdt.core.dom.Annotation annotation) {
        Name annotationTypeName = annotation.getTypeName();
        return annotationTypeName.getFullyQualifiedName();
    }

    public static boolean compareTypeNames(AbstractTypeDeclaration abstractTypeDeclaration, IType type) {
        return abstractTypeDeclaration.getName().getIdentifier().equals(type.getElementName());
    }

    public static boolean compareMethods(org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration, IMethod method) {
        List methodDeclarationParameters;
        String[] parametetTypes;
        if (methodDeclaration.getName().getIdentifier().equals(method.getElementName()) && (parametetTypes = method.getParameterTypes()).length == (methodDeclarationParameters = methodDeclaration.parameters()).size()) {
            int i = 0;
            while (i < parametetTypes.length) {
                String simpleName2;
                String simpleName1 = Signature.toString((String)parametetTypes[i]);
                if (!simpleName1.equals(simpleName2 = ((SingleVariableDeclaration)methodDeclarationParameters.get(i)).getType().toString())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean compareMethods(org.eclipse.jdt.core.dom.MethodDeclaration methodOne, org.eclipse.jdt.core.dom.MethodDeclaration methodTwo) {
        if (methodOne.getName().getIdentifier().equals(methodTwo.getName().getIdentifier())) {
            List methodParametersOne = methodOne.parameters();
            List methodParametersTwo = methodTwo.parameters();
            if (methodParametersOne.size() == methodParametersTwo.size()) {
                int i = 0;
                while (i < methodParametersOne.size()) {
                    String simpleName2;
                    String simpleName1 = ((SingleVariableDeclaration)methodParametersOne.get(i)).getType().toString();
                    if (!simpleName1.equals(simpleName2 = ((SingleVariableDeclaration)methodParametersTwo.get(i)).getType().toString())) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean compareMethods(MethodDeclaration methodOne, MethodDeclaration methodTwo) {
        return AnnotationUtils.compareMethodNames(methodOne, methodTwo) && AnnotationUtils.compareMethodParameterTypes(methodOne, methodTwo);
    }

    private static boolean compareMethodNames(MethodDeclaration methodOne, MethodDeclaration methodTwo) {
        return methodOne.getSimpleName().equals(methodTwo.getSimpleName());
    }

    private static boolean compareMethodParameterTypes(MethodDeclaration methodOne, MethodDeclaration methodTwo) {
        int numberOfParametersTwo;
        int numberOfParametersOne = methodOne.getParameters().size();
        if (numberOfParametersOne == (numberOfParametersTwo = methodTwo.getParameters().size())) {
            List parametersOne = (List)methodOne.getParameters();
            List parametersTwo = (List)methodTwo.getParameters();
            int i = 0;
            while (i < parametersOne.size()) {
                if (!((ParameterDeclaration)parametersOne.get(i)).getType().equals((Object)((ParameterDeclaration)parametersTwo.get(i)).getType())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean compareMethodNames(AnnotationTypeMemberDeclaration memmberDeclaration, IMethod method) {
        return memmberDeclaration.getName().getIdentifier().equals(method.getElementName());
    }

    public static boolean compareFieldNames(FieldDeclaration fieldDeclaration, IField field) {
        List fragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment variableDeclarationFragment : fragments) {
            if (!variableDeclarationFragment.getName().getIdentifier().equals(field.getElementName())) continue;
            return true;
        }
        return false;
    }

    public static String accountForOverloadedMethods(IType type, IMethod method) throws JavaModelException {
        List<IMethod> methods = Arrays.asList(type.getMethods());
        ArrayList<IMethod> similarMethods = new ArrayList<IMethod>();
        for (IMethod methodToTest : methods) {
            if (method.equals(methodToTest) || !method.getElementName().equalsIgnoreCase(methodToTest.getElementName()) || methodToTest.getSourceRange().getOffset() >= method.getSourceRange().getOffset()) continue;
            similarMethods.add(methodToTest);
        }
        return similarMethods.size() > 0 ? Integer.toString(similarMethods.size()) : "";
    }

    private static boolean compareAnnotationNames(org.eclipse.jdt.core.dom.Annotation newAnnotation, org.eclipse.jdt.core.dom.Annotation existingAnnotation) {
        return AnnotationUtils.getAnnotationName(existingAnnotation).equals(AnnotationUtils.getAnnotationName(newAnnotation));
    }

    private static boolean compareAnnotationNames(IAnnotation newAnnotation, org.eclipse.jdt.core.dom.Annotation existingAnnotation) {
        return AnnotationUtils.getAnnotationName(existingAnnotation).equals(newAnnotation.getElementName());
    }

    public static boolean isAnnotationPresent(SingleVariableDeclaration parameter, String annotationName) {
        List modifiers = parameter.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            org.eclipse.jdt.core.dom.Annotation existingAnnotation;
            if (!(extendedModifier instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.getAnnotationName(existingAnnotation = (org.eclipse.jdt.core.dom.Annotation)extendedModifier).equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(SingleVariableDeclaration parameter, org.eclipse.jdt.core.dom.Annotation annatotationToAdd) {
        boolean exists = false;
        List modifiers = parameter.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            org.eclipse.jdt.core.dom.Annotation existingAnnotation;
            if (!(extendedModifier instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames(annatotationToAdd, existingAnnotation = (org.eclipse.jdt.core.dom.Annotation)extendedModifier)) continue;
            return true;
        }
        return exists;
    }

    public static boolean isAnnotationPresent(IJavaElement javaElement, String annotationName) {
        if (javaElement.getElementType() == 5) {
            return AnnotationUtils.isAnnotationPresent((IJavaElement)((ICompilationUnit)javaElement).findPrimaryType(), annotationName);
        }
        ICompilationUnit source = ((IMember)javaElement).getCompilationUnit();
        int elementType = javaElement.getElementType();
        CompilationUnit compilationUnit = AnnotationUtils.getASTParser(source, false);
        if (elementType == 11) {
            return AnnotationUtils.isAnnotationPresent(compilationUnit.getPackage(), annotationName);
        }
        if (elementType == 7 || elementType == 9 || elementType == 8) {
            return AnnotationUtils.isAnnotationPresent(compilationUnit, javaElement, annotationName);
        }
        return false;
    }

    public static boolean isAnnotationPresent(PackageDeclaration packageDeclaration, String annotationName) {
        List annotations = packageDeclaration.annotations();
        for (org.eclipse.jdt.core.dom.Annotation existingAnnotation : annotations) {
            if (!AnnotationUtils.getAnnotationName(existingAnnotation).equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(PackageDeclaration packageDeclaration, org.eclipse.jdt.core.dom.Annotation annotation) {
        List annotations = packageDeclaration.annotations();
        for (org.eclipse.jdt.core.dom.Annotation existingAnnotation : annotations) {
            if (!AnnotationUtils.compareAnnotationNames(annotation, existingAnnotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(BodyDeclaration bodyDeclaration, org.eclipse.jdt.core.dom.Annotation annatotationToAdd) {
        boolean exists = false;
        List modifiers = bodyDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            org.eclipse.jdt.core.dom.Annotation existingAnnotation;
            if (!(extendedModifier instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames(annatotationToAdd, existingAnnotation = (org.eclipse.jdt.core.dom.Annotation)extendedModifier)) continue;
            return true;
        }
        return exists;
    }

    private static boolean isAnnotationPresent(CompilationUnit compilationUnit, IJavaElement javaElement, String annotationName) {
        List<IExtendedModifier> modifiers = AnnotationUtils.getExtendedModifiers(compilationUnit, javaElement);
        for (IExtendedModifier extendedModifier : modifiers) {
            org.eclipse.jdt.core.dom.Annotation existingAnnotation;
            if (!extendedModifier.isAnnotation() || !AnnotationUtils.getAnnotationName(existingAnnotation = (org.eclipse.jdt.core.dom.Annotation)extendedModifier).equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static List<IExtendedModifier> getExtendedModifiers(CompilationUnit compilationUnit, IJavaElement javaElement) {
        IType type = compilationUnit.getTypeRoot().findPrimaryType();
        List types = compilationUnit.types();
        for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
            if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type)) continue;
            List<BodyDeclaration> bodyDeclarations = AnnotationUtils.getBodyDeclarationsForType(abstractTypeDeclaration);
            AbstractTypeDeclaration bodyDeclaration = null;
            if (javaElement.getElementType() == 7) {
                bodyDeclaration = abstractTypeDeclaration;
            }
            if (javaElement.getElementType() == 9) {
                bodyDeclaration = AnnotationUtils.getMethodDeclaration(bodyDeclarations, (IMethod)javaElement);
            }
            if (javaElement.getElementType() == 8) {
                bodyDeclaration = AnnotationUtils.getFieldDeclaration(bodyDeclarations, (IField)javaElement);
            }
            return bodyDeclaration != null ? bodyDeclaration.modifiers() : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public static List<BodyDeclaration> getBodyDeclarationsForType(AbstractTypeDeclaration abstractTypeDeclaration) {
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)abstractTypeDeclaration;
            return typeDeclaration.bodyDeclarations();
        }
        if (abstractTypeDeclaration instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)abstractTypeDeclaration;
            return enumDeclaration.bodyDeclarations();
        }
        if (abstractTypeDeclaration instanceof org.eclipse.jdt.core.dom.AnnotationTypeDeclaration) {
            org.eclipse.jdt.core.dom.AnnotationTypeDeclaration annotationTypeDeclaration = (org.eclipse.jdt.core.dom.AnnotationTypeDeclaration)abstractTypeDeclaration;
            return annotationTypeDeclaration.bodyDeclarations();
        }
        return Collections.emptyList();
    }

    private static BodyDeclaration getMethodDeclaration(List<BodyDeclaration> bodyDeclarations, IMethod method) {
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration instanceof org.eclipse.jdt.core.dom.MethodDeclaration && AnnotationUtils.compareMethods((org.eclipse.jdt.core.dom.MethodDeclaration)bodyDeclaration, method)) {
                return bodyDeclaration;
            }
            if (!(bodyDeclaration instanceof AnnotationTypeMemberDeclaration) || !AnnotationUtils.compareMethodNames((AnnotationTypeMemberDeclaration)bodyDeclaration, method)) continue;
            return bodyDeclaration;
        }
        return null;
    }

    private static BodyDeclaration getFieldDeclaration(List<BodyDeclaration> bodyDeclarations, IField field) {
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (!(bodyDeclaration instanceof FieldDeclaration) || !AnnotationUtils.compareFieldNames((FieldDeclaration)bodyDeclaration, field)) continue;
            return bodyDeclaration;
        }
        return null;
    }

    public static SingleVariableDeclaration getMethodParameter(CompilationUnit compilationUnit, IMethod method, int offset) {
        if (compilationUnit == null) {
            compilationUnit = AnnotationUtils.getASTParser(method.getCompilationUnit(), false);
        }
        IType type = method.getDeclaringType();
        List types = compilationUnit.types();
        for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
            if (!abstractTypeDeclaration.getName().getIdentifier().equals(type.getElementName())) continue;
            String methodToAnnotateName = method.getElementName();
            List<BodyDeclaration> bodyDeclarations = AnnotationUtils.getBodyDeclarationsForType(abstractTypeDeclaration);
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration;
                if (!(bodyDeclaration instanceof org.eclipse.jdt.core.dom.MethodDeclaration) || !(methodDeclaration = (org.eclipse.jdt.core.dom.MethodDeclaration)bodyDeclaration).getName().getIdentifier().equals(methodToAnnotateName)) continue;
                List parameters = methodDeclaration.parameters();
                for (SingleVariableDeclaration parameter : parameters) {
                    int parameterStartPosition = parameter.getStartPosition();
                    int parameterLength = parameter.getLength();
                    if (offset < parameterStartPosition || offset > parameterStartPosition + parameterLength) continue;
                    return parameter;
                }
            }
        }
        return null;
    }

    private static boolean compareMethodParameters(SingleVariableDeclaration paramOne, SingleVariableDeclaration paramTwo) {
        String typeOne = paramOne.getType().toString();
        String nameOne = paramOne.getName().getIdentifier();
        String typeTwo = paramTwo.getType().toString();
        String nameTwo = paramTwo.getName().getIdentifier();
        return typeOne.equals(typeTwo) && nameOne.equals(nameTwo);
    }

    public static String getStringValue(AnnotationMirror mirror, String attributeName) {
        AnnotationValue annotationValue = AnnotationUtils.getAnnotationValue(mirror, attributeName);
        if (annotationValue != null) {
            return annotationValue.getValue().toString();
        }
        return null;
    }

    public static Boolean getBooleanValue(AnnotationMirror mirror, String attributeName) {
        String value = AnnotationUtils.getStringValue(mirror, attributeName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror mirror, String attributeName) {
        Map values = mirror.getElementValues();
        Set entrySet = values.entrySet();
        for (Map.Entry entry : entrySet) {
            AnnotationTypeElementDeclaration element = (AnnotationTypeElementDeclaration)entry.getKey();
            if (!element.getSimpleName().equals(attributeName)) continue;
            return (AnnotationValue)entry.getValue();
        }
        return null;
    }

    public static AnnotationMirror getAnnotation(Declaration declaration, Class<? extends Annotation> annotation) {
        Collection aannotationMirrors = declaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : aannotationMirrors) {
            AnnotationTypeDeclaration annotationTypeDeclaration = annotationMirror.getAnnotationType().getDeclaration();
            if (annotationTypeDeclaration == null || !annotationTypeDeclaration.getQualifiedName().equals(annotation.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static String getStringValue(org.eclipse.jdt.core.dom.Annotation annotation, String attributeName) {
        Expression expression;
        if (annotation instanceof NormalAnnotation && (expression = AnnotationUtils.getAnnotationValue((NormalAnnotation)annotation, attributeName)) != null && expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        return null;
    }

    public static String getEnumValue(org.eclipse.jdt.core.dom.Annotation annotation, String attributeName) {
        Expression expression;
        if (annotation instanceof NormalAnnotation && (expression = AnnotationUtils.getAnnotationValue((NormalAnnotation)annotation, attributeName)) != null && expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName().getIdentifier();
        }
        return null;
    }

    public static Boolean getBooleanValue(org.eclipse.jdt.core.dom.Annotation annotation, String attributeName) {
        Expression expression;
        if (annotation instanceof NormalAnnotation && (expression = AnnotationUtils.getAnnotationValue((NormalAnnotation)annotation, attributeName)) != null && expression instanceof BooleanLiteral) {
            return ((BooleanLiteral)expression).booleanValue();
        }
        return null;
    }

    public static Expression getAnnotationValue(NormalAnnotation normalAnnotation, String attributeName) {
        List memberValuePairs = normalAnnotation.values();
        for (MemberValuePair memberValuePair : memberValuePairs) {
            if (!memberValuePair.getName().getIdentifier().equals(attributeName)) continue;
            return memberValuePair.getValue();
        }
        return null;
    }

    public static org.eclipse.jdt.core.dom.Annotation getAnnotation(BodyDeclaration bodyDeclaration, Class<? extends Annotation> annotation) {
        return AnnotationUtils.getAnnotation(bodyDeclaration.modifiers(), annotation);
    }

    public static org.eclipse.jdt.core.dom.Annotation getAnnotation(SingleVariableDeclaration parameter, Class<? extends Annotation> annotation) {
        return AnnotationUtils.getAnnotation(parameter.modifiers(), annotation);
    }

    private static org.eclipse.jdt.core.dom.Annotation getAnnotation(List<IExtendedModifier> modifiers, Class<? extends Annotation> annotation) {
        if (modifiers != null) {
            for (IExtendedModifier extendedModifier : modifiers) {
                org.eclipse.jdt.core.dom.Annotation astAnnotation;
                String typeName;
                if (!(extendedModifier instanceof org.eclipse.jdt.core.dom.Annotation) || !(typeName = (astAnnotation = (org.eclipse.jdt.core.dom.Annotation)extendedModifier).getTypeName().getFullyQualifiedName()).equals(annotation.getCanonicalName()) && !typeName.equals(annotation.getSimpleName())) continue;
                return astAnnotation;
            }
        }
        return null;
    }

    public static String getStringValue(IAnnotation annotation, String attributeName) throws JavaModelException {
        Object value = AnnotationUtils.getAnnotationValue(annotation, attributeName);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getEnumValue(IAnnotation annotation, String attributeName) throws JavaModelException {
        String value = AnnotationUtils.getStringValue(annotation, attributeName);
        if (value != null && value.indexOf(".") != -1) {
            return value.substring(value.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static Boolean getBooleanValue(IAnnotation annotation, String attributeName) throws JavaModelException {
        String value = AnnotationUtils.getStringValue(annotation, attributeName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static Object getAnnotationValue(IAnnotation annotation, String attributeName) throws JavaModelException {
        IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
        if (memberValuePairs.length > 0) {
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs;
            int n = memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                if (memberValuePair.getMemberName().equals(attributeName)) {
                    return memberValuePair.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public static IAnnotation getAnnotation(IAnnotatable annotatable, Class<? extends Annotation> annotation) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = annotatable.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation jdtAnnotation = iAnnotationArray[n2];
            String annotationName = jdtAnnotation.getElementName();
            if (annotationName.equals(annotation.getCanonicalName()) || annotationName.equals(annotation.getSimpleName())) {
                return jdtAnnotation;
            }
            ++n2;
        }
        return null;
    }
}

