/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jst.ws.annotations.core.AnnotationDefinition;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationsManager {
    public static final String ANNOTATION_DEFINITION = "annotationDefinition";
    public static final String ANNOTATION_CATEGORY = "annotationCategory";
    public static final String ANNOTATION_INITIALIZER = "annotationInitializer";
    public static final String ANNOTATION_PROCESSOR = "annotationProcessor";
    public static final String ANNOTATION = "annotation";
    private static List<AnnotationDefinition> annotationCache = null;
    private static Map<String, String> annotationCategoryCache = null;
    private static Map<String, IConfigurationElement> annotationInitializerCache = null;
    private static Map<String, List<IConfigurationElement>> annotationProcessorCache = null;
    private static Map<String, List<AnnotationDefinition>> annotationsByCategoryMap = null;
    private static Map<String, AnnotationDefinition> annotationClassNameToDefinitionMap;
    private static Map<String, AnnotationDefinition> annotationSimpleNameToDefinitionMap;
    private static Map<String, AnnotationDefinition> annotationQualifiedNameToDefinitionMap;
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CATEGORY = "category";
    private static final String ELEM_TARGET_FILTER = "targetFilter";
    private static final String ATT_TARGET = "target";

    private AnnotationsManager() {
    }

    public static synchronized List<AnnotationDefinition> getAnnotations() {
        if (annotationCache == null) {
            annotationCache = new ArrayList<AnnotationDefinition>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.annotations.core", ANNOTATION_DEFINITION);
            if (extensionPoint != null) {
                IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement element = elements[i];
                    if (element.getName().equals(ANNOTATION)) {
                        AnnotationDefinition annotationDefinition = new AnnotationDefinition(element, AnnotationsManager.getAnnotationCategory(AnnotationsManager.getAttributeValue(element, ATT_CATEGORY)));
                        annotationCache.add(annotationDefinition);
                    }
                    ++i;
                }
            }
        }
        return annotationCache;
    }

    public static Object[] getAnnotations(Object element) {
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
        try {
            List<AnnotationDefinition> annotationDefinitions = AnnotationsManager.getAllAnnotationsForElement(element);
            AnnotationsManager.filterAnnotationsList(element, annotationDefinitions);
            for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
                annotations.add(annotationDefinition.getAnnotationClass());
            }
        }
        catch (JavaModelException jme) {
            AnnotationsCorePlugin.log(jme.getStatus());
        }
        return annotations.toArray();
    }

    private static synchronized Map<String, AnnotationDefinition> getAnnotationToClassNameDefinitionMap() {
        if (annotationClassNameToDefinitionMap == null) {
            List<AnnotationDefinition> annotationDefinitions = AnnotationsManager.getAnnotations();
            annotationClassNameToDefinitionMap = new HashMap<String, AnnotationDefinition>();
            for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
                annotationClassNameToDefinitionMap.put(annotationDefinition.getAnnotationClass().getCanonicalName(), annotationDefinition);
            }
        }
        return annotationClassNameToDefinitionMap;
    }

    private static synchronized Map<String, AnnotationDefinition> getSimpleNameToDefinitionMap() {
        if (annotationSimpleNameToDefinitionMap == null) {
            List<AnnotationDefinition> annotationDefinitions = AnnotationsManager.getAnnotations();
            annotationSimpleNameToDefinitionMap = new HashMap<String, AnnotationDefinition>();
            for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
                annotationSimpleNameToDefinitionMap.put(annotationDefinition.getName(), annotationDefinition);
            }
        }
        return annotationSimpleNameToDefinitionMap;
    }

    private static synchronized Map<String, AnnotationDefinition> getQualifiedNameToDefinitionMap() {
        if (annotationQualifiedNameToDefinitionMap == null) {
            List<AnnotationDefinition> annotationDefinitions = AnnotationsManager.getAnnotations();
            annotationQualifiedNameToDefinitionMap = new HashMap<String, AnnotationDefinition>();
            for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
                annotationQualifiedNameToDefinitionMap.put(annotationDefinition.getAnnotationClassName(), annotationDefinition);
            }
        }
        return annotationQualifiedNameToDefinitionMap;
    }

    public static AnnotationDefinition getAnnotationDefinitionForClass(Object element) {
        if (element instanceof Class && ((Class)element).isAnnotation()) {
            return AnnotationsManager.getAnnotationToClassNameDefinitionMap().get(((Class)element).getCanonicalName());
        }
        return null;
    }

    public static IAnnotationAttributeInitializer getAnnotationAttributeInitializerForName(Name name) {
        if (name != null) {
            if (name.isSimpleName()) {
                return AnnotationsManager.getSimpleNameToDefinitionMap().get(((SimpleName)name).getIdentifier()).getAnnotationAttributeInitializer();
            }
            if (name.isQualifiedName()) {
                return AnnotationsManager.getQualifiedNameToDefinitionMap().get(name.getFullyQualifiedName()).getAnnotationAttributeInitializer();
            }
        }
        return null;
    }

    public static AnnotationDefinition getAnnotationDefinitionForClass(Class<? extends Annotation> annotationClass) {
        return AnnotationsManager.getAnnotationToClassNameDefinitionMap().get(annotationClass.getCanonicalName());
    }

    public static synchronized List<AnnotationDefinition> getAnnotationsByCategory(String categoryName) {
        if (annotationsByCategoryMap == null) {
            annotationsByCategoryMap = new HashMap<String, List<AnnotationDefinition>>();
            for (AnnotationDefinition annotationDefinition : AnnotationsManager.getAnnotations()) {
                List<AnnotationDefinition> annotationDefinitionList = annotationsByCategoryMap.get(annotationDefinition.getCategory());
                if (annotationDefinitionList == null) {
                    annotationDefinitionList = new ArrayList<AnnotationDefinition>();
                    annotationDefinitionList.add(annotationDefinition);
                    annotationsByCategoryMap.put(annotationDefinition.getCategory(), annotationDefinitionList);
                    continue;
                }
                annotationDefinitionList.add(annotationDefinition);
            }
        }
        return annotationsByCategoryMap.get(categoryName);
    }

    public static List<String> getAnnotationCategories() {
        return Arrays.asList(AnnotationsManager.getAnnotationCategoryCache().values().toArray(new String[AnnotationsManager.getAnnotationCategoryCache().size()]));
    }

    public static String getAnnotationCategory(String categoryId) {
        return AnnotationsManager.getAnnotationCategoryCache().get(categoryId);
    }

    private static synchronized Map<String, String> getAnnotationCategoryCache() {
        if (annotationCategoryCache != null) {
            return annotationCategoryCache;
        }
        annotationCategoryCache = new HashMap<String, String>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.annotations.core", ANNOTATION_CATEGORY);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                annotationCategoryCache.put(AnnotationsManager.getAttributeValue(element, ATT_ID), AnnotationsManager.getAttributeValue(element, ATT_NAME));
                ++i;
            }
        }
        return annotationCategoryCache;
    }

    public static synchronized Map<String, IConfigurationElement> getAnnotationInitializerCache() {
        if (annotationInitializerCache != null) {
            return annotationInitializerCache;
        }
        annotationInitializerCache = new HashMap<String, IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.annotations.core", ANNOTATION_INITIALIZER);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                annotationInitializerCache.put(AnnotationsManager.getAttributeValue(element, ANNOTATION), element);
                ++i;
            }
        }
        return annotationInitializerCache;
    }

    public static synchronized Map<String, List<IConfigurationElement>> getAnnotationProcessorsCache() {
        if (annotationProcessorCache == null) {
            annotationProcessorCache = new HashMap<String, List<IConfigurationElement>>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.ws.annotations.core", ANNOTATION_PROCESSOR);
            if (extensionPoint != null) {
                IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement element = elements[i];
                    if (element.getName().equalsIgnoreCase("processor")) {
                        String annotationKey = AnnotationsManager.getAttributeValue(element, ANNOTATION);
                        List<IConfigurationElement> configurationElements = annotationProcessorCache.get(annotationKey);
                        if (configurationElements == null) {
                            configurationElements = new ArrayList<IConfigurationElement>();
                            configurationElements.add(element);
                            annotationProcessorCache.put(annotationKey, configurationElements);
                        } else {
                            configurationElements.add(element);
                        }
                    }
                    ++i;
                }
            }
        }
        return annotationProcessorCache;
    }

    public static String getAttributeValue(IConfigurationElement configurationElement, String attributeName) {
        String attribute = configurationElement.getAttribute(attributeName);
        if (attribute != null) {
            return attribute;
        }
        return "";
    }

    public static List<ElementType> getFilteredTargets(IConfigurationElement configurationElement) {
        ArrayList<ElementType> targets = new ArrayList<ElementType>(7);
        try {
            IConfigurationElement[] deprecatedTargets;
            IConfigurationElement[] iConfigurationElementArray = deprecatedTargets = configurationElement.getChildren(ELEM_TARGET_FILTER);
            int n = deprecatedTargets.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement deprecatedTargetElement = iConfigurationElementArray[n2];
                String target = AnnotationsManager.getAttributeValue(deprecatedTargetElement, ATT_TARGET);
                targets.add(ElementType.valueOf(target));
                ++n2;
            }
        }
        catch (IllegalArgumentException iae) {
            AnnotationsCorePlugin.log(iae);
        }
        return targets;
    }

    private static List<AnnotationDefinition> getAllAnnotationsForElement(Object element) throws JavaModelException {
        if (element instanceof IPackageDeclaration) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.PACKAGE);
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            if (type.isAnnotation()) {
                return AnnotationsManager.getAnnotationsForElementType(ElementType.ANNOTATION_TYPE);
            }
            return AnnotationsManager.getAnnotationsForElementType(ElementType.TYPE);
        }
        if (element instanceof IField) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.FIELD);
        }
        if (element instanceof IMethod) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.METHOD);
        }
        if (element instanceof SingleVariableDeclaration) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.PARAMETER);
        }
        if (element instanceof ILocalVariable) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.LOCAL_VARIABLE);
        }
        if (element instanceof IAnnotation) {
            return AnnotationsManager.getAnnotationsForElementType(ElementType.ANNOTATION_TYPE);
        }
        return Collections.emptyList();
    }

    private static List<AnnotationDefinition> getAnnotationsForElementType(ElementType elementType) {
        ArrayList<AnnotationDefinition> annotationDefinitions = new ArrayList<AnnotationDefinition>();
        if (annotationCache == null) {
            AnnotationsManager.getAnnotations();
        }
        for (AnnotationDefinition annotationDefinition : annotationCache) {
            if (!annotationDefinition.getTargets().contains((Object)elementType) || AnnotationsManager.isDeprecated(annotationDefinition)) continue;
            annotationDefinitions.add(annotationDefinition);
        }
        return annotationDefinitions;
    }

    private static void filterAnnotationsList(Object element, List<AnnotationDefinition> annotationDefinitions) throws JavaModelException {
        Iterator<AnnotationDefinition> annotationIter = annotationDefinitions.iterator();
        while (annotationIter.hasNext()) {
            IType type;
            AnnotationDefinition annotationDefinition = annotationIter.next();
            if (element instanceof IType && (AnnotationsManager.isClassRestricted((IJavaElement)(type = (IType)element), annotationDefinition) || AnnotationsManager.isInterfaceRestricted((IJavaElement)type, annotationDefinition) || AnnotationsManager.isEnumRestricted((IJavaElement)type, annotationDefinition))) {
                annotationIter.remove();
            }
            if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                if (method.isMainMethod()) {
                    annotationIter.remove();
                }
                if (method.isConstructor() && !annotationDefinition.getTargets().contains((Object)ElementType.CONSTRUCTOR)) {
                    annotationIter.remove();
                }
                if (AnnotationsManager.isClassRestricted((IJavaElement)method, annotationDefinition) || AnnotationsManager.isInterfaceRestricted((IJavaElement)method, annotationDefinition) || AnnotationsManager.isEnumRestricted((IJavaElement)method, annotationDefinition)) {
                    annotationIter.remove();
                }
            }
            if (!(element instanceof IField) || !AnnotationsManager.isClassRestricted((IJavaElement)((IField)element), annotationDefinition) && !AnnotationsManager.isInterfaceRestricted((IJavaElement)((IField)element), annotationDefinition) && !AnnotationsManager.isEnumRestricted((IJavaElement)((IField)element), annotationDefinition)) continue;
            annotationIter.remove();
        }
    }

    private static boolean isClassRestricted(IJavaElement javaElement, AnnotationDefinition annotationDefinition) throws JavaModelException {
        if (javaElement.getElementType() == 7) {
            return !((IType)javaElement).isClass() && annotationDefinition.isClassOnly();
        }
        if (javaElement.getElementType() == 9) {
            IType type = (IType)javaElement.getParent();
            return !type.isClass() && annotationDefinition.isClassOnly();
        }
        if (javaElement.getElementType() == 8) {
            IType type = (IType)javaElement.getParent();
            return !type.isClass() && annotationDefinition.isClassOnly();
        }
        return false;
    }

    private static boolean isInterfaceRestricted(IJavaElement javaElement, AnnotationDefinition annotationDefinition) throws JavaModelException {
        if (javaElement.getElementType() == 7) {
            return !((IType)javaElement).isInterface() && annotationDefinition.isInterfaceOnly();
        }
        if (javaElement.getElementType() == 9) {
            IType type = (IType)javaElement.getParent();
            return !type.isInterface() && annotationDefinition.isInterfaceOnly();
        }
        if (javaElement.getElementType() == 8) {
            IType type = (IType)javaElement.getParent();
            return !type.isInterface() && annotationDefinition.isInterfaceOnly();
        }
        return false;
    }

    private static boolean isEnumRestricted(IJavaElement javaElement, AnnotationDefinition annotationDefinition) throws JavaModelException {
        if (javaElement.getElementType() == 7) {
            return !((IType)javaElement).isEnum() && annotationDefinition.isEnumOnly();
        }
        if (javaElement.getElementType() == 9) {
            IType type = (IType)javaElement.getParent();
            return !type.isEnum() && annotationDefinition.isEnumOnly();
        }
        if (javaElement.getElementType() == 8) {
            IType type = (IType)javaElement.getParent();
            return !type.isEnum() && annotationDefinition.isEnumOnly();
        }
        return false;
    }

    private static boolean isDeprecated(AnnotationDefinition annotationDefinition) {
        Class<? extends Annotation> annotationClass = annotationDefinition.getAnnotationClass();
        return annotationClass.getAnnotation(Deprecated.class) != null;
    }
}

