/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationsCore {
    private AnnotationsCore() {
    }

    public static org.eclipse.jdt.core.dom.Annotation createAnnotation(AST ast, Class<? extends Annotation> annotationClass, String annotationName, List<MemberValuePair> memberValuePairs) {
        NormalAnnotation annotation = ast.newNormalAnnotation();
        Name annotationTypeName = ast.newName(annotationName);
        annotation.setTypeName(annotationTypeName);
        if (memberValuePairs != null) {
            for (MemberValuePair memberValuePair : memberValuePairs) {
                List annotationValues = annotation.values();
                annotationValues.add(memberValuePair);
            }
        }
        return annotation;
    }

    public static MemberValuePair createMemberValuePair(AST ast, String name, Expression expression) {
        MemberValuePair memberValuePair = ast.newMemberValuePair();
        memberValuePair.setName(ast.newSimpleName(name));
        memberValuePair.setValue(expression);
        return memberValuePair;
    }

    public static MemberValuePair createStringMemberValuePair(AST ast, String name, Object value) {
        MemberValuePair stringMemberValuePair = AnnotationsCore.createMemberValuePair(ast, name, (Expression)AnnotationsCore.createStringLiteral(ast, value.toString()));
        return stringMemberValuePair;
    }

    public static MemberValuePair createBooleanMemberValuePair(AST ast, String name, Object value) {
        MemberValuePair booleanValuePair = AnnotationsCore.createMemberValuePair(ast, name, (Expression)AnnotationsCore.createBooleanLiteral(ast, (Boolean)value));
        return booleanValuePair;
    }

    public static MemberValuePair createNumberMemberValuePair(AST ast, String name, Object value) {
        MemberValuePair primitiveValuePair = AnnotationsCore.createMemberValuePair(ast, name, (Expression)AnnotationsCore.createNumberLiteral(ast, value.toString()));
        return primitiveValuePair;
    }

    public static MemberValuePair createEnumMemberValuePair(AST ast, String className, String name, Object value) {
        return AnnotationsCore.createMemberValuePair(ast, name, (Expression)AnnotationsCore.createEnumLiteral(ast, className, value));
    }

    public static MemberValuePair createTypeMemberValuePair(AST ast, String name, Object value) {
        return AnnotationsCore.createMemberValuePair(ast, name, (Expression)AnnotationsCore.createTypeLiteral(ast, value));
    }

    public static MemberValuePair createArrayMemberValuePair(AST ast, Method method, Object[] values) {
        return AnnotationsCore.createMemberValuePair(ast, method.getName(), (Expression)AnnotationsCore.createArrayValueLiteral(ast, method, values));
    }

    public static ArrayInitializer createArrayValueLiteral(AST ast, Method method, Object[] values) {
        ArrayInitializer arrayInitializer = ast.newArrayInitializer();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            boolean cfr_ignored_0 = value instanceof Annotation;
            if (value instanceof List) {
                Class<?> annotationClass = method.getReturnType().getComponentType();
                ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
                List valuesList = (List)value;
                for (Map annotationMap : valuesList) {
                    Set entrySet = annotationMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        String memberName = (String)entry.getKey();
                        try {
                            Method annotationMethod = annotationClass.getMethod(memberName, new Class[0]);
                            if (annotationMethod == null) continue;
                            Object memberValue = entry.getValue();
                            Class<?> returnType = annotationMethod.getReturnType();
                            if (returnType.equals(String.class)) {
                                memberValuePairs.add(AnnotationsCore.createStringMemberValuePair(ast, memberName, memberValue));
                            }
                            if (returnType.equals(Boolean.TYPE)) {
                                memberValuePairs.add(AnnotationsCore.createBooleanMemberValuePair(ast, memberName, memberValue));
                            }
                            if (!returnType.equals(Class.class)) continue;
                            String className = memberValue.toString();
                            if (className.endsWith(".class")) {
                                className = className.substring(0, className.lastIndexOf("."));
                            }
                            memberValuePairs.add(AnnotationsCore.createMemberValuePair(ast, memberName, (Expression)AnnotationsCore.createTypeLiteral(ast, className)));
                        }
                        catch (SecurityException se) {
                            AnnotationsCorePlugin.log(se);
                        }
                        catch (NoSuchMethodException nsme) {
                            AnnotationsCorePlugin.log(nsme);
                        }
                    }
                }
                arrayInitializer.expressions().add(AnnotationsCore.createAnnotation(ast, annotationClass, annotationClass.getCanonicalName(), memberValuePairs));
            }
            if (value.equals(Class.class)) {
                arrayInitializer.expressions().add(AnnotationsCore.createTypeLiteral(ast, value.toString()));
            }
            if (value instanceof String) {
                String stringValue = value.toString();
                if (stringValue.endsWith(".class")) {
                    arrayInitializer.expressions().add(AnnotationsCore.createTypeLiteral(ast, stringValue.substring(0, stringValue.lastIndexOf("."))));
                } else {
                    arrayInitializer.expressions().add(AnnotationsCore.createStringLiteral(ast, stringValue));
                }
            }
            ++n2;
        }
        return arrayInitializer;
    }

    public static Name createEnumLiteral(AST ast, String className, Object value) {
        QualifiedName enumName = null;
        SimpleName enumClassName = ast.newSimpleName(value.getClass().getSimpleName());
        SimpleName enumLiteral = ast.newSimpleName(value.toString());
        if (value.getClass().isMemberClass()) {
            Object enumEnclosingClassName = null;
            String enclosingClassName = value.getClass().getEnclosingClass().getCanonicalName();
            enumEnclosingClassName = enclosingClassName.equals(className) ? ast.newSimpleName(value.getClass().getEnclosingClass().getSimpleName()) : ast.newName(enclosingClassName);
            QualifiedName qualifiedName = ast.newQualifiedName(enumEnclosingClassName, enumClassName);
            enumName = ast.newQualifiedName((Name)qualifiedName, enumLiteral);
        } else {
            Name qualifiedName = ast.newName(value.getClass().getCanonicalName());
            enumName = ast.newQualifiedName(qualifiedName, enumLiteral);
        }
        return enumName;
    }

    public static TypeLiteral createTypeLiteral(AST ast, Object value) {
        TypeLiteral typeLiteral = null;
        if (value instanceof Class) {
            typeLiteral = AnnotationsCore.createTypeLiteral(ast, (Class)value);
        }
        if (value instanceof String) {
            typeLiteral = AnnotationsCore.createTypeLiteral(ast, (String)value);
        }
        return typeLiteral;
    }

    public static TypeLiteral createTypeLiteral(AST ast, Class<?> value) {
        TypeLiteral typeLiteral = ast.newTypeLiteral();
        Class<?> aClass = value;
        SimpleName className = ast.newSimpleName(aClass.getSimpleName());
        if (aClass.isMemberClass()) {
            Name enclosingClassName = ast.newName(aClass.getEnclosingClass().getCanonicalName());
            QualifiedType qualifiedType = ast.newQualifiedType((Type)ast.newSimpleType(enclosingClassName), className);
            typeLiteral.setType((Type)qualifiedType);
            return typeLiteral;
        }
        return AnnotationsCore.createTypeLiteral(ast, value.getCanonicalName());
    }

    public static TypeLiteral createTypeLiteral(AST ast, String value) {
        TypeLiteral typeLiteral = ast.newTypeLiteral();
        if (value.indexOf(".") == -1) {
            typeLiteral.setType((Type)ast.newSimpleType((Name)ast.newSimpleName(value)));
        } else {
            String qualifier = value.substring(0, value.lastIndexOf("."));
            String identifier = value.substring(value.lastIndexOf(".") + 1);
            if (qualifier.equals("java.lang")) {
                typeLiteral.setType((Type)ast.newSimpleType((Name)ast.newSimpleName(identifier)));
            } else {
                typeLiteral.setType((Type)ast.newQualifiedType((Type)ast.newSimpleType(ast.newName(qualifier)), ast.newSimpleName(identifier)));
            }
        }
        return typeLiteral;
    }

    public static StringLiteral createStringLiteral(AST ast, String literalValue) {
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(literalValue);
        return stringLiteral;
    }

    public static BooleanLiteral createBooleanLiteral(AST ast, boolean value) {
        BooleanLiteral booleanLiteral = ast.newBooleanLiteral(value);
        return booleanLiteral;
    }

    public static NumberLiteral createNumberLiteral(AST ast, String value) {
        NumberLiteral primitiveLiteral = ast.newNumberLiteral();
        primitiveLiteral.setToken(value);
        return primitiveLiteral;
    }
}

