/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.AbstractBatchEditCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;

public class DeleteNodeCommand
extends AbstractBatchEditCommand {
    private PageflowNode child;
    private Pageflow parent;
    private int index = -1;
    private List sourceConnections = new ArrayList();
    private List sourceConnectionSources = new ArrayList();
    private List sourceConnectionTargets = new ArrayList();
    private List targetConnections = new ArrayList();
    private List targetConnectionSources = new ArrayList();
    private List targetConnectionTargets = new ArrayList();

    public DeleteNodeCommand(Pageflow pageflow) {
        super(pageflow, PageflowMessages.Pageflow_Commands_DeleteNodeCommand_Label);
    }

    public void doExecute() {
        this.primExecute();
    }

    public void doRedo() {
        this.primExecute();
    }

    public void doUndo() {
        this.parent.getNodes().add(this.index, (Object)this.child);
        this.restoreConnections(this.child);
    }

    private void deleteConnections(PageflowNode node) {
        PageflowLink link;
        while (node.getOutlinks().size() > 0) {
            link = (PageflowLink)node.getOutlinks().get(0);
            this.sourceConnections.add(link);
            this.sourceConnectionSources.add(link.getSource());
            this.sourceConnectionTargets.add(link.getTarget());
            link.getTarget().getInlinks().remove((Object)link);
            node.getOutlinks().remove((Object)link);
            this.parent.getLinks().remove((Object)link);
        }
        while (node.getInlinks().size() > 0) {
            link = (PageflowLink)node.getInlinks().get(0);
            this.targetConnections.add(link);
            this.targetConnectionSources.add(link.getSource());
            this.targetConnectionTargets.add(link.getTarget());
            link.getSource().getOutlinks().remove((Object)link);
            node.getInlinks().remove((Object)link);
            this.parent.getLinks().remove((Object)link);
        }
    }

    protected void primExecute() {
        this.deleteConnections(this.child);
        this.index = this.parent.getNodes().indexOf((Object)this.child);
        this.parent.getNodes().remove((Object)this.child);
    }

    private void restoreConnections(PageflowNode node) {
        PageflowNode target;
        PageflowNode source;
        PageflowLink link;
        int i = 0;
        while (i < this.sourceConnections.size()) {
            link = (PageflowLink)this.sourceConnections.get(i);
            source = (PageflowNode)this.sourceConnectionSources.get(i);
            target = (PageflowNode)this.sourceConnectionTargets.get(i);
            link.setSource(source);
            link.setTarget(target);
            this.parent.getLinks().add((Object)link);
            node.getOutlinks().add((Object)link);
            link.getTarget().getInlinks().add((Object)link);
            ++i;
        }
        this.sourceConnections.clear();
        i = 0;
        while (i < this.targetConnections.size()) {
            link = (PageflowLink)this.targetConnections.get(i);
            source = (PageflowNode)this.targetConnectionSources.get(i);
            target = (PageflowNode)this.targetConnectionTargets.get(i);
            link.setSource(source);
            link.setTarget(target);
            this.parent.getLinks().add((Object)link);
            node.getInlinks().add((Object)link);
            link.getSource().getOutlinks().add((Object)link);
            ++i;
        }
        this.targetConnections.clear();
    }

    public void setChild(PageflowNode c) {
        this.child = c;
    }

    public void setParent(Pageflow p) {
        this.parent = p;
    }
}

