/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import org.eclipse.jst.jsf.facesconfig.emf.DynamicElement;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class FacesConfigExtensionTestCase
extends BaseWriteTestCase {
    private static final String FACES_CONFIG = "faces-config";
    private static final String FACES_CONFIG_EXTENSION = CommonStructuresUtil.createPreficedString("faces-config", "extension");
    private static final String FACES_CONFIG_EXTENSION_ID = CommonStructuresUtil.createPreficedString(FACES_CONFIG_EXTENSION, "id");
    private static final String FACES_CONFIG_EXTENSION_TAG = CommonStructuresUtil.createPreficedString(FACES_CONFIG_EXTENSION, "tag");

    public FacesConfigExtensionTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        FacesConfigExtensionTestCase.assertEquals((String)"1.2", (String)this._facesVersion);
    }

    public void testFacesConfigExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            FacesConfigExtensionTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            FacesConfigType facesConfigType = edit.getFacesConfig();
            FacesConfigExtensionType extensionType = facesConfigFactory.createFacesConfigExtensionType();
            extensionType.setId(FACES_CONFIG_EXTENSION_ID);
            extensionType.getChildNodes().add((Object)this.createDynamicElement(FACES_CONFIG_EXTENSION_TAG));
            facesConfigType.getFacesConfigExtension().add((Object)extensionType);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                FacesConfigExtensionTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            FacesConfigExtensionTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigType facesConfig = edit.getFacesConfig();
            FacesConfigExtensionTestCase.assertEquals((int)1, (int)facesConfig.getFacesConfigExtension().size());
            FacesConfigExtensionType extensionType = (FacesConfigExtensionType)facesConfig.getFacesConfigExtension().get(0);
            FacesConfigExtensionTestCase.assertEquals((String)FACES_CONFIG_EXTENSION_ID, (String)extensionType.getId());
            FacesConfigExtensionTestCase.assertEquals((int)1, (int)extensionType.getChildNodes().size());
            DynamicElement element = (DynamicElement)extensionType.getChildNodes().get(0);
            FacesConfigExtensionTestCase.assertEquals((String)FACES_CONFIG_EXTENSION_TAG, (String)element.getName());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

