/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.CMNodeNamedMapAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.IAttributeAdvisor;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagElement;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class TestSerializableTLDTagElement
extends TestCase {
    private WebProjectTestEnvironment _webProject;
    private TLDElementDeclaration _sampleTldElementDeclaration;

    protected void setUp() throws Exception {
        super.setUp();
        ZipFile zipFile = JSFTestUtil.createZipFile((Bundle)TestsPlugin.getDefault().getBundle(), (String)"/testfiles/testzips/TLDTests.zip");
        this._webProject = new WebProjectTestEnvironment((TestCase)this, JavaFacetUtils.JAVA_50, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.4"));
        this._webProject.createFromZip(zipFile, true);
        TestSerializableTLDTagElement.assertNotNull((Object)this._webProject);
        this._sampleTldElementDeclaration = TestSerializableTLDTagElement.findElementDeclaration(this._webProject.getTestProject(), "uri-supplied", "useBean");
        TestSerializableTLDTagElement.assertNotNull((Object)this._sampleTldElementDeclaration);
    }

    public void testSerialization() throws Exception {
        TLDTagElement tldTagElement = new TLDTagElement(this._sampleTldElementDeclaration, (IAttributeAdvisor)new IAttributeAdvisor.NullAttributeAdvisor());
        this.verifyUseBean(tldTagElement);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(out);
        outStream.writeObject(tldTagElement);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInputStream inStream = new ObjectInputStream(in);
        Object readObject = inStream.readObject();
        TestSerializableTLDTagElement.assertNotNull((Object)readObject);
        TestSerializableTLDTagElement.assertTrue((boolean)(readObject instanceof TLDTagElement));
        this.verifyUseBean((TLDTagElement)readObject);
        TestSerializableTLDTagElement.assertFalse((boolean)(((TLDTagElement)readObject).getAttributeHandlers() instanceof CMNodeNamedMapAdapter));
    }

    private void verifyUseBean(TLDTagElement tldTagElement) {
        TestSerializableTLDTagElement.assertEquals((String)"useBean", (String)tldTagElement.getName());
        TestSerializableTLDTagElement.assertEquals((String)"uri-supplied", (String)tldTagElement.getUri());
        TestSerializableTLDTagElement.assertEquals((String)"sample.http.taglib.UseBeanTag", (String)tldTagElement.getTagHandlerClassName());
        Map attributeHandlers = tldTagElement.getAttributeHandlers();
        TestSerializableTLDTagElement.assertTrue((boolean)attributeHandlers.containsKey("id"));
        TestSerializableTLDTagElement.assertTrue((boolean)attributeHandlers.containsKey("cls"));
        TestSerializableTLDTagElement.assertTrue((boolean)attributeHandlers.containsKey("type"));
        TestSerializableTLDTagElement.assertTrue((boolean)attributeHandlers.containsKey("request"));
        TestSerializableTLDTagElement.assertTrue((boolean)attributeHandlers.containsKey("scope"));
        TestSerializableTLDTagElement.assertEquals((int)5, (int)attributeHandlers.size());
    }

    private static TLDElementDeclaration findElementDeclaration(IProject project, String shortName, String name) {
        ITaglibRecord tagRecord = TestSerializableTLDTagElement.findTagRecord(project, shortName);
        TestSerializableTLDTagElement.assertNotNull((Object)tagRecord);
        CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
        TLDDocument doc = (TLDDocument)factory.createCMDocument(tagRecord);
        TestSerializableTLDTagElement.assertNotNull((Object)doc);
        return (TLDElementDeclaration)doc.getElements().getNamedItem(name);
    }

    private static ITaglibRecord findTagRecord(IProject project, String shortName) {
        ITaglibRecord[] iTaglibRecordArray = TaglibIndex.getAvailableTaglibRecords((IPath)project.getFullPath());
        int n = iTaglibRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITaglibRecord record = iTaglibRecordArray[n2];
            if (shortName.equals(record.getDescriptor().getShortName())) {
                return record;
            }
            ++n2;
        }
        return null;
    }
}

