/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.ear;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.BundledNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.ModulesNode;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class GroupEARProvider
extends AbstractGroupProvider
implements IAdaptable {
    private static final String PROJECT_RELATIVE_PATH = "META-INF/application.xml";
    public static final String EAR_DEFAULT_LIB = "lib";
    private static Image EAR_IMAGE;
    private EARVirtualComponent earComponent;
    private IFile ddFile;
    private BundledNode bundledLibsNode;
    private ModulesNode modulesNode;

    public GroupEARProvider(Application application, EARVirtualComponent wtpComponent) {
        super((JavaEEObject)application);
        this.earComponent = wtpComponent;
    }

    public IProject getProject() {
        return this.earComponent.getProject();
    }

    public String getText() {
        return NLS.bind((String)Messages.DEPLOYMENT_DESCRIPTOR, (Object)this.earComponent.getName());
    }

    public EARVirtualComponent getEARVirtualComponent() {
        return this.earComponent;
    }

    public List getChildren() {
        ArrayList<AbstractEarNode> children = new ArrayList<AbstractEarNode>();
        IProject project = this.getProject();
        ComponentCore.createComponent((IProject)project);
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null && facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ear").getVersion("5.0"))) {
                if (this.bundledLibsNode == null) {
                    BundledNode bundledLibsDirectoryNode = new BundledNode(project, String.valueOf(Messages.LIBRARY_DIRECTORY) + ": /" + EAR_DEFAULT_LIB, null);
                    this.bundledLibsNode = new BundledNode(project, Messages.BUNDLED_LIBRARIES_NODE, bundledLibsDirectoryNode);
                }
                if (this.modulesNode == null) {
                    this.modulesNode = new ModulesNode(project);
                }
                children.add(this.modulesNode);
                children.add(this.bundledLibsNode);
            }
        }
        catch (CoreException e) {
            String msg = "Error in the JEEContentProvider.getChildren() for parent:" + this;
            JEEUIPlugin.getDefault();
            JEEUIPlugin.logError(msg, (Exception)((Object)e));
        }
        return children;
    }

    public Image getImage() {
        return GroupEARProvider.getEarImage();
    }

    public static Image getEarImage() {
        if (EAR_IMAGE == null) {
            ImageDescriptor imageDescriptor = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.EAR_IMAGE);
            EAR_IMAGE = imageDescriptor.createImage();
        }
        return EAR_IMAGE;
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public IFile getDDFile() {
        if (this.ddFile != null) {
            return this.ddFile;
        }
        IVirtualFolder virtualFolder = ComponentCore.createComponent((IProject)this.getProject()).getRootFolder();
        this.ddFile = virtualFolder.getFile(PROJECT_RELATIVE_PATH).getUnderlyingFile();
        return this.ddFile;
    }

    public Object getAdapter(Class adapter) {
        if (IProject.class == adapter) {
            return this.getProject();
        }
        return null;
    }
}

