/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.common.internal.util.CommonUtil;
import org.eclipse.jst.j2ee.internal.actions.J2EERenameResourceAction;
import org.eclipse.jst.j2ee.internal.dialogs.J2EERenameUIConstants;
import org.eclipse.jst.j2ee.internal.dialogs.RenameModuleDialog;
import org.eclipse.jst.j2ee.internal.plugin.CommonEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.rename.RenameOptions;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;

@Deprecated
public class J2EERenameAction
extends SelectionDispatchAction
implements J2EERenameUIConstants {
    protected Shell shell;
    protected Set referencedProjects;
    protected List modules;
    protected RenameOptions options;
    protected ISelectionProvider provider = null;

    public J2EERenameAction(IWorkbenchSite site, Shell parent) {
        super(site);
        this.setText(RENAME);
        this.shell = parent;
    }

    public J2EERenameAction(IWorkbenchSite site, ISelectionProvider newProvider) {
        super(site);
        this.setText(RENAME);
        this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.provider = newProvider;
    }

    protected void reset() {
        this.referencedProjects = null;
        this.modules = null;
        this.options = null;
    }

    protected void updateSelection(IStructuredSelection selection) {
        super.update((ISelection)selection);
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setEnabledFromSelection((IStructuredSelection)selection);
        } else {
            super.selectionChanged(selection);
        }
    }

    protected void setEnabledFromSelection(IStructuredSelection selection) {
        if (selection == null) {
            this.setEnabled(false);
        } else if (selection.toList().size() != 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.getEnableStateBasedOnSelection(selection));
        }
    }

    protected boolean getEnableStateBasedOnSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        return this.isSelectionAllDDRoots() || this.isSelectionAllApplications();
    }

    protected boolean isSelectionAllDDRoots() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        for (Object o : sel) {
            if (CommonUtil.isDeploymentDescriptorRoot(o, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSelectionAllApplications() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        for (Object o : sel) {
            if (o instanceof Application || this.isJ2EEApplicationProject(o)) continue;
            return false;
        }
        return true;
    }

    protected List getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList();
            StructuredSelection sel = (StructuredSelection)this.getSelection();
            Iterator iterator = sel.iterator();
            WorkbenchComponent module = null;
            Object o = null;
            while (iterator.hasNext()) {
                o = iterator.next();
                if (o instanceof WorkbenchComponent) {
                    this.modules.add(o);
                    continue;
                }
                if (o instanceof EObject) {
                    EObject obj = (EObject)o;
                    IProject project = ProjectUtilities.getProject((EObject)obj);
                    StructureEdit moduleCore = null;
                    try {
                        try {
                            moduleCore = StructureEdit.getStructureEditForRead((IProject)project);
                            URI uri = obj.eResource().getURI();
                            ComponentResource[] resources = moduleCore.findResourcesBySourcePath(uri);
                            int i = 0;
                            while (i < resources.length) {
                                module = resources[i].getComponent();
                                if (module != null) break;
                                ++i;
                            }
                            if (module == null) {
                                throw new RuntimeException(J2EEUIMessages.getResourceString("Project_should_not_be_null_1_ERROR_"));
                            }
                            this.modules.add(module);
                        }
                        catch (UnresolveableURIException unresolveableURIException) {
                            if (moduleCore == null) continue;
                            moduleCore.dispose();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (moduleCore != null) {
                            moduleCore.dispose();
                        }
                        throw throwable;
                    }
                    if (moduleCore == null) continue;
                    moduleCore.dispose();
                    continue;
                }
                throw new RuntimeException(J2EEUIMessages.getResourceString("Non-project_in_selection_2_ERROR_"));
            }
        }
        return this.modules;
    }

    public void run() {
        try {
            List localModules = this.getModules();
            if (localModules.size() != 1) {
                return;
            }
            WorkbenchComponent module = (WorkbenchComponent)localModules.get(0);
            RenameModuleDialog dlg = null;
            if (this.isSelectionAllApplications()) {
                RenameResourceAction action = new RenameResourceAction(this.shell);
                action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)module));
                action.run();
            } else {
                String contextRoot = "";
                dlg = new RenameModuleDialog(this.shell, module.getName(), contextRoot);
                dlg.open();
                if (dlg.getReturnCode() == 1) {
                    return;
                }
                this.options = dlg.getRenameOptions();
                if (this.options != null) {
                    this.options.setSelectedProjects(localModules);
                }
                if (!this.ensureEditorsSaved() || !this.validateState()) {
                    return;
                }
                this.renameProjectsIfNecessary();
                this.renameMetadataIfNecessary();
                this.presentStatusIfNeccessary();
            }
        }
        finally {
            this.reset();
        }
    }

    private boolean ensureEditorsSaved() {
        return CommonEditorUtility.promptToSaveAllDirtyEditors();
    }

    protected Set getReferencedProjects() {
        if (this.referencedProjects == null) {
            this.computeReferencedProjects();
        }
        return this.referencedProjects;
    }

    protected void computeReferencedProjects() {
        this.getModules();
        this.referencedProjects = new HashSet();
        int i = 0;
        while (i < this.modules.size()) {
            ++i;
        }
    }

    protected void renameMetadataIfNecessary() {
        if (!this.shouldRenameMetaData()) {
            return;
        }
    }

    protected boolean shouldRenameMetaData() {
        if (this.renameProjectsFailedOrCancelled()) {
            return false;
        }
        return this.primShouldRenameMetaData();
    }

    protected boolean renameProjectsFailedOrCancelled() {
        if (this.options == null || !this.options.shouldRenameProjects()) {
            return false;
        }
        return this.renamedProjectsExist();
    }

    protected boolean renamedProjectsExist() {
        List renamedProjects = this.options.getAllProjectsToRename();
        int i = 0;
        while (i < renamedProjects.size()) {
            IProject project = (IProject)renamedProjects.get(i);
            if (project.exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void renameProjectsIfNecessary() {
        if (this.options == null || !this.options.shouldRenameProjects()) {
            return;
        }
        J2EERenameResourceAction action = new J2EERenameResourceAction(this.shell);
        action.setNewName(this.options.getNewName());
        StructuredSelection sel = new StructuredSelection(this.options.getAllProjectsToRename());
        action.selectionChanged((IStructuredSelection)sel);
        action.run();
        String newContextRoot = this.options.getNewContextRoot();
        if (newContextRoot == null || this.options.shouldRenameProjects()) {
            // empty if block
        }
    }

    public void handleException(InvocationTargetException e) {
        Logger.getLogger().logError((Throwable)e);
        IStatus status = J2EEPlugin.newErrorStatus((int)4, (String)RENAME_ERROR, (Throwable)e);
        ErrorDialog.openError((Shell)this.shell, (String)RENAME_ERROR, (String)RENAME_NOT_COMPLETED, (IStatus)status);
    }

    public void update() {
        IStructuredSelection selection = null;
        if (this.provider != null) {
            selection = (IStructuredSelection)this.provider.getSelection();
            super.update((ISelection)selection);
        } else {
            selection = (IStructuredSelection)this.getSelection();
            if (selection == null) {
                this.setEnabled(false);
            } else {
                this.updateSelection(selection);
            }
        }
    }

    protected boolean isJ2EEApplicationProject(Object o) {
        IProject project;
        return o instanceof IProject && J2EEProjectUtilities.isEARProject((IProject)(project = (IProject)o));
    }

    protected boolean validateState() {
        return !this.primShouldRenameMetaData();
    }

    protected boolean primShouldRenameMetaData() {
        return this.options != null && (this.options.shouldRenameModules() || this.options.shouldRenameModuleDependencies());
    }

    protected void presentStatusIfNeccessary() {
        IStatus status = null;
        if (status == null || status.isOK()) {
            return;
        }
        ErrorDialog.openError((Shell)this.shell, null, null, status, (int)4);
    }
}

