/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Attributes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class J2EEFileUtil {
    public static final String DOT_CLASS = ".class";
    public static final String DOT_JAVA = ".java";
    public static final String DOT_SQLJ = ".sqlj";
    public static final String DOT_JSP = ".jsp";
    protected static boolean isRuntime = false;
    protected static boolean shouldUseTempDirectoryForRead = true;
    protected static String tempDirectoryName;
    protected static File tempDirectory;
    public static boolean INCLUDE_EMPTY_DIRECTORIES;

    static {
        INCLUDE_EMPTY_DIRECTORIES = true;
    }

    protected static ModuleFile getModuleFileUsingAltDD(EARFile ear, Resource res) {
        if (res == null) {
            return null;
        }
        String uri = res.getURI().toString();
        Module m = ear.getDeploymentDescriptor().getModuleHavingAltDD(uri);
        if (m == null) {
            return null;
        }
        ModuleRef ref = ear.getModuleRef(m);
        if (ref == null) {
            return null;
        }
        return ref.getModuleFile();
    }

    public static String getModuleFileTypeName(int moduleType) {
        switch (moduleType) {
            case 2: {
                return CommonArchiveResourceHandler.A_Application_file;
            }
            case 1: {
                return CommonArchiveResourceHandler.An_Application_Client_JAR_file;
            }
            case 3: {
                return CommonArchiveResourceHandler.An_EJB_JAR_file;
            }
            case 4: {
                return CommonArchiveResourceHandler.A_WAR_file;
            }
            case 5: {
                return CommonArchiveResourceHandler.A_RAR_file;
            }
        }
        return null;
    }

    public static String getOSUri(String uri) {
        char sep = File.separatorChar;
        if (sep != '/') {
            return uri.replace('/', sep);
        }
        return uri.replace('\\', sep);
    }

    public static EObject getRoot(Resource aResource) throws EmptyResourceException {
        EList extent = aResource.getContents();
        if (extent.size() < 1) {
            throw new EmptyResourceException(aResource.getURI().toString());
        }
        return (EObject)extent.get(0);
    }

    public static File getTempDirectory() {
        return tempDirectory;
    }

    public static String getTempDirectoryName() {
        return tempDirectoryName;
    }

    public static String[] getTokens(String aString) {
        return J2EEFileUtil.getTokens(aString, null);
    }

    public static String[] getTokens(String aString, String delimiter) {
        StringTokenizer tok = delimiter == null ? new StringTokenizer(aString) : new StringTokenizer(aString, delimiter);
        int size = tok.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (i < size && tok.hasMoreTokens()) {
            tokens[i] = tok.nextToken();
            ++i;
        }
        return tokens;
    }

    public static String getValueIgnoreKeyCase(String key, Attributes attr) {
        for (Map.Entry<Object, Object> entry : attr.entrySet()) {
            String entryKey = entry.getKey().toString();
            if (!entryKey.equalsIgnoreCase(key)) continue;
            return entry.getValue() == null ? null : entry.getValue().toString();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static boolean isJ2EE13FastCheck(ModuleFile moduleFile) {
        String[] ids;
        DocumentType docType;
        InputStream in;
        block24: {
            block23: {
                if (moduleFile == null) {
                    return false;
                }
                if (moduleFile.isRARFile()) {
                    return true;
                }
                in = null;
                String uri = moduleFile.getDeploymentDescriptorUri();
                in = moduleFile.getInputStream(uri);
                docType = XmlDocumentReader.readDocumentType(in, uri);
                if (docType != null) break block23;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            ids = J2EEFileUtil.getJ2EE13PublicAndSystemIdFor(moduleFile);
            if (ids != null) break block24;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
        boolean bl = ids[0].equals(docType.getPublicId()) && ids[1].equals(docType.getSystemId());
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    protected static String[] getJ2EE13PublicAndSystemIdFor(ModuleFile moduleFile) {
        if (moduleFile.isEARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "http://java.sun.com/dtd/application_1_3.dtd"};
        }
        if (moduleFile.isEJBJarFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/dtd/ejb-jar_2_0.dtd"};
        }
        if (moduleFile.isApplicationClientFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "http://java.sun.com/dtd/application-client_1_3.dtd"};
        }
        if (moduleFile.isWARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd"};
        }
        if (moduleFile.isRARFile()) {
            return new String[]{"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "http://java.sun.com/dtd/connector_1_0.dtd"};
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static int getFastSpecVersion(String fileURI) {
        FileInputStream in = null;
        in = new FileInputStream(fileURI);
        DocumentType docType = null;
        InputSource source = new InputSource(in);
        XmlDocumentReader aReader = new XmlDocumentReader(source);
        aReader.setValidate(false);
        Document aDocument = aReader.parseDocument();
        if (aDocument != null) {
            docType = aDocument.getDoctype();
        }
        int version = -1;
        if (docType != null) {
            String publicID = docType.getPublicId();
            String systemID = docType.getSystemId();
            if (publicID != null && systemID != null) {
                version = J2EEFileUtil.lookupVersion(fileURI, publicID, systemID);
            }
        }
        if (version == -1) {
            NamedNodeMap map;
            String schemaName = null;
            String versionString = null;
            if (aDocument != null && docType == null && (map = aDocument.getDocumentElement().getAttributes()) != null) {
                Node versionNode;
                Node schemaNode = map.getNamedItem("xsi:schemaLocation");
                if (schemaNode != null) {
                    schemaName = schemaNode.getNodeValue();
                }
                if ((versionNode = map.getNamedItem("version")) != null) {
                    versionString = versionNode.getNodeValue();
                }
            }
            if (schemaName != null) {
                version = J2EEFileUtil.lookupVersion(fileURI, schemaName);
            }
            if (version == -1) {
                version = J2EEFileUtil.parseVersionString(fileURI, versionString);
            }
        }
        int n = version;
        try {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        catch (IOException iOException) {}
        return n;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException3) {}
            return -1;
        }
    }

    private static int parseVersionString(String fileURI, String versionAttr) {
        int version = -1;
        if (J2EEFileUtil.isEARFile(fileURI)) {
            if (versionAttr == null) {
                version = 14;
            } else if (versionAttr.equals("1.2")) {
                version = 12;
            } else if (versionAttr.equals("1.3")) {
                version = 13;
            } else if (versionAttr.equals("1.4")) {
                version = 14;
            } else if (versionAttr.equals("5.0")) {
                version = 50;
            }
        } else if (J2EEFileUtil.isEJBJarFile(fileURI)) {
            if (versionAttr == null) {
                version = 21;
            } else if (versionAttr.equals("1.1")) {
                version = 11;
            } else if (versionAttr.equals("2.0")) {
                version = 20;
            } else if (versionAttr.equals("2.1")) {
                version = 21;
            } else if (versionAttr.equals("3.0")) {
                version = 30;
            }
        } else if (J2EEFileUtil.isApplicationClientFile(fileURI)) {
            if (versionAttr == null) {
                version = 14;
            } else if (versionAttr.equals("1.2")) {
                version = 12;
            } else if (versionAttr.equals("1.3")) {
                version = 13;
            } else if (versionAttr.equals("1.4")) {
                version = 14;
            } else if (versionAttr.equals("5.0")) {
                version = 50;
            }
        } else if (J2EEFileUtil.isWARFile(fileURI)) {
            if (versionAttr == null) {
                version = 24;
            } else if (versionAttr.equals("2.2")) {
                version = 22;
            } else if (versionAttr.equals("2.3")) {
                version = 23;
            } else if (versionAttr.equals("2.4")) {
                version = 24;
            } else if (versionAttr.equals("2.5")) {
                version = 25;
            }
        } else if (J2EEFileUtil.isRARFile(fileURI)) {
            version = versionAttr == null ? 15 : (versionAttr.equals("1.0") ? 10 : 15);
        }
        return version;
    }

    private static int lookupVersion(String fileURI, String schemaName) {
        int version = -1;
        if (J2EEFileUtil.isEARFile(fileURI)) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd")) {
                version = 50;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd")) {
                version = 14;
            }
        } else if (J2EEFileUtil.isEJBJarFile(fileURI)) {
            if (schemaName.indexOf("http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd") != -1) {
                version = 30;
            } else if (schemaName.indexOf("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd") != -1) {
                version = 21;
            }
        } else if (J2EEFileUtil.isApplicationClientFile(fileURI)) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd")) {
                version = 50;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd")) {
                version = 14;
            }
        } else if (J2EEFileUtil.isWARFile(fileURI)) {
            if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd")) {
                version = 25;
            } else if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd")) {
                version = 24;
            }
        } else if (J2EEFileUtil.isRARFile(fileURI) && schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd")) {
            version = 15;
        }
        return version;
    }

    private static int lookupVersion(String fileURI, String publicID, String systemID) {
        int version = -1;
        if (J2EEFileUtil.isEARFile(fileURI)) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application_1.2.dtd")) ? 12 : 14);
        } else if (J2EEFileUtil.isEJBJarFile(fileURI)) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN") && (systemID.equals("http://java.sun.com/dtd/ejb-jar_2_0.dtd") || systemID.equals("http://java.sun.com/dtd/ejb-jar_2.0.dtd")) ? 20 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/ejb-jar_1.1.dtd")) ? 11 : 21);
        } else if (J2EEFileUtil.isApplicationClientFile(fileURI)) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN") && (systemID.equals("http://java.sun.com/dtd/application-client_1_3.dtd") || systemID.equals("http://java.sun.com/dtd/application-client_1.3.dtd")) ? 13 : (publicID.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/application-client_1.2.dtd")) ? 12 : 14);
        } else if (J2EEFileUtil.isWARFile(fileURI)) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") && (systemID.equals("http://java.sun.com/dtd/web-app_2_3.dtd") || systemID.equals("http://java.sun.com/dtd/web-app_2.3.dtd")) ? 23 : (publicID.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") && (systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") || systemID.equals("http://java.sun.com/j2ee/dtds/web-app_2.2.dtd")) ? 22 : 24);
        } else if (J2EEFileUtil.isRARFile(fileURI)) {
            version = publicID.equals("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN") && (systemID.equals("http://java.sun.com/dtd/connector_1_0.dtd") || systemID.equals("http://java.sun.com/dtd/connector_1.0.dtd")) ? 10 : 15;
        }
        return version;
    }

    private static boolean isRARFile(String fileURI) {
        return fileURI.indexOf("ra.xml") != -1;
    }

    private static boolean isWARFile(String fileURI) {
        return fileURI.indexOf("web.xml") != -1;
    }

    private static boolean isApplicationClientFile(String fileURI) {
        return fileURI.indexOf("application-client.xml") != -1;
    }

    private static boolean isEJBJarFile(String fileURI) {
        return fileURI.indexOf("ejb-jar.xml") != -1;
    }

    private static boolean isEARFile(String fileURI) {
        return fileURI.indexOf("application.xml") != -1;
    }
}

