/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.node;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.jpt.utility.internal.SynchronizedBoolean;
import org.eclipse.jpt.utility.internal.node.Node;

public class RunnableValidation
implements Runnable {
    private final Node node;
    private final SynchronizedBoolean validateFlag;
    private final SynchronizedBoolean continueFlag;
    private final Logger exceptionLogger;
    private final Level exceptionLevel;
    private final String exceptionMessage;

    public RunnableValidation(Node node, SynchronizedBoolean validateFlag, SynchronizedBoolean continueFlag, Logger exceptionLogger, Level exceptionLevel, String exceptionMessage) {
        this.node = node;
        this.validateFlag = validateFlag;
        this.continueFlag = continueFlag;
        this.exceptionLogger = exceptionLogger;
        this.exceptionLevel = exceptionLevel;
        this.exceptionMessage = exceptionMessage;
    }

    public void run() {
        while (this.continueFlag.isTrue()) {
            try {
                this.validateFlag.waitToSetFalse();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.validateNode();
        }
    }

    private void validateNode() {
        try {
            this.node.validateBranch();
        }
        catch (Throwable ex) {
            this.logException(ex);
        }
    }

    private void logException(Throwable ex) {
        LogRecord logRecord = new LogRecord(this.exceptionLevel, this.exceptionMessage);
        logRecord.setParameters(new Object[]{this.node.displayString()});
        logRecord.setThrown(ex);
        logRecord.setLoggerName(this.exceptionLogger.getName());
        logRecord.setResourceBundle(this.exceptionLogger.getResourceBundle());
        this.exceptionLogger.log(logRecord);
    }
}

