/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyAspectAdapter<S extends Model, T>
extends AspectAdapter<S>
implements WritablePropertyValueModel<T> {
    protected T value;
    protected final String[] propertyNames;
    protected static final String[] EMPTY_PROPERTY_NAMES = new String[0];
    protected final PropertyChangeListener propertyChangeListener;

    protected PropertyAspectAdapter(String propertyName, S subject) {
        this(new String[]{propertyName}, subject);
    }

    protected PropertyAspectAdapter(String[] propertyNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), propertyNames);
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectHolder, String ... propertyNames) {
        super(subjectHolder);
        this.propertyNames = propertyNames;
        this.propertyChangeListener = this.buildPropertyChangeListener();
        this.value = null;
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectHolder, Collection<String> propertyNames) {
        this(subjectHolder, propertyNames.toArray(new String[propertyNames.size()]));
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        this(subjectHolder, EMPTY_PROPERTY_NAMES);
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                PropertyAspectAdapter.this.propertyChanged();
            }

            public String toString() {
                return "property change listener: " + Arrays.asList(PropertyAspectAdapter.this.propertyNames);
            }
        };
    }

    @Override
    public final T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        if (this.subject != null) {
            this.setValue_(value);
        }
    }

    protected void setValue_(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Class<? extends ChangeListener> getListenerClass() {
        return PropertyChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "value";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.firePropertyChanged("value", oldValue, newValue);
    }

    @Override
    protected void engageSubject() {
        super.engageSubject();
        this.value = this.buildValue();
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.subject).addPropertyChangeListener(propertyName, this.propertyChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject() {
        super.disengageSubject();
        this.value = null;
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.subject).removePropertyChangeListener(propertyName, this.propertyChangeListener);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        int i = 0;
        while (i < this.propertyNames.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.propertyNames[i]);
            ++i;
        }
    }

    protected T buildValue() {
        return this.subject == null ? null : (T)this.buildValue_();
    }

    protected T buildValue_() {
        throw new UnsupportedOperationException();
    }

    protected void propertyChanged() {
        T old = this.value;
        this.value = this.buildValue();
        this.fireAspectChange(old, this.value);
    }
}

