/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.Counter;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModelWrapper;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemAspectListValueModelAdapter<E>
extends ListValueModelWrapper<E>
implements ListValueModel<E> {
    protected final IdentityHashMap<E, Counter> counters = new IdentityHashMap();

    protected ItemAspectListValueModelAdapter(ListValueModel<? extends E> listHolder) {
        super(listHolder);
    }

    protected ItemAspectListValueModelAdapter(CollectionValueModel<? extends E> collectionHolder) {
        this(new CollectionListValueModelAdapter<E>(collectionHolder));
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this.listHolder.listIterator());
    }

    @Override
    public E get(int index) {
        return this.listHolder.get(index);
    }

    @Override
    public int size() {
        return this.listHolder.size();
    }

    @Override
    public Object[] toArray() {
        return this.listHolder.toArray();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.engageAllItems();
    }

    protected void engageAllItems() {
        this.engageItems(this.listHolder.iterator());
    }

    protected void engageItems(Iterator<? extends E> stream) {
        while (stream.hasNext()) {
            this.engageItem(stream.next());
        }
    }

    protected void engageItem(E item) {
        Counter counter = this.counters.get(item);
        if (counter == null) {
            counter = new Counter();
            this.counters.put(item, counter);
            this.startListeningToItem((Model)item);
        }
        counter.increment();
    }

    protected abstract void startListeningToItem(Model var1);

    @Override
    protected void disengageModel() {
        this.disengageAllItems();
        super.disengageModel();
    }

    protected void disengageAllItems() {
        this.disengageItems(this.listHolder.iterator());
    }

    protected void disengageItems(Iterator<? extends E> stream) {
        while (stream.hasNext()) {
            this.disengageItem(stream.next());
        }
    }

    protected void disengageItem(E item) {
        Counter counter = this.counters.get(item);
        if (counter == null) {
            throw new IllegalStateException("missing counter: " + item);
        }
        if (counter.decrement() == 0) {
            this.counters.remove(item);
            this.stopListeningToItem((Model)item);
        }
    }

    protected abstract void stopListeningToItem(Model var1);

    @Override
    protected void itemsAdded(ListChangeEvent event) {
        this.fireItemsAdded(event.cloneWithSource(this, "list values"));
        this.engageItems(this.items(event));
    }

    @Override
    protected void itemsRemoved(ListChangeEvent event) {
        this.disengageItems(this.items(event));
        this.fireItemsRemoved(event.cloneWithSource(this, "list values"));
    }

    @Override
    protected void itemsReplaced(ListChangeEvent event) {
        this.disengageItems(this.replacedItems(event));
        this.fireItemsReplaced(event.cloneWithSource(this, "list values"));
        this.engageItems(this.items(event));
    }

    @Override
    protected void itemsMoved(ListChangeEvent event) {
        this.fireItemsMoved(event.cloneWithSource(this, "list values"));
    }

    @Override
    protected void listCleared(ListChangeEvent event) {
        ArrayList<E> keys = new ArrayList<E>(this.counters.keySet());
        this.disengageItems(keys.iterator());
        this.counters.clear();
        this.fireListCleared("list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        ArrayList<E> keys = new ArrayList<E>(this.counters.keySet());
        this.disengageItems(keys.iterator());
        this.counters.clear();
        this.fireListChanged("list values");
        this.engageAllItems();
    }

    protected void itemAspectChanged(EventObject event) {
        Object item = event.getSource();
        int index = this.lastIdentityIndexOf(item);
        while (index != -1) {
            this.itemAspectChanged(index, item);
            index = this.lastIdentityIndexOf(item, index);
        }
    }

    protected void itemAspectChanged(int index, Object item) {
        this.fireItemReplaced("list values", index, item, item);
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.listHolder.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.listHolder.get(i) != o) continue;
            return i;
        }
        return -1;
    }
}

