/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.util.EmptyStackException;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.SimpleStack;
import org.eclipse.jpt.utility.internal.Stack;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStackTests
extends TestCase {
    public SimpleStackTests(String name) {
        super(name);
    }

    public void testIsEmpty() {
        SimpleStack stack = new SimpleStack();
        SimpleStackTests.assertTrue((boolean)stack.isEmpty());
        stack.push((Object)"first");
        SimpleStackTests.assertFalse((boolean)stack.isEmpty());
        stack.push((Object)"second");
        SimpleStackTests.assertFalse((boolean)stack.isEmpty());
        stack.pop();
        SimpleStackTests.assertFalse((boolean)stack.isEmpty());
        stack.pop();
        SimpleStackTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testPushAndPop() {
        SimpleStack stack = new SimpleStack();
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        SimpleStackTests.assertEquals((String)second, (String)((String)stack.pop()));
        SimpleStackTests.assertEquals((String)first, (String)((String)stack.pop()));
    }

    public void testPushAndPeek() {
        SimpleStack stack = new SimpleStack();
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        SimpleStackTests.assertEquals((String)second, (String)((String)stack.peek()));
        SimpleStackTests.assertEquals((String)second, (String)((String)stack.peek()));
        SimpleStackTests.assertEquals((String)second, (String)((String)stack.pop()));
        SimpleStackTests.assertEquals((String)first, (String)((String)stack.peek()));
        SimpleStackTests.assertEquals((String)first, (String)((String)stack.peek()));
        SimpleStackTests.assertEquals((String)first, (String)((String)stack.pop()));
    }

    public void testEmptyStackExceptionPeek() {
        SimpleStack stack = new SimpleStack();
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        SimpleStackTests.assertEquals((String)second, (String)((String)stack.peek()));
        SimpleStackTests.assertEquals((String)second, (String)((String)stack.pop()));
        SimpleStackTests.assertEquals((String)first, (String)((String)stack.peek()));
        SimpleStackTests.assertEquals((String)first, (String)((String)stack.pop()));
        boolean exCaught = false;
        try {
            stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            exCaught = true;
        }
        SimpleStackTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyStackExceptionPop() {
        SimpleStack stack = new SimpleStack();
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        SimpleStackTests.assertEquals((String)second, (String)((String)stack.peek()));
        SimpleStackTests.assertEquals((String)second, (String)((String)stack.pop()));
        SimpleStackTests.assertEquals((String)first, (String)((String)stack.peek()));
        SimpleStackTests.assertEquals((String)first, (String)((String)stack.pop()));
        boolean exCaught = false;
        try {
            stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            exCaught = true;
        }
        SimpleStackTests.assertTrue((boolean)exCaught);
    }

    public void testClone() {
        SimpleStack stack = new SimpleStack();
        stack.push((Object)"first");
        stack.push((Object)"second");
        stack.push((Object)"third");
        this.verifyClone((Stack<String>)stack, (Stack<String>)stack.clone());
    }

    public void testSerialization() throws Exception {
        SimpleStack stack = new SimpleStack();
        stack.push((Object)"first");
        stack.push((Object)"second");
        stack.push((Object)"third");
        this.verifyClone((Stack<String>)stack, (Stack<String>)((Stack)TestTools.serialize(stack)));
    }

    private void verifyClone(Stack<String> original, Stack<String> clone) {
        SimpleStackTests.assertNotSame(original, clone);
        SimpleStackTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        SimpleStackTests.assertEquals((String)((String)original.pop()), (String)((String)clone.pop()));
        SimpleStackTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        SimpleStackTests.assertEquals((String)((String)original.pop()), (String)((String)clone.pop()));
        SimpleStackTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        SimpleStackTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        SimpleStackTests.assertEquals((String)((String)original.pop()), (String)((String)clone.pop()));
        SimpleStackTests.assertTrue((boolean)original.isEmpty());
        SimpleStackTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.push((Object)"fourth");
        SimpleStackTests.assertFalse((boolean)original.isEmpty());
        SimpleStackTests.assertTrue((boolean)clone.isEmpty());
    }
}

