/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.sql.Types;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.JDBCType;

public class JDBCTypeTests
extends TestCase {
    public JDBCTypeTests(String name) {
        super(name);
    }

    public void testTypesSize() {
        JDBCTypeTests.assertEquals((int)Types.class.getDeclaredFields().length, (int)JDBCType.types().length);
    }

    public void testName() {
        JDBCType jdbcType = JDBCType.type((int)12);
        JDBCTypeTests.assertEquals((String)"VARCHAR", (String)jdbcType.name());
        jdbcType = JDBCType.type((int)4);
        JDBCTypeTests.assertEquals((String)"INTEGER", (String)jdbcType.name());
    }

    public void testCode() {
        JDBCType jdbcType = JDBCType.type((int)12);
        JDBCTypeTests.assertEquals((int)12, (int)jdbcType.code());
        jdbcType = JDBCType.type((int)4);
        JDBCTypeTests.assertEquals((int)4, (int)jdbcType.code());
    }

    public void testInvalidTypeCode() throws Exception {
        boolean exCaught = false;
        try {
            JDBCType jdbcType = JDBCType.type((int)55);
            JDBCTypeTests.fail((String)("invalid JDBCType: " + jdbcType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JDBCTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidTypeName() throws Exception {
        boolean exCaught = false;
        try {
            JDBCType jdbcType = JDBCType.type((String)"VARCHAR2");
            JDBCTypeTests.fail((String)("invalid JDBCType: " + jdbcType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JDBCTypeTests.assertTrue((boolean)exCaught);
    }
}

