/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.entity.data.model;

import java.util.Arrays;
import java.util.List;

public class EntityRow {
    private static final String DOT = ".";
    private boolean key = false;
    private String name = "";
    private String type = "";
    private String fqnTypeName = "";
    private boolean isSimpleType = false;
    private static final String[] PK_TYPES = new String[]{"int", "long", "short", "char", "boolean", "byte", "double", "float", "java.lang.String", "java.sql.Date", "java.util.Date", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Character", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float"};
    private static final List<String> VALID_PK_TYPES = Arrays.asList(PK_TYPES);

    public EntityRow() {
    }

    public EntityRow(String fqnTypeName, String name, boolean isKey) {
        this.fqnTypeName = this.type;
        this.name = name;
        this.key = isKey;
        if (fqnTypeName.indexOf(DOT) == -1) {
            this.type = fqnTypeName;
            this.isSimpleType = true;
        } else {
            this.type = this.getSimpleName(fqnTypeName);
        }
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public boolean couldBeKey() {
        boolean result = false;
        result = VALID_PK_TYPES.contains(this.getFqnTypeName());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFqnTypeName() {
        return this.fqnTypeName;
    }

    public void setFqnTypeName(String fqnTypeName) {
        this.fqnTypeName = fqnTypeName;
        if (fqnTypeName.indexOf(DOT) == -1) {
            this.setType(fqnTypeName);
            this.setSimpleType(true);
        } else {
            this.setType(this.getSimpleName(fqnTypeName));
        }
    }

    public boolean isSimpleType() {
        return this.isSimpleType;
    }

    public void setSimpleType(boolean isSimpleType) {
        this.isSimpleType = isSimpleType;
    }

    public boolean isBoolean() {
        return "boolean".equals(this.getType());
    }

    private String getSimpleName(String fullyName) {
        return fullyName.substring(fullyName.lastIndexOf(DOT) + 1);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fqnTypeName == null ? 0 : this.fqnTypeName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityRow other = (EntityRow)obj;
        if (this.fqnTypeName == null ? other.fqnTypeName != null : !this.fqnTypeName.equals(other.fqnTypeName)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

