/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform.base;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JpaPlatformUiProvider;
import org.eclipse.jpt.ui.JpaUiFactory;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultAttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultTypeMappingUiProvider;
import org.eclipse.jpt.ui.details.JpaDetailsPage;
import org.eclipse.jpt.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.ui.details.TypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.platform.base.EntitiesGenerator2;
import org.eclipse.jpt.ui.navigator.JpaNavigatorProvider;
import org.eclipse.jpt.ui.structure.JpaStructureProvider;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpaPlatformUi
implements JpaPlatformUi {
    private final JpaUiFactory jpaUiFactory;
    private final JpaNavigatorProvider navigatorProvider;
    private final JpaPlatformUiProvider[] platformUiProviders;
    private JpaStructureProvider persistenceStructureProvider;
    private JpaStructureProvider javaStructureProvider;

    protected BaseJpaPlatformUi(JpaUiFactory jpaUiFactory, JpaNavigatorProvider navigatorProvider, JpaStructureProvider persistenceStructureProvider, JpaStructureProvider javaStructureProvider, JpaPlatformUiProvider ... platformUiProviders) {
        this.jpaUiFactory = jpaUiFactory;
        this.navigatorProvider = navigatorProvider;
        this.persistenceStructureProvider = persistenceStructureProvider;
        this.javaStructureProvider = javaStructureProvider;
        this.platformUiProviders = platformUiProviders;
    }

    @Override
    public JpaUiFactory getJpaUiFactory() {
        return this.jpaUiFactory;
    }

    @Override
    public JpaNavigatorProvider getNavigatorProvider() {
        return this.navigatorProvider;
    }

    protected ListIterator<JpaPlatformUiProvider> platformUiProviders() {
        return new ArrayListIterator((Object[])this.platformUiProviders);
    }

    @Override
    public JpaDetailsPage<? extends JpaStructureNode> buildJpaDetailsPage(Composite parent, JpaStructureNode structureNode, WidgetFactory widgetFactory) {
        JpaDetailsProvider jpaDetailsProvider = this.getDetailsProvider(structureNode);
        return jpaDetailsProvider == null ? null : jpaDetailsProvider.buildDetailsPage(parent, widgetFactory);
    }

    protected JpaDetailsProvider getDetailsProvider(JpaStructureNode structureNode) {
        return this.getDetailsProvider(structureNode.getContentType(), structureNode.getId());
    }

    protected JpaDetailsProvider getDetailsProvider(IContentType contentType, String id) {
        for (JpaDetailsProvider provider : CollectionTools.iterable(this.detailsProviders(id))) {
            if (!provider.getContentType().isKindOf(contentType)) continue;
            return provider;
        }
        if (contentType.getBaseType() != null) {
            return this.getDetailsProvider(contentType.getBaseType(), id);
        }
        return null;
    }

    protected Iterator<JpaDetailsProvider> detailsProviders(final String id) {
        return new FilteringIterator<JpaDetailsProvider, JpaDetailsProvider>(this.detailsProviders()){

            protected boolean accept(JpaDetailsProvider o) {
                return o.getId() == id;
            }
        };
    }

    protected ListIterator<JpaDetailsProvider> detailsProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformUiProvider, ListIterator<JpaDetailsProvider>>(this.platformUiProviders()){

            protected ListIterator<JpaDetailsProvider> transform(JpaPlatformUiProvider platformProvider) {
                return platformProvider.detailsProviders();
            }
        });
    }

    @Override
    public Iterator<TypeMappingUiProvider<? extends TypeMapping>> typeMappingUiProviders(final IContentType contentType) {
        return new FilteringIterator<TypeMappingUiProvider<? extends TypeMapping>, TypeMappingUiProvider<? extends TypeMapping>>(this.typeMappingUiProviders()){

            protected boolean accept(TypeMappingUiProvider<? extends TypeMapping> provider) {
                return contentType.equals(provider.getContentType());
            }
        };
    }

    protected ListIterator<TypeMappingUiProvider<? extends TypeMapping>> typeMappingUiProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformUiProvider, ListIterator<TypeMappingUiProvider<? extends TypeMapping>>>(this.platformUiProviders()){

            protected ListIterator<TypeMappingUiProvider<? extends TypeMapping>> transform(JpaPlatformUiProvider platformProvider) {
                return platformProvider.typeMappingUiProviders();
            }
        });
    }

    @Override
    public DefaultTypeMappingUiProvider<? extends TypeMapping> getDefaultTypeMappingUiProvider(IContentType contentType) {
        for (DefaultTypeMappingUiProvider provider : CollectionTools.iterable(this.defaultTypeMappingUiProviders())) {
            if (!provider.getContentType().equals(contentType)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public TypeMappingUiProvider<? extends TypeMapping> getTypeMappingUiProvider(String key, IContentType contentType) {
        for (TypeMappingUiProvider provider : CollectionTools.iterable(this.typeMappingUiProviders(contentType))) {
            if (key != provider.getKey()) continue;
            return provider;
        }
        throw new IllegalArgumentException("Unsupported type mapping UI provider key: " + key);
    }

    protected ListIterator<DefaultTypeMappingUiProvider<? extends TypeMapping>> defaultTypeMappingUiProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformUiProvider, ListIterator<DefaultTypeMappingUiProvider<? extends TypeMapping>>>(this.platformUiProviders()){

            protected ListIterator<DefaultTypeMappingUiProvider<? extends TypeMapping>> transform(JpaPlatformUiProvider platformProvider) {
                return platformProvider.defaultTypeMappingUiProviders();
            }
        });
    }

    @Override
    public Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> attributeMappingUiProviders(final IContentType contentType) {
        return new FilteringIterator<AttributeMappingUiProvider<? extends AttributeMapping>, AttributeMappingUiProvider<? extends AttributeMapping>>(this.attributeMappingUiProviders()){

            protected boolean accept(AttributeMappingUiProvider<? extends AttributeMapping> provider) {
                return contentType.equals(provider.getContentType());
            }
        };
    }

    protected ListIterator<AttributeMappingUiProvider<? extends AttributeMapping>> attributeMappingUiProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformUiProvider, ListIterator<AttributeMappingUiProvider<? extends AttributeMapping>>>(this.platformUiProviders()){

            protected ListIterator<AttributeMappingUiProvider<? extends AttributeMapping>> transform(JpaPlatformUiProvider platformProvider) {
                return platformProvider.attributeMappingUiProviders();
            }
        });
    }

    @Override
    public Iterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> defaultAttributeMappingUiProviders(final IContentType contentType) {
        return new FilteringIterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>, DefaultAttributeMappingUiProvider<? extends AttributeMapping>>(this.defaultAttributeMappingUiProviders()){

            protected boolean accept(DefaultAttributeMappingUiProvider<? extends AttributeMapping> provider) {
                return provider.getContentType().equals(contentType);
            }
        };
    }

    @Override
    public DefaultAttributeMappingUiProvider<? extends AttributeMapping> getDefaultAttributeMappingUiProvider(String key, IContentType contentType) {
        for (DefaultAttributeMappingUiProvider provider : CollectionTools.iterable(this.defaultAttributeMappingUiProviders(contentType))) {
            if (key != provider.getDefaultKey()) continue;
            return provider;
        }
        return null;
    }

    @Override
    public AttributeMappingUiProvider<? extends AttributeMapping> getAttributeMappingUiProvider(String key, IContentType contentType) {
        for (AttributeMappingUiProvider provider : CollectionTools.iterable(this.attributeMappingUiProviders(contentType))) {
            if (key != provider.getKey()) continue;
            return provider;
        }
        throw new IllegalArgumentException("Unsupported attribute mapping UI provider key: ");
    }

    protected ListIterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> defaultAttributeMappingUiProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformUiProvider, ListIterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>>>(this.platformUiProviders()){

            protected ListIterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> transform(JpaPlatformUiProvider platformProvider) {
                return platformProvider.defaultAttributeMappingUiProviders();
            }
        });
    }

    @Override
    public JpaStructureProvider getStructureProvider(JpaFile jpaFile) {
        return this.getStructureProvider(jpaFile.getContentType());
    }

    protected JpaStructureProvider getStructureProvider(IContentType contentType) {
        for (JpaStructureProvider provider : CollectionTools.iterable(this.structureProviders())) {
            if (!provider.getContentType().isKindOf(contentType)) continue;
            return provider;
        }
        if (contentType.getBaseType() != null) {
            return this.getStructureProvider(contentType.getBaseType());
        }
        throw new IllegalArgumentException("No structure provider for the contentType: " + contentType);
    }

    protected ListIterator<JpaStructureProvider> structureProviders() {
        return new CompositeListIterator((Object)this.persistenceStructureProvider, (ListIterator)new CompositeListIterator((Object)this.javaStructureProvider, (ListIterator)new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformUiProvider, ListIterator<JpaStructureProvider>>(this.platformUiProviders()){

            protected ListIterator<JpaStructureProvider> transform(JpaPlatformUiProvider platformUiProvider) {
                return platformUiProvider.mappingFileStructureProviders();
            }
        })));
    }

    @Override
    public void generateEntities(JpaProject project, IStructuredSelection selection) {
        EntitiesGenerator2.generate(project, selection);
    }

    protected void displayMessage(String title, String message) {
        Shell currentShell = Display.getCurrent().getActiveShell();
        MessageDialog.openInformation((Shell)currentShell, (String)title, (String)message);
    }
}

