/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.NullWriteTransformerColumnAnnotation;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceTransformerAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.WriteTransformerAnnotation;

public final class SourceWriteTransformerAnnotation
extends SourceTransformerAnnotation
implements WriteTransformerAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.WriteTransformer");
    private final MemberAnnotationAdapter columnAdapter;
    private ColumnAnnotation column;

    public SourceWriteTransformerAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.columnAdapter = new MemberAnnotationAdapter(this.member, SourceWriteTransformerAnnotation.buildColumnAnnotationAdapter(this.daa));
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.WriteTransformer";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) != null) {
            this.column = SourceWriteTransformerAnnotation.createColumn((JavaResourceNode)this, this.member, this.daa);
            this.column.initialize(astRoot);
        }
    }

    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) == null) {
            this.setColumn(null);
        } else if (this.column == null) {
            ColumnAnnotation col = SourceWriteTransformerAnnotation.createColumn((JavaResourceNode)this, this.member, this.daa);
            col.initialize(astRoot);
            this.setColumn(col);
        } else {
            this.column.update(astRoot);
        }
    }

    String getTransformerClassElementName() {
        return "transformerClass";
    }

    String getMethodElementName() {
        return "method";
    }

    public ColumnAnnotation getColumn() {
        return this.column;
    }

    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : new NullWriteTransformerColumnAnnotation(this);
    }

    public ColumnAnnotation addColumn() {
        ColumnAnnotation col = SourceWriteTransformerAnnotation.createColumn((JavaResourceNode)this, this.member, this.daa);
        col.newAnnotation();
        this.setColumn(col);
        return col;
    }

    public void removeColumn() {
        this.column.removeAnnotation();
        this.setColumn(null);
    }

    private void setColumn(ColumnAnnotation newColumn) {
        ColumnAnnotation old = this.column;
        this.column = newColumn;
        this.firePropertyChanged("column", old, newColumn);
    }

    public TextRange getColumnTextRange(CompilationUnit astRoot) {
        if (this.column != null) {
            return this.column.getTextRange(astRoot);
        }
        return this.getTextRange(astRoot);
    }

    private static DeclarationAnnotationAdapter buildColumnAnnotationAdapter(DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(writeTransformerAnnotationAdapter, "column", "javax.persistence.Column", false);
    }

    private static ColumnAnnotation createColumn(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new SourceColumnAnnotation(parent, member, SourceWriteTransformerAnnotation.buildColumnAnnotationAdapter(writeTransformerAnnotationAdapter));
    }
}

